/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.AdConfig;
import com.vungle.warren.AdLoader;
import com.vungle.warren.AdRequest;
import com.vungle.warren.NativeAdLayout;
import com.vungle.warren.PresentationFactory;
import com.vungle.warren.ServiceLocator;
import com.vungle.warren.SessionTracker;
import com.vungle.warren.Vungle;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.VungleStaticApi;
import com.vungle.warren.analytics.JobDelegateAnalytics;
import com.vungle.warren.downloader.DownloadRequest;
import com.vungle.warren.downloader.Downloader;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.AdAsset;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.model.Placement;
import com.vungle.warren.model.SessionData;
import com.vungle.warren.omsdk.OMTracker;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.session.SessionAttribute;
import com.vungle.warren.session.SessionEvent;
import com.vungle.warren.tasks.JobRunner;
import com.vungle.warren.ui.CloseDelegate;
import com.vungle.warren.ui.JavascriptBridge;
import com.vungle.warren.ui.OrientationDelegate;
import com.vungle.warren.ui.contract.AdContract;
import com.vungle.warren.ui.contract.NativeAdContract;
import com.vungle.warren.ui.contract.WebAdContract;
import com.vungle.warren.ui.presenter.LocalAdPresenter;
import com.vungle.warren.ui.presenter.MRAIDAdPresenter;
import com.vungle.warren.ui.presenter.NativeAdPresenter;
import com.vungle.warren.ui.state.OptionsState;
import com.vungle.warren.ui.view.FullAdWidget;
import com.vungle.warren.ui.view.LocalAdView;
import com.vungle.warren.ui.view.MRAIDAdView;
import com.vungle.warren.ui.view.NativeAdView;
import com.vungle.warren.ui.view.VungleWebClient;
import com.vungle.warren.utility.Executors;
import com.vungle.warren.utility.HandlerScheduler;
import com.vungle.warren.utility.VungleThreadPoolExecutor;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;

public class AdvertisementPresentationFactory
implements PresentationFactory {
    private static final String TAG = AdvertisementPresentationFactory.class.getSimpleName();
    private static final String EXTRA_ADVERTISEMENT = "ADV_FACTORY_ADVERTISEMENT";
    private final JobRunner jobRunner;
    private VungleApiClient apiClient;
    private BaseTask task;
    private Repository repository;
    private VungleStaticApi vungleStaticApi;
    private Advertisement currentAdvertisement;
    private final AdLoader adLoader;
    private final OMTracker.Factory omTrackerFactory;
    private final ExecutorService taskExecutor;
    private BaseTask.OnModelLoadListener onModelLoadListener = new BaseTask.OnModelLoadListener(){

        @Override
        public void onLoad(Advertisement ad, Placement pl) {
            AdvertisementPresentationFactory.this.currentAdvertisement = ad;
        }
    };

    AdvertisementPresentationFactory(@NonNull AdLoader adLoader, @NonNull VungleStaticApi vungleStaticApi, @NonNull Repository repository, @NonNull VungleApiClient vungleApiClient, @NonNull JobRunner jobRunner, @NonNull OMTracker.Factory omTrackerFactory, @NonNull ExecutorService taskExecutor) {
        this.vungleStaticApi = vungleStaticApi;
        this.repository = repository;
        this.apiClient = vungleApiClient;
        this.jobRunner = jobRunner;
        this.adLoader = adLoader;
        this.omTrackerFactory = omTrackerFactory;
        this.taskExecutor = taskExecutor;
    }

    @Override
    public void getFullScreenPresentation(@NonNull Context context, @NonNull AdRequest request, @NonNull FullAdWidget fullAdWidget, @Nullable OptionsState optionsState, @NonNull CloseDelegate closeDelegate, @NonNull OrientationDelegate orientationDelegate, @Nullable Bundle savedState, @NonNull PresentationFactory.FullScreenCallback fullscreenCallback) {
        this.cancelTask();
        this.task = new FullScreenPresentationTask(context, this.adLoader, request, this.repository, this.vungleStaticApi, this.jobRunner, this.apiClient, fullAdWidget, optionsState, orientationDelegate, closeDelegate, fullscreenCallback, this.onModelLoadListener, savedState, this.omTrackerFactory);
        this.task.executeOnExecutor(this.taskExecutor, new Void[0]);
    }

    private void cancelTask() {
        if (this.task != null) {
            this.task.cancel(true);
            this.task.clear();
        }
    }

    @Override
    public void getBannerViewPresentation(Context context, @NonNull AdRequest request, @Nullable AdConfig adConfig, @NonNull CloseDelegate closeDelegate, @NonNull PresentationFactory.ViewCallback viewCallback) {
        this.cancelTask();
        this.task = new BannerViewPresentationTask(context, request, adConfig, this.adLoader, this.repository, this.vungleStaticApi, this.jobRunner, viewCallback, null, this.onModelLoadListener, this.apiClient, this.omTrackerFactory);
        this.task.executeOnExecutor(this.taskExecutor, new Void[0]);
    }

    @Override
    public void getNativeViewPresentation(@NonNull Context context, @NonNull NativeAdLayout nativeAdLayout, @NonNull AdRequest request, @Nullable AdConfig adConfig, @NonNull PresentationFactory.NativeViewCallback viewCallback) {
        this.cancelTask();
        this.task = new NativeViewPresentationTask(context, nativeAdLayout, request, adConfig, this.adLoader, this.repository, this.vungleStaticApi, this.jobRunner, viewCallback, null, this.onModelLoadListener);
        this.task.executeOnExecutor(this.taskExecutor, new Void[0]);
    }

    @Override
    public void saveState(Bundle bundle) {
        bundle.putString(EXTRA_ADVERTISEMENT, this.currentAdvertisement == null ? null : this.currentAdvertisement.getId());
    }

    @Override
    public void destroy() {
        this.cancelTask();
    }

    private static abstract class BaseTask
    extends AsyncTask<Void, Void, PresentationResultHolder> {
        protected final Repository repository;
        protected final VungleStaticApi vungleStaticApi;
        private OnModelLoadListener onDataLoadedListener;
        private AtomicReference<Advertisement> adRef = new AtomicReference();
        private AtomicReference<Placement> plRef = new AtomicReference();
        private AdLoader adLoader;
        private Downloader downloader;

        BaseTask(Repository repository, VungleStaticApi vungleStaticApi, OnModelLoadListener onModelLoadListener) {
            this.repository = repository;
            this.vungleStaticApi = vungleStaticApi;
            this.onDataLoadedListener = onModelLoadListener;
            Context context = Vungle.appContext();
            if (context != null) {
                ServiceLocator serviceLocator = ServiceLocator.getInstance(context);
                this.adLoader = serviceLocator.getService(AdLoader.class);
                this.downloader = serviceLocator.getService(Downloader.class);
            }
        }

        Pair<Advertisement, Placement> loadPresentationData(AdRequest request, Bundle savedInstanceState) throws VungleException {
            if (!this.vungleStaticApi.isInitialized()) {
                SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.PLAY_AD).addData(SessionAttribute.SUCCESS, false).build());
                throw new VungleException(9);
            }
            if (request == null || TextUtils.isEmpty((CharSequence)request.getPlacementId())) {
                SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.PLAY_AD).addData(SessionAttribute.SUCCESS, false).build());
                throw new VungleException(10);
            }
            Placement placement = this.repository.load(request.getPlacementId(), Placement.class).get();
            if (placement == null) {
                Log.e((String)TAG, (String)"No Placement for ID");
                SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.PLAY_AD).addData(SessionAttribute.SUCCESS, false).build());
                throw new VungleException(13);
            }
            if (placement.isMultipleHBPEnabled() && request.getEventId() == null) {
                SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.PLAY_AD).addData(SessionAttribute.SUCCESS, false).build());
                throw new VungleException(36);
            }
            this.plRef.set(placement);
            Advertisement advertisement = null;
            if (savedInstanceState == null) {
                advertisement = this.repository.findValidAdvertisementForPlacement(request.getPlacementId(), request.getEventId()).get();
            } else {
                String adId = savedInstanceState.getString(AdvertisementPresentationFactory.EXTRA_ADVERTISEMENT);
                if (!TextUtils.isEmpty((CharSequence)adId)) {
                    advertisement = this.repository.load(adId, Advertisement.class).get();
                }
            }
            if (advertisement == null) {
                SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.PLAY_AD).addData(SessionAttribute.SUCCESS, false).build());
                throw new VungleException(10);
            }
            this.adRef.set(advertisement);
            File assetDir = this.repository.getAdvertisementAssetDirectory(advertisement.getId()).get();
            if (assetDir == null || !assetDir.isDirectory()) {
                Log.e((String)TAG, (String)"Advertisement assets dir is missing");
                SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.PLAY_AD).addData(SessionAttribute.SUCCESS, false).addData(SessionAttribute.EVENT_ID, advertisement.getId()).build());
                throw new VungleException(26);
            }
            if (this.adLoader != null && this.downloader != null && this.adLoader.isAdLoadOptimizationEnabled(advertisement)) {
                Log.d((String)TAG, (String)"Try to cancel downloading assets.");
                List<DownloadRequest> requests = this.downloader.getAllRequests();
                for (DownloadRequest req : requests) {
                    if (!advertisement.getId().equals(req.getAdvertisementId())) continue;
                    Log.d((String)TAG, (String)("Cancel downloading: " + req));
                    this.downloader.cancel(req);
                }
            }
            return new Pair((Object)advertisement, (Object)placement);
        }

        protected void onPostExecute(PresentationResultHolder presentationResultHolder) {
            super.onPostExecute((Object)presentationResultHolder);
            if (this.onDataLoadedListener != null) {
                this.onDataLoadedListener.onLoad(this.adRef.get(), this.plRef.get());
            }
        }

        void clear() {
            this.onDataLoadedListener = null;
        }

        static interface OnModelLoadListener {
            public void onLoad(Advertisement var1, Placement var2);
        }
    }

    private static class NativeViewPresentationTask
    extends BaseTask {
        @SuppressLint(value={"StaticFieldLeak"})
        private Context context;
        @SuppressLint(value={"StaticFieldLeak"})
        private NativeAdLayout nativeAdLayout;
        private final AdRequest request;
        private final AdConfig adConfig;
        private final PresentationFactory.NativeViewCallback nativeViewCallback;
        private final Bundle savedState;
        private final JobRunner jobRunner;
        private final AdLoader adLoader;

        NativeViewPresentationTask(Context context, NativeAdLayout nativeAdLayout, AdRequest request, AdConfig adConfig, AdLoader adLoader, Repository repository, VungleStaticApi vungleStaticApi, JobRunner jobRunner, PresentationFactory.NativeViewCallback nativeViewCallback, Bundle savedState, BaseTask.OnModelLoadListener onModelLoadListener) {
            super(repository, vungleStaticApi, onModelLoadListener);
            this.context = context;
            this.nativeAdLayout = nativeAdLayout;
            this.request = request;
            this.adConfig = adConfig;
            this.nativeViewCallback = nativeViewCallback;
            this.savedState = savedState;
            this.jobRunner = jobRunner;
            this.adLoader = adLoader;
        }

        @Override
        void clear() {
            super.clear();
            this.context = null;
            this.nativeAdLayout = null;
        }

        protected PresentationResultHolder doInBackground(Void ... voids) {
            List<AdAsset> adAssets;
            boolean isAdDownloadOptEnabled;
            Pair<Advertisement, Placement> data;
            try {
                data = this.loadPresentationData(this.request, this.savedState);
            }
            catch (VungleException e2) {
                return new PresentationResultHolder(e2);
            }
            Advertisement advertisement = (Advertisement)data.first;
            if (advertisement.getAdType() != 1) {
                Log.e((String)TAG, (String)"Invalid Ad Type for Native Ad.");
                return new PresentationResultHolder(new VungleException(10));
            }
            Placement placement = (Placement)data.second;
            if (!this.adLoader.canPlayAd(advertisement)) {
                Log.e((String)TAG, (String)"Advertisement is null or assets are missing");
                return new PresentationResultHolder(new VungleException(10));
            }
            Cookie configCookie = this.repository.load("configSettings", Cookie.class).get();
            boolean bl = isAdDownloadOptEnabled = configCookie != null && configCookie.getBoolean("isAdDownloadOptEnabled") != false;
            if (isAdDownloadOptEnabled && !advertisement.assetsFullyDownloaded && !(adAssets = this.repository.loadAllAdAssetByStatus(advertisement.getId(), 3)).isEmpty()) {
                advertisement.updateMRAIDTokensFromAssetDB(adAssets);
                try {
                    this.repository.save(advertisement);
                }
                catch (DatabaseHelper.DBException e3) {
                    Log.e((String)TAG, (String)"Unable to update tokens");
                }
            }
            JobDelegateAnalytics adAnalytics = new JobDelegateAnalytics(this.jobRunner);
            File assetDir = this.repository.getAdvertisementAssetDirectory(advertisement.getId()).get();
            if (assetDir == null || !assetDir.isDirectory()) {
                Log.e((String)TAG, (String)"Advertisement assets dir is missing");
                return new PresentationResultHolder(new VungleException(26));
            }
            if (!advertisement.isNativeTemplateType()) {
                return new PresentationResultHolder(new VungleException(10));
            }
            advertisement.configure(this.adConfig);
            try {
                this.repository.save(advertisement);
            }
            catch (DatabaseHelper.DBException e4) {
                return new PresentationResultHolder(new VungleException(26));
            }
            NativeAdPresenter presenter = new NativeAdPresenter(advertisement, placement, this.repository, new HandlerScheduler(), adAnalytics, null, this.request.getImpression());
            NativeAdView nativeAdView = new NativeAdView(this.context, this.nativeAdLayout);
            return new PresentationResultHolder(nativeAdView, presenter, null);
        }

        @Override
        protected void onPostExecute(PresentationResultHolder result) {
            super.onPostExecute(result);
            if (!this.isCancelled() && this.nativeViewCallback != null) {
                this.nativeViewCallback.onResult((Pair<NativeAdContract.NativeView, NativeAdContract.NativePresenter>)new Pair((Object)((NativeAdContract.NativeView)result.adView), (Object)((NativeAdContract.NativePresenter)result.advertisementPresenter)), result.exception);
            }
        }
    }

    private static class BannerViewPresentationTask
    extends BaseTask {
        @SuppressLint(value={"StaticFieldLeak"})
        private Context context;
        private final AdRequest request;
        private final AdConfig adConfig;
        private final PresentationFactory.ViewCallback viewCallback;
        private final Bundle savedState;
        private final JobRunner jobRunner;
        private final AdLoader adLoader;
        private final VungleApiClient apiClient;
        private final OMTracker.Factory omTrackerFactory;

        BannerViewPresentationTask(Context context, AdRequest request, AdConfig adConfig, AdLoader adLoader, Repository repository, VungleStaticApi vungleStaticApi, JobRunner jobRunner, PresentationFactory.ViewCallback viewCallback, Bundle savedState, BaseTask.OnModelLoadListener onModelLoadListener, VungleApiClient apiClient, OMTracker.Factory omTrackerFactory) {
            super(repository, vungleStaticApi, onModelLoadListener);
            this.context = context;
            this.request = request;
            this.adConfig = adConfig;
            this.viewCallback = viewCallback;
            this.savedState = savedState;
            this.jobRunner = jobRunner;
            this.adLoader = adLoader;
            this.apiClient = apiClient;
            this.omTrackerFactory = omTrackerFactory;
        }

        @Override
        void clear() {
            super.clear();
            this.context = null;
        }

        protected PresentationResultHolder doInBackground(Void ... voids) {
            List<AdAsset> adAssets;
            boolean isAdDownloadOptEnabled;
            Pair<Advertisement, Placement> data;
            try {
                data = this.loadPresentationData(this.request, this.savedState);
            }
            catch (VungleException e2) {
                return new PresentationResultHolder(e2);
            }
            Advertisement advertisement = (Advertisement)data.first;
            if (advertisement.getAdType() != 1) {
                Log.e((String)TAG, (String)"Invalid Ad Type for Native Ad.");
                return new PresentationResultHolder(new VungleException(10));
            }
            Placement placement = (Placement)data.second;
            if (!this.adLoader.canPlayAd(advertisement)) {
                Log.e((String)TAG, (String)"Advertisement is null or assets are missing");
                return new PresentationResultHolder(new VungleException(10));
            }
            Cookie configCookie = this.repository.load("configSettings", Cookie.class).get();
            boolean bl = isAdDownloadOptEnabled = configCookie != null && configCookie.getBoolean("isAdDownloadOptEnabled") != false;
            if (isAdDownloadOptEnabled && !advertisement.assetsFullyDownloaded && !(adAssets = this.repository.loadAllAdAssetByStatus(advertisement.getId(), 3)).isEmpty()) {
                advertisement.updateMRAIDTokensFromAssetDB(adAssets);
                try {
                    this.repository.save(advertisement);
                }
                catch (DatabaseHelper.DBException e3) {
                    Log.e((String)TAG, (String)"Unable to update tokens");
                }
            }
            JobDelegateAnalytics adAnalytics = new JobDelegateAnalytics(this.jobRunner);
            Executors executors = ServiceLocator.getInstance(this.context).getService(Executors.class);
            VungleThreadPoolExecutor offloadExecutor = executors.getOffloadExecutor();
            VungleWebClient webClient = new VungleWebClient(advertisement, placement, offloadExecutor);
            File assetDir = this.repository.getAdvertisementAssetDirectory(advertisement.getId()).get();
            if (assetDir == null || !assetDir.isDirectory()) {
                Log.e((String)TAG, (String)"Advertisement assets dir is missing");
                return new PresentationResultHolder(new VungleException(26));
            }
            if ("mrec".equals(advertisement.getTemplateType()) && this.adConfig.getAdSize() != AdConfig.AdSize.VUNGLE_MREC) {
                Log.e((String)TAG, (String)"Corresponding AdConfig#setAdSize must be passed for the type/size of banner ad");
                return new PresentationResultHolder(new VungleException(28));
            }
            if (placement.getPlacementAdType() == 0) {
                return new PresentationResultHolder(new VungleException(10));
            }
            advertisement.configure(this.adConfig);
            try {
                this.repository.save(advertisement);
            }
            catch (DatabaseHelper.DBException e4) {
                return new PresentationResultHolder(new VungleException(26));
            }
            OMTracker omTracker = this.omTrackerFactory.make(this.apiClient.getOmEnabled() && advertisement.getOmEnabled());
            webClient.setWebViewObserver(omTracker);
            MRAIDAdPresenter presenter = new MRAIDAdPresenter(advertisement, placement, this.repository, new HandlerScheduler(), adAnalytics, webClient, null, assetDir, omTracker, this.request.getImpression());
            return new PresentationResultHolder(null, presenter, webClient);
        }

        @Override
        protected void onPostExecute(PresentationResultHolder result) {
            super.onPostExecute(result);
            if (!this.isCancelled() && this.viewCallback != null) {
                this.viewCallback.onResult((Pair<WebAdContract.WebAdPresenter, VungleWebClient>)new Pair((Object)((WebAdContract.WebAdPresenter)result.advertisementPresenter), (Object)result.webClient), result.exception);
            }
        }
    }

    private static class FullScreenPresentationTask
    extends BaseTask {
        private final AdLoader adLoader;
        @SuppressLint(value={"StaticFieldLeak"})
        private FullAdWidget fullAdWidget;
        @SuppressLint(value={"StaticFieldLeak"})
        private Context context;
        private final AdRequest request;
        private final OptionsState optionsState;
        private final PresentationFactory.FullScreenCallback fullscreenCallback;
        private final Bundle savedState;
        private final JobRunner jobRunner;
        private final VungleApiClient apiClient;
        private final CloseDelegate closeDelegate;
        private final OrientationDelegate orientationDelegate;
        private Advertisement advertisement;
        private final OMTracker.Factory omTrackerFactory;

        FullScreenPresentationTask(Context context, AdLoader adLoader, AdRequest request, Repository repository, VungleStaticApi vungleStaticApi, JobRunner jobRunner, VungleApiClient apiClient, FullAdWidget fullAdWidget, OptionsState optionsState, OrientationDelegate orientationDelegate, CloseDelegate closeDelegate, PresentationFactory.FullScreenCallback fullscreenCallback, BaseTask.OnModelLoadListener onModelLoadListener, Bundle savedState, OMTracker.Factory omTrackerFactory) {
            super(repository, vungleStaticApi, onModelLoadListener);
            this.request = request;
            this.fullAdWidget = fullAdWidget;
            this.optionsState = optionsState;
            this.context = context;
            this.fullscreenCallback = fullscreenCallback;
            this.savedState = savedState;
            this.jobRunner = jobRunner;
            this.apiClient = apiClient;
            this.orientationDelegate = orientationDelegate;
            this.closeDelegate = closeDelegate;
            this.adLoader = adLoader;
            this.omTrackerFactory = omTrackerFactory;
        }

        @Override
        void clear() {
            super.clear();
            this.context = null;
            this.fullAdWidget = null;
        }

        protected PresentationResultHolder doInBackground(Void ... voids) {
            List<AdAsset> adAssets;
            Cookie configCookie;
            boolean isAdDownloadOptEnabled;
            Pair<Advertisement, Placement> data;
            try {
                data = this.loadPresentationData(this.request, this.savedState);
            }
            catch (VungleException e2) {
                return new PresentationResultHolder(e2);
            }
            this.advertisement = (Advertisement)data.first;
            Placement placement = (Placement)data.second;
            if (!this.adLoader.canRenderAd(this.advertisement)) {
                Log.e((String)TAG, (String)"Advertisement is null or assets are missing");
                return new PresentationResultHolder(new VungleException(10));
            }
            if (placement.getPlacementAdType() == 4) {
                return new PresentationResultHolder(new VungleException(41));
            }
            if (placement.getPlacementAdType() != 0) {
                return new PresentationResultHolder(new VungleException(29));
            }
            JobDelegateAnalytics adAnalytics = new JobDelegateAnalytics(this.jobRunner);
            String appId = null;
            Cookie appIdCookie = this.repository.load("appId", Cookie.class).get();
            if (appIdCookie != null && !TextUtils.isEmpty((CharSequence)appIdCookie.getString("appId"))) {
                appId = appIdCookie.getString("appId");
            }
            boolean bl = isAdDownloadOptEnabled = (configCookie = this.repository.load("configSettings", Cookie.class).get()) != null && configCookie.getBoolean("isAdDownloadOptEnabled") != false;
            if (isAdDownloadOptEnabled && !this.advertisement.assetsFullyDownloaded && !(adAssets = this.repository.loadAllAdAssetByStatus(this.advertisement.getId(), 3)).isEmpty()) {
                this.advertisement.updateMRAIDTokensFromAssetDB(adAssets);
                try {
                    this.repository.save(this.advertisement);
                }
                catch (DatabaseHelper.DBException e3) {
                    Log.e((String)TAG, (String)"Unable to update tokens");
                }
            }
            Executors executors = ServiceLocator.getInstance(this.context).getService(Executors.class);
            VungleThreadPoolExecutor offloadExecutor = executors.getOffloadExecutor();
            VungleWebClient webClient = new VungleWebClient(this.advertisement, placement, offloadExecutor);
            File assetDir = this.repository.getAdvertisementAssetDirectory(this.advertisement.getId()).get();
            if (assetDir == null || !assetDir.isDirectory()) {
                Log.e((String)TAG, (String)"Advertisement assets dir is missing");
                return new PresentationResultHolder(new VungleException(26));
            }
            switch (this.advertisement.getAdType()) {
                case 0: {
                    LocalAdPresenter localPresenter = new LocalAdPresenter(this.advertisement, placement, this.repository, new HandlerScheduler(), adAnalytics, webClient, this.optionsState, assetDir, this.request.getImpression());
                    LocalAdView localView = new LocalAdView(this.context, this.fullAdWidget, this.orientationDelegate, this.closeDelegate);
                    return new PresentationResultHolder(localView, localPresenter, webClient);
                }
                case 1: {
                    OMTracker omTracker = this.omTrackerFactory.make(this.apiClient.getOmEnabled() && this.advertisement.getOmEnabled());
                    webClient.setWebViewObserver(omTracker);
                    MRAIDAdPresenter mraidPresenter = new MRAIDAdPresenter(this.advertisement, placement, this.repository, new HandlerScheduler(), adAnalytics, webClient, this.optionsState, assetDir, omTracker, this.request.getImpression());
                    MRAIDAdView mraidView = new MRAIDAdView(this.context, this.fullAdWidget, this.orientationDelegate, this.closeDelegate);
                    return new PresentationResultHolder(mraidView, mraidPresenter, webClient);
                }
            }
            return new PresentationResultHolder(new VungleException(10));
        }

        @Override
        protected void onPostExecute(PresentationResultHolder result) {
            super.onPostExecute(result);
            if (!this.isCancelled() && this.fullscreenCallback != null) {
                if (result.exception != null) {
                    Log.e((String)TAG, (String)"Exception on creating presenter", (Throwable)result.exception);
                    this.fullscreenCallback.onResult((Pair<AdContract.AdView, AdContract.AdvertisementPresenter>)new Pair(null, null), result.exception);
                    return;
                }
                this.fullAdWidget.linkWebView(result.webClient, new JavascriptBridge(result.advertisementPresenter));
                this.fullscreenCallback.onResult((Pair<AdContract.AdView, AdContract.AdvertisementPresenter>)new Pair((Object)result.adView, (Object)result.advertisementPresenter), result.exception);
            }
        }
    }

    private static class PresentationResultHolder {
        private AdContract.AdView adView;
        private AdContract.AdvertisementPresenter advertisementPresenter;
        private VungleException exception;
        private VungleWebClient webClient;

        PresentationResultHolder(VungleException exception) {
            this.exception = exception;
        }

        PresentationResultHolder(AdContract.AdView adView, AdContract.AdvertisementPresenter advertisementPresenter, VungleWebClient webClient) {
            this.adView = adView;
            this.advertisementPresenter = advertisementPresenter;
            this.webClient = webClient;
        }
    }
}

