/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.os.Build;
import android.text.TextUtils;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.gson.Gson;
import com.vungle.warren.PrivacyManager;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.locale.LocaleInfo;
import com.vungle.warren.model.BidTokenV3;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.model.GdprCookie;
import com.vungle.warren.model.token.AndroidInfo;
import com.vungle.warren.model.token.Ccpa;
import com.vungle.warren.model.token.Consent;
import com.vungle.warren.model.token.Coppa;
import com.vungle.warren.model.token.Device;
import com.vungle.warren.model.token.Extension;
import com.vungle.warren.model.token.Gdpr;
import com.vungle.warren.model.token.Request;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.utility.SDKExecutors;
import com.vungle.warren.utility.TimeoutProvider;
import com.vungle.warren.utility.platform.Platform;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;

public class BidTokenEncoder {
    private final Repository repository;
    private final TimeoutProvider timeoutProvider;
    private final Gson gson;
    private final Platform platform;
    private final LocaleInfo localeInfo;

    public BidTokenEncoder(Repository repository, TimeoutProvider timeoutProvider, LocaleInfo localeInfo, Platform platform, Gson gson, SDKExecutors sdkExecutors) {
        this.gson = gson;
        this.timeoutProvider = timeoutProvider;
        this.repository = repository;
        this.localeInfo = localeInfo;
        this.platform = platform;
        PrivacyManager.getInstance().init(sdkExecutors.getBackgroundExecutor(), repository);
    }

    @Nullable
    public String encode(String placementId, int maxBidTokenSizeBytes, int ordinalCount) {
        return this.V3BidToken(placementId, maxBidTokenSizeBytes, ordinalCount);
    }

    private String V3BidToken(String placementId, int maxBidTokenSizeBytes, int ordinalCount) {
        String token = this.constructV3Token(placementId, maxBidTokenSizeBytes, ordinalCount);
        ByteArrayOutputStream os = new ByteArrayOutputStream(token.length());
        try {
            GZIPOutputStream gos = new GZIPOutputStream(os);
            gos.write(token.getBytes());
            gos.close();
            byte[] compressed = os.toByteArray();
            String base64 = Base64.encodeToString((byte[])compressed, (int)2);
            os.close();
            return "3:" + base64;
        }
        catch (IOException e2) {
            return null;
        }
    }

    private String constructV3Token(String placementId, int maxBidTokenSizeBytes, int ordinalCount) {
        AndroidInfo amazonInfo;
        Cookie ccpaConsent = this.repository.load("ccpaIsImportantToVungle", Cookie.class).get(this.timeoutProvider.getTimeout(), TimeUnit.MILLISECONDS);
        Ccpa ccpa = new Ccpa(BidTokenEncoder.getCCPAStatus(ccpaConsent));
        Gdpr gdpr = this.getGdpr();
        Coppa coppa = this.getCoppa();
        Consent consent = new Consent(ccpa, gdpr, coppa);
        Extension extension = new Extension(this.platform.getIsSideloaded(), this.platform.getIsSDCardPresent(), this.platform.getIsSoundEnabled());
        String ifa = null;
        boolean isAmazonDevice = "Amazon".equals(Build.MANUFACTURER);
        AndroidInfo androidInfo = isAmazonDevice ? null : new AndroidInfo();
        AndroidInfo androidInfo2 = amazonInfo = isAmazonDevice ? new AndroidInfo() : null;
        if (PrivacyManager.getInstance().shouldSendAdIds()) {
            String gaid = this.platform.getAdvertisingInfo().advertisingId;
            String androidId = TextUtils.isEmpty((CharSequence)gaid) ? this.platform.getAndroidId() : "";
            String string = ifa = TextUtils.isEmpty((CharSequence)gaid) ? androidId : gaid;
            if (!TextUtils.isEmpty((CharSequence)androidId)) {
                if (isAmazonDevice) {
                    amazonInfo.android_id = androidId;
                } else {
                    androidInfo.android_id = androidId;
                }
            }
        }
        if (isAmazonDevice) {
            amazonInfo.app_set_id = this.platform.getAppSetId();
        } else {
            androidInfo.app_set_id = this.platform.getAppSetId();
        }
        Device device = new Device(this.platform.getIsBatterySaverEnabled(), this.localeInfo.getLanguage(), this.localeInfo.getTimeZoneId(), this.platform.getVolumeLevel(), ifa, amazonInfo, androidInfo, extension);
        Request request = new Request(this.getConfigExtension(), ordinalCount, this.getAvailableBidTokens(placementId, maxBidTokenSizeBytes, ordinalCount), VungleApiClient.getHeaderUa());
        BidTokenV3 bidTokenV3 = new BidTokenV3(device, request, consent);
        return this.gson.toJson((Object)bidTokenV3);
    }

    private List<String> getAvailableBidTokens(@Nullable String placementId, int maxBidTokenSizeBytes, int ordinalCount) {
        int bidTokenMaxBytesSanitized = maxBidTokenSizeBytes <= 0 ? 0x7FFFFFFE : maxBidTokenSizeBytes;
        return this.repository.getAvailableBidTokens(placementId, BidTokenEncoder.getAvailableSizeForHBT(bidTokenMaxBytesSanitized, "2", Integer.toString(ordinalCount)), ",".getBytes().length).get();
    }

    private static String getCCPAStatus(@Nullable Cookie ccpaConsent) {
        if (ccpaConsent == null) {
            return "opted_in";
        }
        return "opted_out".equals(ccpaConsent.getString("ccpa_status")) ? "opted_out" : "opted_in";
    }

    @Nullable
    private Coppa getCoppa() {
        PrivacyManager privacyManager = PrivacyManager.getInstance();
        PrivacyManager.COPPA hasCoppa = privacyManager.getCoppaStatus();
        if (hasCoppa == PrivacyManager.COPPA.COPPA_NOTSET) {
            return null;
        }
        return new Coppa(hasCoppa.getValue());
    }

    private Gdpr getGdpr() {
        GdprCookie gdprCookie = new GdprCookie(this.repository, this.timeoutProvider);
        String consentSource = gdprCookie.getSource();
        String gdprConsent = gdprCookie.getConsentStatus();
        Long timestamp = gdprCookie.getTimeStamp();
        String messageVersion = gdprCookie.getMessageVersion();
        return new Gdpr(gdprConsent, consentSource, messageVersion, timestamp);
    }

    @NonNull
    private String getConfigExtension() {
        Cookie cookie = this.repository.load("config_extension", Cookie.class).get(this.timeoutProvider.getTimeout(), TimeUnit.MILLISECONDS);
        String extension = "";
        if (cookie != null) {
            extension = cookie.getString("config_extension");
        }
        return extension;
    }

    @VisibleForTesting
    static int getAvailableSizeForHBT(int bytesAvailable, String encodeVersion, String headerBiddingOrdinalCount) {
        int maxBytesAvailableForToken = (int)(3.0 * Math.floor((bytesAvailable - encodeVersion.getBytes().length - ":".getBytes().length) / 4) - (double)":".getBytes().length - (double)headerBiddingOrdinalCount.getBytes().length);
        return (int)Math.max(Math.round((double)maxBytesAvailableForToken / 4.0) * 4L, 0L);
    }
}

