/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.os.Bundle;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.tasks.CacheBustJob;
import com.vungle.warren.tasks.JobRunner;
import com.vungle.warren.utility.ActivityManager;

public class CacheBustManager {
    public static final String NEXT_CACHE_BUST = "next_cache_bust";
    public static final String CACHE_BUST_INTERVAL = "cache_bust_interval";
    public static final int NO_VALUE = Integer.MIN_VALUE;
    private JobRunner jobRunner;
    private static final int DEFAULT_REFRESH_RATE = 0;
    @VisibleForTesting
    long refreshRate = 0L;
    private long overrideRefreshRate = Integer.MIN_VALUE;
    @VisibleForTesting
    static final long MINIMUM_REFRESH_RATE = 900000L;
    private long startTrackingTime;
    private long refreshElapsed;
    private int status;

    protected CacheBustManager(@NonNull JobRunner runner) {
        this.jobRunner = runner;
        if (ActivityManager.getInstance().isInitialized()) {
            this.setLifecycleListener();
        } else {
            Log.e((String)CacheBustManager.class.getSimpleName(), (String)"No lifecycle listener set");
            VungleLogger.error(CacheBustManager.class.getSimpleName() + "#deliverError", "No lifecycle listener set");
        }
        this.status = 0;
    }

    public synchronized void startBust() {
        if (this.status == 1) {
            return;
        }
        this.status = 1;
        if (this.refreshRate == 0L) {
            this.jobRunner.execute(CacheBustJob.makeJobInfo());
        } else {
            Bundle bundle = new Bundle();
            bundle.putLong(CACHE_BUST_INTERVAL, this.refreshRate);
            bundle.putLong(NEXT_CACHE_BUST, this.getCurrentTime() + this.refreshRate);
            this.jobRunner.execute(CacheBustJob.makeJobInfo().setReschedulePolicy(this.refreshRate, 0).setExtras(bundle));
        }
        this.startTrackingTime = this.getCurrentTime();
    }

    @VisibleForTesting
    void overrideRefreshRate(long refreshRate) {
        this.overrideRefreshRate = refreshRate;
        this.refreshRate = refreshRate;
    }

    public void setRefreshRate(long refreshRate) {
        long newRefreshRate;
        if (this.overrideRefreshRate != Integer.MIN_VALUE) {
            this.refreshRate = this.overrideRefreshRate;
            return;
        }
        long l = newRefreshRate = refreshRate > 0L ? Math.max(refreshRate, 900000L) : 0L;
        if (newRefreshRate != this.refreshRate) {
            this.refreshRate = newRefreshRate;
            if (this.status == 1) {
                this.jobRunner.cancelPendingJob(CacheBustJob.TAG);
                this.status = 0;
                this.startBust();
            }
        }
    }

    private void setLifecycleListener() {
        ActivityManager.getInstance().addListener(new ActivityManager.LifeCycleCallback(){

            @Override
            public void onStart() {
                super.onStart();
                CacheBustManager.this.resumeCacheBust();
            }

            @Override
            public void onStop() {
                super.onStop();
                CacheBustManager.this.stopCacheBust();
            }
        });
    }

    void resumeCacheBust() {
        if (this.status == 0 && this.refreshRate != 0L) {
            this.status = 1;
            Bundle bundle = new Bundle();
            bundle.putLong(CACHE_BUST_INTERVAL, this.refreshRate);
            bundle.putLong(NEXT_CACHE_BUST, this.getCurrentTime() + this.refreshRate);
            this.jobRunner.execute(CacheBustJob.makeJobInfo().setDelay(this.refreshRate - this.refreshElapsed).setReschedulePolicy(this.refreshRate, 0).setExtras(bundle));
            this.refreshElapsed = 0L;
            this.startTrackingTime = this.getCurrentTime();
        }
    }

    void stopCacheBust() {
        if (this.refreshRate != 0L) {
            this.refreshElapsed = (this.getCurrentTime() - this.startTrackingTime) % this.refreshRate;
        }
        this.jobRunner.cancelPendingJob(CacheBustJob.TAG);
        this.status = 0;
    }

    long getCurrentTime() {
        return SystemClock.elapsedRealtime();
    }
}

