/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import com.vungle.warren.InitCallback;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.utility.ThreadUtil;
import java.util.concurrent.ExecutorService;

class InitCallbackWrapper
implements InitCallback {
    private final InitCallback callback;
    private final ExecutorService executorService;

    InitCallbackWrapper(ExecutorService executorService, InitCallback callback) {
        this.callback = callback;
        this.executorService = executorService;
    }

    @Override
    public void onSuccess() {
        if (this.callback == null) {
            return;
        }
        if (ThreadUtil.isMainThread()) {
            this.callback.onSuccess();
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                InitCallbackWrapper.this.callback.onSuccess();
            }
        });
    }

    @Override
    public void onError(final VungleException exception) {
        if (this.callback == null) {
            return;
        }
        if (ThreadUtil.isMainThread()) {
            this.callback.onError(exception);
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                InitCallbackWrapper.this.callback.onError(exception);
            }
        });
    }

    @Override
    public void onAutoCacheAdAvailable(final String placementId) {
        if (this.callback == null) {
            return;
        }
        if (ThreadUtil.isMainThread()) {
            this.callback.onAutoCacheAdAvailable(placementId);
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                InitCallbackWrapper.this.callback.onAutoCacheAdAvailable(placementId);
            }
        });
    }
}

