/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.AdConfig;
import com.vungle.warren.AdRequest;
import com.vungle.warren.LoadNativeAdCallback;
import com.vungle.warren.NativeAdLayout;
import com.vungle.warren.NativeAdListener;
import com.vungle.warren.NativeAdOptionsView;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.PresentationFactory;
import com.vungle.warren.ServiceLocator;
import com.vungle.warren.Vungle;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Placement;
import com.vungle.warren.model.admarkup.AdMarkup;
import com.vungle.warren.persistence.FutureResult;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.ui.view.MediaView;
import com.vungle.warren.utility.AdMarkupDecoder;
import com.vungle.warren.utility.Executors;
import com.vungle.warren.utility.ImageLoader;
import com.vungle.warren.utility.ImpressionTracker;
import com.vungle.warren.utility.TimeoutProvider;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class NativeAd {
    private static final String TAG = NativeAd.class.getSimpleName();
    private static final String TOKEN_APP_NAME = "APP_NAME";
    private static final String TOKEN_APP_DESCRIPTION = "APP_DESCRIPTION";
    private static final String TOKEN_CTA_BUTTON_TEXT = "CTA_BUTTON_TEXT";
    public static final String TOKEN_CTA_BUTTON_URL = "CTA_BUTTON_URL";
    private static final String TOKEN_APP_RATING_VALUE = "APP_RATING_VALUE";
    private static final String TOKEN_SPONSORED_BY = "SPONSORED_BY";
    private static final String TOKEN_VUNGLE_PRIVACY_ICON_URL = "VUNGLE_PRIVACY_ICON_URL";
    public static final String TOKEN_VUNGLE_PRIVACY_URL = "VUNGLE_PRIVACY_URL";
    private static final String TOKEN_APP_ICON = "APP_ICON";
    private static final String TOKEN_MAIN_IMAGE = "MAIN_IMAGE";
    private static final int STATE_NEW = 1;
    private static final int STATE_READY = 2;
    private static final int STATE_VIEWING = 3;
    private static final int STATE_DESTROY = 4;
    private static final int STATE_ERROR = 5;
    private final Context context;
    private final String placementId;
    private String adMarkUp;
    private AdConfig adConfig;
    private Map<String, String> nativeAdAssetMap;
    private NativeAdListener nativeAdCallback;
    private NativeAdLayout rootNativeView;
    private ImageView iconView;
    @Nullable
    private MediaView contentView;
    private ImpressionTracker impressionTracker;
    private final ImageLoader imageLoader;
    private final Executor uiExecutor;
    private FrameLayout adOptionsRootView;
    private NativeAdOptionsView adOptionsView;
    private List<View> clickableViews;
    private int adState;
    private final LoadNativeAdCallback loadAdCallback = new LoadNativeAdCallback(){

        @Override
        public void onAdLoad(@Nullable Advertisement advertisement) {
            VungleLogger.debug(true, TAG, "NativeAd", "Native Ad Loaded : " + NativeAd.this.placementId);
            if (advertisement == null) {
                NativeAd.this.onLoadError(NativeAd.this.placementId, NativeAd.this.nativeAdCallback, 11);
                return;
            }
            NativeAd.this.adState = 2;
            NativeAd.this.nativeAdAssetMap = advertisement.getMRAIDArgsInMap();
            if (NativeAd.this.nativeAdCallback != null) {
                NativeAd.this.nativeAdCallback.onNativeAdLoaded(NativeAd.this);
            }
        }

        @Override
        public void onAdLoad(String placementId) {
            VungleLogger.error(true, TAG, "NativeAd", "Internal error! For native ads we should use onAdLoad(advertisement) callback.");
        }

        @Override
        public void onError(String placementId, VungleException exception) {
            VungleLogger.debug(true, TAG, "NativeAd", "Native Ad Load Error : " + placementId + " Message : " + exception.getLocalizedMessage());
            NativeAd.this.onLoadError(placementId, NativeAd.this.nativeAdCallback, exception.getExceptionCode());
        }
    };
    private final PlayAdCallback playAdCallback = new PlayAdCallback(){

        @Override
        public void creativeId(String creativeId) {
            if (NativeAd.this.nativeAdCallback != null) {
                NativeAd.this.nativeAdCallback.creativeId(creativeId);
            }
        }

        @Override
        public void onAdStart(String placementId) {
        }

        @Override
        public void onAdEnd(String placementId, boolean completed, boolean isCTAClicked) {
        }

        @Override
        public void onAdEnd(String placementId) {
        }

        @Override
        public void onAdClick(String placementId) {
            if (NativeAd.this.nativeAdCallback != null) {
                NativeAd.this.nativeAdCallback.onAdClick(placementId);
            }
        }

        @Override
        public void onAdRewarded(String placementId) {
        }

        @Override
        public void onAdLeftApplication(String placementId) {
            if (NativeAd.this.nativeAdCallback != null) {
                NativeAd.this.nativeAdCallback.onAdLeftApplication(placementId);
            }
        }

        @Override
        public void onError(String placementId, VungleException exception) {
            NativeAd.this.adState = 5;
            if (NativeAd.this.nativeAdCallback != null) {
                NativeAd.this.nativeAdCallback.onAdPlayError(placementId, exception);
            }
        }

        @Override
        public void onAdViewed(String placementId) {
            if (NativeAd.this.nativeAdCallback != null) {
                NativeAd.this.nativeAdCallback.onAdImpression(placementId);
            }
        }
    };

    public NativeAd(@NonNull Context context, @NonNull String placementId) {
        this.context = context;
        this.placementId = placementId;
        ServiceLocator serviceLocator = ServiceLocator.getInstance(context);
        Executors sdkExecutors = serviceLocator.getService(Executors.class);
        this.uiExecutor = sdkExecutors.getUIExecutor();
        this.imageLoader = ImageLoader.getInstance();
        this.imageLoader.init(sdkExecutors.getIOExecutor());
        this.adState = 1;
    }

    public void loadAd(@Nullable AdConfig nativeAdConfig, @Nullable NativeAdListener callback) {
        this.loadAd(nativeAdConfig, null, callback);
    }

    public void loadAd(@Nullable AdConfig nativeAdConfig, @Nullable String markup, @Nullable NativeAdListener callback) {
        VungleLogger.debug("NativeAd#loadAd", "loadAd API call invoked");
        if (!Vungle.isInitialized()) {
            this.onLoadError(this.placementId, callback, 9);
            return;
        }
        this.adState = 1;
        this.adConfig = nativeAdConfig == null ? new AdConfig() : nativeAdConfig;
        this.adMarkUp = markup;
        this.nativeAdCallback = callback;
        Vungle.loadAdInternal(this.placementId, markup, this.adConfig, this.loadAdCallback);
    }

    private void onLoadError(@NonNull String placementId, @Nullable NativeAdListener callback, @VungleException.ExceptionCode int code) {
        this.adState = 5;
        VungleException ex = new VungleException(code);
        if (callback != null) {
            callback.onAdLoadError(placementId, ex);
        }
        VungleLogger.error("NativeAd#onLoadError", "NativeAd load error: " + ex.getLocalizedMessage());
    }

    public boolean canPlayAd() {
        if (TextUtils.isEmpty((CharSequence)this.placementId)) {
            VungleLogger.error(true, TAG, "NativeAd", "PlacementId is null");
            return false;
        }
        if (this.adState != 2) {
            Log.w((String)TAG, (String)("Ad is not loaded or is displaying for placement: " + this.placementId));
            return false;
        }
        AdMarkup serializedAdMarkup = AdMarkupDecoder.decode(this.adMarkUp);
        if (!TextUtils.isEmpty((CharSequence)this.adMarkUp) && serializedAdMarkup == null) {
            Log.e((String)TAG, (String)"Invalid AdMarkup");
            return false;
        }
        final ServiceLocator serviceLocator = ServiceLocator.getInstance(this.context);
        Executors sdkExecutors = serviceLocator.getService(Executors.class);
        TimeoutProvider provider = serviceLocator.getService(TimeoutProvider.class);
        FutureResult<Boolean> futureResult = new FutureResult<Boolean>(sdkExecutors.getApiExecutor().submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                if (!Vungle.isInitialized()) {
                    VungleLogger.error(true, TAG, "NativeAd", "Vungle is not initialized");
                    return false;
                }
                Repository repository = serviceLocator.getService(Repository.class);
                AdRequest request = new AdRequest(NativeAd.this.placementId, AdMarkupDecoder.decode(NativeAd.this.adMarkUp), false);
                Placement placement = repository.load(NativeAd.this.placementId, Placement.class).get();
                if (placement == null) {
                    return false;
                }
                if (placement.isMultipleHBPEnabled() && request.getEventId() == null) {
                    return false;
                }
                Advertisement advertisement = repository.findValidAdvertisementForPlacement(NativeAd.this.placementId, request.getEventId()).get();
                if (advertisement == null) {
                    return false;
                }
                return Vungle.canPlayAd(advertisement);
            }
        }));
        return Boolean.TRUE.equals(futureResult.get(provider.getTimeout(), TimeUnit.MILLISECONDS));
    }

    public String getPlacementId() {
        return this.placementId;
    }

    public void destroy() {
        Log.d((String)TAG, (String)"destroy()");
        this.adState = 4;
        if (this.nativeAdAssetMap != null) {
            this.nativeAdAssetMap.clear();
            this.nativeAdAssetMap = null;
        }
        if (this.impressionTracker != null) {
            this.impressionTracker.destroy();
            this.impressionTracker = null;
        }
        if (this.iconView != null) {
            this.iconView.setImageDrawable(null);
            this.iconView = null;
        }
        if (this.contentView != null) {
            this.contentView.destroy();
            this.contentView = null;
        }
        if (this.adOptionsView != null) {
            this.adOptionsView.destroy();
            this.adOptionsView = null;
        }
        if (this.rootNativeView != null) {
            this.rootNativeView.finishDisplayingAdInternal(true);
            this.rootNativeView = null;
        }
    }

    @NonNull
    public String getAppIcon() {
        String ret = this.nativeAdAssetMap == null ? "" : this.nativeAdAssetMap.get(TOKEN_APP_ICON);
        return ret == null ? "" : ret;
    }

    @NonNull
    public String getAdTitle() {
        String ret = this.nativeAdAssetMap == null ? "" : this.nativeAdAssetMap.get(TOKEN_APP_NAME);
        return ret == null ? "" : ret;
    }

    @NonNull
    public String getAdBodyText() {
        String ret = this.nativeAdAssetMap == null ? "" : this.nativeAdAssetMap.get(TOKEN_APP_DESCRIPTION);
        return ret == null ? "" : ret;
    }

    @NonNull
    public String getAdCallToActionText() {
        String ret = this.nativeAdAssetMap == null ? "" : this.nativeAdAssetMap.get(TOKEN_CTA_BUTTON_TEXT);
        return ret == null ? "" : ret;
    }

    @Nullable
    public Double getAdStarRating() {
        String ratingValue;
        String string = ratingValue = this.nativeAdAssetMap == null ? null : this.nativeAdAssetMap.get(TOKEN_APP_RATING_VALUE);
        if (!TextUtils.isEmpty(ratingValue)) {
            try {
                return Double.valueOf(ratingValue);
            }
            catch (NumberFormatException e2) {
                VungleLogger.error(true, TAG, "NativeAd", "Unable to parse " + ratingValue + " as double.");
                return null;
            }
        }
        return null;
    }

    @NonNull
    public String getAdSponsoredText() {
        String ret = this.nativeAdAssetMap == null ? "" : this.nativeAdAssetMap.get(TOKEN_SPONSORED_BY);
        return ret == null ? "" : ret;
    }

    @NonNull
    String getPrivacyIconUrl() {
        String ret = this.nativeAdAssetMap == null ? "" : this.nativeAdAssetMap.get(TOKEN_VUNGLE_PRIVACY_ICON_URL);
        return ret == null ? "" : ret;
    }

    @NonNull
    String getPrivacyUrl() {
        String ret = this.nativeAdAssetMap == null ? "" : this.nativeAdAssetMap.get(TOKEN_VUNGLE_PRIVACY_URL);
        return ret == null ? "" : ret;
    }

    @NonNull
    String getCtaUrl() {
        String ret = this.nativeAdAssetMap == null ? "" : this.nativeAdAssetMap.get(TOKEN_CTA_BUTTON_URL);
        return ret == null ? "" : ret;
    }

    public boolean hasCallToAction() {
        return !TextUtils.isEmpty((CharSequence)this.getCtaUrl());
    }

    public void setAdOptionsRootView(FrameLayout adOptionsRootView) {
        if (VungleApiClient.WRAPPER_FRAMEWORK_SELECTED == null || VungleApiClient.WRAPPER_FRAMEWORK_SELECTED == VungleApiClient.WrapperFramework.none) {
            Log.w((String)TAG, (String)"You can NOT use this API to change the privacy icon parent view, please use NativeAdLayout as your native ad root view!");
            return;
        }
        this.adOptionsRootView = adOptionsRootView;
    }

    public void unregisterView() {
        if (this.adOptionsView != null && this.adOptionsView.getParent() != null) {
            ((ViewGroup)this.adOptionsView.getParent()).removeView((View)this.adOptionsView);
        }
        if (this.impressionTracker != null) {
            this.impressionTracker.clear();
        }
        if (this.clickableViews != null) {
            for (View view : this.clickableViews) {
                view.setOnClickListener(null);
            }
        } else if (this.contentView != null) {
            this.contentView.setOnClickListener(null);
        }
    }

    public void registerViewForInteraction(final @NonNull NativeAdLayout rootNativeView, @NonNull MediaView mediaView, @Nullable ImageView adIconView, @Nullable List<View> clickableViews) {
        if (!this.canPlayAd()) {
            this.playAdCallback.onError(this.placementId, new VungleException(10));
            return;
        }
        this.adState = 3;
        this.rootNativeView = rootNativeView;
        this.contentView = mediaView;
        this.iconView = adIconView;
        this.clickableViews = clickableViews;
        if (this.adOptionsView != null) {
            this.adOptionsView.destroy();
        }
        this.adOptionsView = new NativeAdOptionsView(this.context);
        if (this.adOptionsRootView == null) {
            this.adOptionsRootView = rootNativeView;
        }
        this.adOptionsView.renderTo(this, this.adOptionsRootView, this.adConfig.getAdOptionsPosition());
        this.impressionTracker = new ImpressionTracker(this.context);
        rootNativeView.finishDisplayingAdInternal(false);
        this.impressionTracker.addView((View)this.adOptionsRootView, new ImpressionTracker.ImpressionListener(){

            @Override
            public void onImpression(View view) {
                rootNativeView.onImpression();
            }
        });
        ServiceLocator serviceLocator = ServiceLocator.getInstance(this.context);
        AdRequest request = new AdRequest(this.placementId, AdMarkupDecoder.decode(this.adMarkUp), false);
        rootNativeView.register(this.context, this, serviceLocator.getService(PresentationFactory.class), Vungle.getEventListener(request, this.playAdCallback), this.adConfig, request);
        String mainImagePath = this.nativeAdAssetMap == null ? null : this.nativeAdAssetMap.get(TOKEN_MAIN_IMAGE);
        this.displayImage(mainImagePath, mediaView.getMainImage());
        if (adIconView != null) {
            String appIconPath = this.getAppIcon();
            this.displayImage(appIconPath, adIconView);
        }
        int event = 1;
        if (clickableViews != null && clickableViews.size() > 0) {
            for (View view : clickableViews) {
                this.registerClickEvent(view, event);
            }
        } else {
            this.registerClickEvent((View)mediaView, event);
        }
    }

    void registerClickEvent(@NonNull View view, final int event) {
        view.setClickable(true);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (NativeAd.this.rootNativeView != null) {
                    NativeAd.this.rootNativeView.onItemClicked(event);
                }
            }
        });
    }

    void displayImage(@Nullable String path, final @Nullable ImageView iv) {
        this.imageLoader.displayImage(path, new ImageLoader.ImageLoaderListener(){

            @Override
            public void onImageLoaded(final Bitmap bitmap) {
                if (iv != null) {
                    NativeAd.this.uiExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            iv.setImageBitmap(bitmap);
                        }
                    });
                }
            }
        });
    }
}

