/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.vungle.warren.AdConfig;
import com.vungle.warren.AdRequest;
import com.vungle.warren.NativeAd;
import com.vungle.warren.PresentationFactory;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.ui.contract.AdContract;
import com.vungle.warren.ui.contract.NativeAdContract;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class NativeAdLayout
extends FrameLayout {
    private static final String TAG = NativeAdLayout.class.getSimpleName();
    private OnItemClickListener clickListener;
    private PresentationFactory presenterFactory;
    private NativeAdContract.NativePresenter presenter;
    private BroadcastReceiver broadcastReceiver;
    private AdContract.AdvertisementPresenter.EventListener listener;
    private AdRequest request;
    private final AtomicBoolean pendingStart = new AtomicBoolean(false);
    private final AtomicBoolean pendingImpression = new AtomicBoolean(false);
    private final AtomicReference<Boolean> isAdVisible = new AtomicReference();
    private boolean started = false;
    private boolean destroyed;
    @Nullable
    private NativeAd nativeAd;
    private Context context;
    private boolean disableRenderManagement;

    public NativeAdLayout(@NonNull Context context) {
        super(context);
        this.initView(context);
    }

    public NativeAdLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public NativeAdLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    @TargetApi(value=21)
    public NativeAdLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context);
    }

    private void initView(@NonNull Context context) {
        this.context = context;
    }

    public void finishDisplayingAdInternal(boolean isFinishByExternalApi) {
        Log.d((String)TAG, (String)("finishDisplayingAdInternal() " + isFinishByExternalApi + " " + ((Object)((Object)this)).hashCode()));
        if (this.presenter != null) {
            int flag = 2 | (isFinishByExternalApi ? 4 : 0);
            this.presenter.detach(flag);
        } else if (this.presenterFactory != null) {
            this.presenterFactory.destroy();
            this.presenterFactory = null;
            this.listener.onError(new VungleException(25), this.request.getPlacementId());
        }
        this.release();
    }

    public void onImpression() {
        Log.d((String)TAG, (String)("onImpression() " + ((Object)((Object)this)).hashCode()));
        if (this.presenter == null) {
            this.pendingImpression.set(true);
        } else {
            this.presenter.onProgressUpdate(1, 100.0f);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Log.d((String)TAG, (String)("onAttachedToWindow() " + ((Object)((Object)this)).hashCode()));
        if (this.disableRenderManagement) {
            return;
        }
        this.renderNativeAd();
    }

    public void renderNativeAd() {
        Log.d((String)TAG, (String)("renderNativeAd() " + ((Object)((Object)this)).hashCode()));
        this.broadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String command = intent.getStringExtra("command");
                if ("stopAll".equalsIgnoreCase(command)) {
                    NativeAdLayout.this.finishDisplayingAdInternal(false);
                } else {
                    VungleLogger.warn(NativeAdLayout.class.getSimpleName() + "#onAttachedToWindow", String.format("Receiving Invalid Broadcast: %1$s", command));
                }
            }
        };
        LocalBroadcastManager.getInstance((Context)this.context).registerReceiver(this.broadcastReceiver, new IntentFilter("AdvertisementBus"));
        this.start();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Log.d((String)TAG, (String)("onDetachedFromWindow() " + ((Object)((Object)this)).hashCode()));
        if (this.disableRenderManagement) {
            return;
        }
        this.finishNativeAd();
    }

    public void finishNativeAd() {
        Log.d((String)TAG, (String)("finishNativeAd() " + ((Object)((Object)this)).hashCode()));
        LocalBroadcastManager.getInstance((Context)this.context).unregisterReceiver(this.broadcastReceiver);
        if (this.nativeAd != null) {
            this.nativeAd.destroy();
        } else {
            Log.d((String)TAG, (String)"No need to destroy due to haven't played the ad.");
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        Log.d((String)TAG, (String)("onWindowFocusChanged() hasWindowFocus=" + hasWindowFocus + " " + ((Object)((Object)this)).hashCode()));
        super.onWindowFocusChanged(hasWindowFocus);
        this.setAdVisibility(hasWindowFocus);
        if (this.presenter != null && !this.started) {
            this.start();
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        Log.d((String)TAG, (String)("onVisibilityChanged() visibility=" + visibility + " " + ((Object)((Object)this)).hashCode()));
        this.setAdVisibility(visibility == 0);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        Log.d((String)TAG, (String)("onWindowVisibilityChanged() visibility=" + visibility + " " + ((Object)((Object)this)).hashCode()));
        this.setAdVisibility(visibility == 0);
    }

    private void setAdVisibility(boolean isVisible) {
        if (this.presenter != null) {
            this.presenter.setAdVisibility(isVisible);
        } else {
            this.isAdVisible.set(isVisible);
        }
    }

    private void start() {
        Log.d((String)TAG, (String)("start() " + ((Object)((Object)this)).hashCode()));
        if (this.presenter == null) {
            this.pendingStart.set(true);
        } else if (!this.started && this.hasWindowFocus()) {
            this.presenter.start();
            this.started = true;
        }
    }

    public void disableLifeCycleManagement(boolean disable) {
        this.disableRenderManagement = disable;
    }

    public void register(@NonNull Context context, @NonNull NativeAd nativeAd, @NonNull PresentationFactory presentationFactory, @NonNull AdContract.AdvertisementPresenter.EventListener eventListener, @Nullable AdConfig adConfig, final @NonNull AdRequest request) {
        this.presenterFactory = presentationFactory;
        this.listener = eventListener;
        this.request = request;
        this.nativeAd = nativeAd;
        if (this.presenter == null) {
            presentationFactory.getNativeViewPresentation(context, this, request, adConfig, new PresentationFactory.NativeViewCallback(){

                @Override
                public void onResult(@NonNull Pair<NativeAdContract.NativeView, NativeAdContract.NativePresenter> result, @Nullable VungleException error) {
                    NativeAdLayout.this.presenterFactory = null;
                    if (error != null) {
                        if (NativeAdLayout.this.listener != null) {
                            NativeAdLayout.this.listener.onError(error, request.getPlacementId());
                        }
                        return;
                    }
                    NativeAdContract.NativeView nativeView = (NativeAdContract.NativeView)result.first;
                    NativeAdLayout.this.presenter = (NativeAdContract.NativePresenter)result.second;
                    NativeAdLayout.this.presenter.setEventListener(NativeAdLayout.this.listener);
                    NativeAdLayout.this.presenter.attach(nativeView, null);
                    if (NativeAdLayout.this.pendingStart.getAndSet(false)) {
                        NativeAdLayout.this.start();
                    }
                    if (NativeAdLayout.this.pendingImpression.getAndSet(false)) {
                        NativeAdLayout.this.presenter.onProgressUpdate(1, 100.0f);
                    }
                    if (NativeAdLayout.this.isAdVisible.get() != null) {
                        NativeAdLayout.this.setAdVisibility((Boolean)NativeAdLayout.this.isAdVisible.get());
                    }
                    NativeAdLayout.this.destroyed = false;
                }
            });
        }
    }

    public void setOnItemClickListener(OnItemClickListener clickListener) {
        this.clickListener = clickListener;
    }

    public void onItemClicked(int code) {
        if (this.clickListener != null) {
            this.clickListener.onItemClicked(code);
        }
    }

    public void release() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.presenter = null;
        this.presenterFactory = null;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ViewEvent {
        public static final int CTA_CLICK = 1;
        public static final int PRIVACY_CLICK = 2;
    }

    public static interface OnItemClickListener {
        public void onItemClicked(int var1);
    }
}

