/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.utility.ThreadUtil;
import java.util.concurrent.ExecutorService;

class PlayAdCallbackWrapper
implements PlayAdCallback {
    private final PlayAdCallback playAdCallback;
    private final ExecutorService executorService;

    public PlayAdCallbackWrapper(ExecutorService executorService, PlayAdCallback playAdCallback) {
        this.playAdCallback = playAdCallback;
        this.executorService = executorService;
    }

    @Override
    public void creativeId(final String creativeId) {
        if (this.playAdCallback == null) {
            return;
        }
        if (ThreadUtil.isMainThread()) {
            this.playAdCallback.creativeId(creativeId);
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                PlayAdCallbackWrapper.this.playAdCallback.creativeId(creativeId);
            }
        });
    }

    @Override
    public void onAdStart(final String placementId) {
        if (this.playAdCallback == null) {
            return;
        }
        if (ThreadUtil.isMainThread()) {
            this.playAdCallback.onAdStart(placementId);
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                PlayAdCallbackWrapper.this.playAdCallback.onAdStart(placementId);
            }
        });
    }

    @Override
    public void onAdEnd(final String placementId, final boolean completed, final boolean isCTAClicked) {
        if (this.playAdCallback == null) {
            return;
        }
        if (ThreadUtil.isMainThread()) {
            this.playAdCallback.onAdEnd(placementId, completed, isCTAClicked);
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                PlayAdCallbackWrapper.this.playAdCallback.onAdEnd(placementId, completed, isCTAClicked);
            }
        });
    }

    @Override
    public void onAdEnd(final String placementId) {
        if (this.playAdCallback == null) {
            return;
        }
        if (ThreadUtil.isMainThread()) {
            this.playAdCallback.onAdEnd(placementId);
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                PlayAdCallbackWrapper.this.playAdCallback.onAdEnd(placementId);
            }
        });
    }

    @Override
    public void onAdClick(final String placementId) {
        if (this.playAdCallback == null) {
            return;
        }
        if (ThreadUtil.isMainThread()) {
            this.playAdCallback.onAdClick(placementId);
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                PlayAdCallbackWrapper.this.playAdCallback.onAdClick(placementId);
            }
        });
    }

    @Override
    public void onAdLeftApplication(final String placementId) {
        if (this.playAdCallback == null) {
            return;
        }
        if (ThreadUtil.isMainThread()) {
            this.playAdCallback.onAdLeftApplication(placementId);
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                PlayAdCallbackWrapper.this.playAdCallback.onAdLeftApplication(placementId);
            }
        });
    }

    @Override
    public void onAdRewarded(final String placementId) {
        if (this.playAdCallback == null) {
            return;
        }
        if (ThreadUtil.isMainThread()) {
            this.playAdCallback.onAdRewarded(placementId);
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                PlayAdCallbackWrapper.this.playAdCallback.onAdRewarded(placementId);
            }
        });
    }

    @Override
    public void onError(final String placementId, final VungleException exception) {
        if (this.playAdCallback == null) {
            return;
        }
        if (ThreadUtil.isMainThread()) {
            this.playAdCallback.onError(placementId, exception);
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                PlayAdCallbackWrapper.this.playAdCallback.onError(placementId, exception);
            }
        });
    }

    @Override
    public void onAdViewed(final String placementId) {
        if (this.playAdCallback == null) {
            return;
        }
        if (ThreadUtil.isMainThread()) {
            this.playAdCallback.onAdViewed(placementId);
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                PlayAdCallbackWrapper.this.playAdCallback.onAdViewed(placementId);
            }
        });
    }
}

