/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import androidx.annotation.VisibleForTesting;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.AnalyticUrl;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.utility.CookieUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;

public class PrivacyManager {
    private Repository repository;
    private static final AtomicReference<Boolean> coppaStatus = new AtomicReference();
    private static final AtomicReference<Boolean> disableAdId = new AtomicReference();
    private static PrivacyManager sInstance;
    private ExecutorService backgroundExecutor;

    private PrivacyManager() {
    }

    protected static synchronized PrivacyManager getInstance() {
        if (sInstance == null) {
            sInstance = new PrivacyManager();
        }
        return sInstance;
    }

    protected synchronized void init(ExecutorService backgroundExecutor, Repository repository) {
        this.repository = repository;
        this.backgroundExecutor = backgroundExecutor;
        Boolean storedCoppaValue = CookieUtil.getBoolean(repository, "coppa_cookie", "is_coppa");
        if (coppaStatus.get() != null) {
            this.updateCoppaStatus(coppaStatus.get());
        } else if (storedCoppaValue != null) {
            coppaStatus.set(storedCoppaValue);
        }
    }

    protected void updateCoppaStatus(final Boolean newValue) {
        if (newValue != null) {
            coppaStatus.set(newValue);
            if (this.repository != null && this.backgroundExecutor != null) {
                this.backgroundExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        CookieUtil.update(PrivacyManager.this.repository, "coppa_cookie", "is_coppa", newValue);
                    }
                });
            }
        }
    }

    protected COPPA getCoppaStatus() {
        if (coppaStatus == null || coppaStatus.get() == null) {
            return COPPA.COPPA_NOTSET;
        }
        if (coppaStatus.get().booleanValue()) {
            return COPPA.COPPA_ENABLED;
        }
        if (!coppaStatus.get().booleanValue()) {
            return COPPA.COPPA_DISABLED;
        }
        return COPPA.COPPA_NOTSET;
    }

    protected void updateDisableAdId(boolean newValue) {
        disableAdId.set(newValue);
        if (this.repository == null) {
            return;
        }
        Boolean previousDisableId = CookieUtil.getBoolean(this.repository, "coppa_cookie", "disable_ad_id");
        if ((previousDisableId == null || !previousDisableId.booleanValue()) && newValue) {
            this.deleteItemsWithAdIds();
        }
        CookieUtil.update(this.repository, "coppa_cookie", "disable_ad_id", newValue);
    }

    protected boolean shouldSendAdIds() {
        if (disableAdId == null || disableAdId.get() == null) {
            return false;
        }
        return disableAdId.get() == false;
    }

    @VisibleForTesting
    protected void clean() {
        disableAdId.set(null);
        coppaStatus.set(null);
    }

    private void deleteItemsWithAdIds() {
        this.repository.deleteAll(Advertisement.class);
        this.repository.deleteAll(AnalyticUrl.class);
    }

    public static enum COPPA {
        COPPA_ENABLED(true),
        COPPA_DISABLED(false),
        COPPA_NOTSET(null);

        private Boolean value;

        private COPPA(Boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            if (this.value == null) {
                return true;
            }
            return this.value;
        }
    }
}

