/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.util.Log;
import androidx.annotation.VisibleForTesting;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.vungle.warren.AdConfig;
import com.vungle.warren.BannerAdConfig;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.model.SessionData;
import com.vungle.warren.network.Response;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.session.SessionAttribute;
import com.vungle.warren.session.SessionConstants;
import com.vungle.warren.session.SessionEvent;
import com.vungle.warren.utility.ActivityManager;
import com.vungle.warren.utility.ListUtility;
import com.vungle.warren.utility.UtilityResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;

public class SessionTracker {
    private static final String TAG = SessionTracker.class.getSimpleName();
    private static SessionTracker _instance;
    private static long initTimestamp;
    private UtilityResource utilityResource;
    private ExecutorService sessionDataExecutor;
    private boolean enabled = false;
    private long appSessionTimeout;
    private SessionCallback sessionCallback;
    private final List<SessionData> pendingEvents = Collections.synchronizedList(new ArrayList());
    private final List<String> placementLoadTracker = new ArrayList<String>();
    private final Map<String, SessionData> customVideoCacheMap = new HashMap<String, SessionData>();
    private VungleApiClient vungleApiClient;
    private int sendLimit = 40;
    private AtomicInteger eventCount = new AtomicInteger();
    private static final int MAX_EVENTS_PER_REPORT = 40;
    private int initCounter;
    private Repository repository;
    @VisibleForTesting
    public ActivityManager.LifeCycleCallback appLifeCycleCallback = new ActivityManager.LifeCycleCallback(){
        private long lastStoppedTimestamp;

        @Override
        public void onStart() {
            if (this.lastStoppedTimestamp <= 0L) {
                return;
            }
            long duration = SessionTracker.this.utilityResource.getSystemTimeMillis() - this.lastStoppedTimestamp;
            if (SessionTracker.this.getAppSessionTimeout() > -1L && duration > 0L && duration >= SessionTracker.this.getAppSessionTimeout() * 1000L && SessionTracker.this.sessionCallback != null) {
                SessionTracker.this.sessionCallback.onSessionTimeout();
            }
            SessionTracker.this.trackEvent(new SessionData.Builder().setEvent(SessionEvent.APP_FOREGROUND).build());
        }

        @Override
        public void onStop() {
            SessionTracker.this.trackEvent(new SessionData.Builder().setEvent(SessionEvent.APP_BACKGROUND).build());
            this.lastStoppedTimestamp = SessionTracker.this.utilityResource.getSystemTimeMillis();
        }
    };

    private SessionTracker() {
    }

    protected void init(SessionCallback sessionCallback, UtilityResource utilityResource, final Repository repository, ExecutorService sessionDataExecutor, VungleApiClient vungleApiClient, final boolean enabled, int batchSizeLimit) {
        this.sessionCallback = sessionCallback;
        this.utilityResource = utilityResource;
        this.sessionDataExecutor = sessionDataExecutor;
        this.repository = repository;
        this.enabled = enabled;
        this.vungleApiClient = vungleApiClient;
        int n = this.sendLimit = batchSizeLimit <= 0 ? 40 : batchSizeLimit;
        if (!enabled) {
            this.clearTracking();
            return;
        }
        sessionDataExecutor.submit(new Runnable(){

            @Override
            public void run() {
                if (!SessionTracker.this.pendingEvents.isEmpty() && enabled) {
                    for (SessionData event : SessionTracker.this.pendingEvents) {
                        SessionTracker.this.trackEvent(event);
                    }
                }
                SessionTracker.this.pendingEvents.clear();
                List<SessionData> existingEvents = repository.loadAll(SessionData.class).get();
                List<List<SessionData>> batchedSessionData = ListUtility.partition(existingEvents, SessionTracker.this.sendLimit);
                for (List<SessionData> data : batchedSessionData) {
                    if (data.size() >= SessionTracker.this.sendLimit) {
                        try {
                            SessionTracker.this.sendData(data);
                        }
                        catch (DatabaseHelper.DBException e2) {
                            Log.e((String)TAG, (String)("Unable to retrieve data to send " + e2.getLocalizedMessage()));
                        }
                        continue;
                    }
                    SessionTracker.this.eventCount.set(data.size());
                }
            }
        });
    }

    @VisibleForTesting
    protected int getSendLimit() {
        return this.sendLimit;
    }

    public void setInitTimestamp(long millis) {
        initTimestamp = millis;
    }

    public static SessionTracker getInstance() {
        if (_instance == null) {
            _instance = new SessionTracker();
        }
        return _instance;
    }

    public long getInitTimestamp() {
        return initTimestamp;
    }

    public void trackAdConfig(BannerAdConfig adConfig) {
        if (adConfig != null && adConfig.muteChangedByApi) {
            this.trackEvent(new SessionData.Builder().setEvent(SessionEvent.MUTE).addData(SessionAttribute.MUTED, (adConfig.getSettings() & 1) == 1).build());
        }
    }

    public void trackAdConfig(AdConfig adConfig) {
        if (adConfig != null && adConfig.muteChangedByApi) {
            this.trackEvent(new SessionData.Builder().setEvent(SessionEvent.MUTE).addData(SessionAttribute.MUTED, (adConfig.getSettings() & 1) == 1).build());
        }
        if (adConfig != null && adConfig.orientationChangedByApi) {
            this.trackEvent(new SessionData.Builder().setEvent(SessionEvent.ORIENTATION).addData(SessionAttribute.ORIENTATION, this.getOrientation(adConfig.getAdOrientation())).build());
        }
    }

    public synchronized void trackEvent(SessionData sessionData) {
        if (sessionData == null) {
            return;
        }
        if (!this.enabled) {
            this.pendingEvents.add(sessionData);
            return;
        }
        if (!this.handleCustomRules(sessionData)) {
            this.storeEvent(sessionData);
        }
    }

    private synchronized void storeEvent(final SessionData sessionData) {
        if (this.sessionDataExecutor == null) {
            return;
        }
        this.sessionDataExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (SessionTracker.this.repository == null || sessionData == null) {
                        return;
                    }
                    SessionTracker.this.repository.save(sessionData);
                    SessionTracker.this.eventCount.incrementAndGet();
                    Log.d((String)TAG, (String)("Session Count: " + SessionTracker.this.eventCount + " " + (Object)((Object)sessionData.sessionEvent)));
                    if (SessionTracker.this.eventCount.get() >= SessionTracker.this.sendLimit) {
                        SessionTracker.this.sendData(SessionTracker.this.repository.loadAll(SessionData.class).get());
                        Log.d((String)TAG, (String)("SendData " + SessionTracker.this.eventCount));
                    }
                }
                catch (DatabaseHelper.DBException e2) {
                    VungleLogger.error(TAG, "Could not save event to DB");
                }
            }
        });
    }

    protected void clearTracking() {
        this.pendingEvents.clear();
    }

    protected synchronized boolean handleCustomRules(SessionData sessionData) {
        if (SessionEvent.INIT == sessionData.sessionEvent) {
            ++this.initCounter;
            return false;
        }
        if (SessionEvent.INIT_END == sessionData.sessionEvent) {
            if (this.initCounter > 0) {
                --this.initCounter;
                return false;
            }
            return true;
        }
        if (SessionEvent.LOAD_AD == sessionData.sessionEvent) {
            this.placementLoadTracker.add(sessionData.getStringAttribute(SessionAttribute.PLACEMENT_ID));
            return false;
        }
        if (SessionEvent.LOAD_AD_END == sessionData.sessionEvent) {
            if (this.placementLoadTracker.contains(sessionData.getStringAttribute(SessionAttribute.PLACEMENT_ID))) {
                this.placementLoadTracker.remove(sessionData.getStringAttribute(SessionAttribute.PLACEMENT_ID));
                return false;
            }
            return true;
        }
        if (SessionEvent.ADS_CACHED == sessionData.sessionEvent) {
            if (sessionData.getStringAttribute(SessionAttribute.VIDEO_CACHED) != null) {
                SessionData data = this.customVideoCacheMap.get(sessionData.getStringAttribute(SessionAttribute.URL));
                if (data != null) {
                    this.customVideoCacheMap.remove(sessionData.getStringAttribute(SessionAttribute.URL));
                    sessionData.removeEvent(SessionAttribute.URL);
                    sessionData.addAttribute(SessionAttribute.EVENT_ID, data.getStringAttribute(SessionAttribute.EVENT_ID));
                    return false;
                }
                return !sessionData.getStringAttribute(SessionAttribute.VIDEO_CACHED).equals(SessionConstants.NONE);
            }
            this.customVideoCacheMap.put(sessionData.getStringAttribute(SessionAttribute.URL), sessionData);
            return true;
        }
        return false;
    }

    public long getAppSessionTimeout() {
        return this.appSessionTimeout;
    }

    public void setAppSessionTimeout(long appSessionTimeout) {
        this.appSessionTimeout = appSessionTimeout;
    }

    private synchronized void sendData(List<SessionData> items) throws DatabaseHelper.DBException {
        if (!this.enabled || items.isEmpty()) {
            return;
        }
        JsonArray data = new JsonArray();
        for (SessionData sessionData : items) {
            JsonElement element = JsonParser.parseString((String)sessionData.getAsJsonString());
            if (element == null || !element.isJsonObject()) continue;
            data.add((JsonElement)element.getAsJsonObject());
        }
        try {
            Response<JsonObject> sendAnalyticsResponse = this.vungleApiClient.sendSessionDataAnalytics(data).execute();
            for (SessionData sessionData : items) {
                if (sendAnalyticsResponse.isSuccessful() || sessionData.getSendAttempts() >= this.sendLimit) {
                    this.repository.delete(sessionData);
                    continue;
                }
                sessionData.incrementSendAttempt();
                this.repository.save(sessionData);
            }
        }
        catch (IOException e2) {
            Log.e((String)TAG, (String)("Sending session analytics failed " + e2.getLocalizedMessage()));
        }
        this.eventCount.set(0);
    }

    public void observe() {
        ActivityManager.getInstance().addListener(this.appLifeCycleCallback);
    }

    public String getOrientation(int orientation) {
        switch (orientation) {
            case 0: {
                return "portrait";
            }
            case 2: {
                return "auto_rotate";
            }
            case 1: {
                return "landscape";
            }
            case 3: {
                return "match_video";
            }
        }
        return "none";
    }

    public static interface SessionCallback {
        public void onSessionTimeout();
    }
}

