/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.PermissionChecker;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vungle.warren.AdActivity;
import com.vungle.warren.AdConfig;
import com.vungle.warren.AdEventListener;
import com.vungle.warren.AdLoader;
import com.vungle.warren.AdRequest;
import com.vungle.warren.BidTokenEncoder;
import com.vungle.warren.CacheBustManager;
import com.vungle.warren.CleverCacheSettings;
import com.vungle.warren.HeaderBiddingCallback;
import com.vungle.warren.HeaderBiddingCallbackWrapper;
import com.vungle.warren.InitCallback;
import com.vungle.warren.InitCallbackWrapper;
import com.vungle.warren.LoadAdCallback;
import com.vungle.warren.LoadAdCallbackWrapper;
import com.vungle.warren.LoadNativeAdCallback;
import com.vungle.warren.LoadNativeAdCallbackWrapper;
import com.vungle.warren.PlayAdCallback;
import com.vungle.warren.PlayAdCallbackWrapper;
import com.vungle.warren.PresentationFactory;
import com.vungle.warren.PrivacyManager;
import com.vungle.warren.RuntimeValues;
import com.vungle.warren.ServiceLocator;
import com.vungle.warren.SessionTracker;
import com.vungle.warren.VisionController;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.VungleSettings;
import com.vungle.warren.downloader.DownloadRequest;
import com.vungle.warren.downloader.Downloader;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.log.LogManager;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.model.GdprCookie;
import com.vungle.warren.model.JsonUtil;
import com.vungle.warren.model.Placement;
import com.vungle.warren.model.SessionData;
import com.vungle.warren.model.admarkup.AdMarkup;
import com.vungle.warren.network.Call;
import com.vungle.warren.network.Callback;
import com.vungle.warren.network.HttpException;
import com.vungle.warren.network.Response;
import com.vungle.warren.persistence.CacheManager;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.FilePreferences;
import com.vungle.warren.persistence.FutureResult;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.session.SessionAttribute;
import com.vungle.warren.session.SessionEvent;
import com.vungle.warren.tasks.AnalyticsJob;
import com.vungle.warren.tasks.CleanupJob;
import com.vungle.warren.tasks.JobRunner;
import com.vungle.warren.tasks.ReconfigJob;
import com.vungle.warren.tasks.SendLogsJob;
import com.vungle.warren.tasks.SendReportsJob;
import com.vungle.warren.ui.VungleActivity;
import com.vungle.warren.ui.view.VungleBannerView;
import com.vungle.warren.utility.ActivityManager;
import com.vungle.warren.utility.AdMarkupDecoder;
import com.vungle.warren.utility.Executors;
import com.vungle.warren.utility.SDKExecutors;
import com.vungle.warren.utility.TimeoutProvider;
import com.vungle.warren.utility.UtilityResource;
import com.vungle.warren.utility.platform.Platform;
import com.vungle.warren.vision.VisionConfig;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

@Keep
public class Vungle {
    static final Vungle _instance = new Vungle();
    private static final String TAG = Vungle.class.getCanonicalName();
    private final AtomicReference<Consent> consent = new AtomicReference();
    private volatile String consentVersion;
    private final AtomicReference<Consent> ccpaStatus = new AtomicReference();
    private Map<String, Boolean> playOperations = new ConcurrentHashMap<String, Boolean>();
    volatile String appID;
    private Context context;
    private static volatile boolean isInitialized;
    private static AtomicBoolean isInitializing;
    private static AtomicBoolean isDepInit;
    private static Gson gson;
    private AtomicInteger hbpOrdinalViewCount = new AtomicInteger(0);
    private static final int DEFAULT_SESSION_TIMEOUT = 900;
    private static CacheManager.Listener cacheListener;

    private Vungle() {
    }

    static Context getAppContext() {
        return Vungle._instance.context;
    }

    @Deprecated
    public static void init(@NonNull Collection<String> placements, @NonNull String appId, @NonNull Context context, @NonNull InitCallback callback) throws IllegalArgumentException {
        Vungle.init(appId, context, callback, new VungleSettings.Builder().build());
    }

    public static void init(@NonNull String appId, @NonNull Context context, @NonNull InitCallback callback) throws IllegalArgumentException {
        Vungle.init(appId, context, callback, new VungleSettings.Builder().build());
    }

    public static void init(final @NonNull String appId, final @NonNull Context context, final @NonNull InitCallback callback, @NonNull VungleSettings settings) throws IllegalArgumentException {
        InitCallback initCallback;
        String VUNGLE_VERSION_STRING = "!SDK-VERSION-STRING!:com.vungle:publisher-sdk-android:6.12.0";
        VungleLogger.debug("Vungle#init", "init request");
        SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.INIT).build());
        if (callback == null) {
            SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.INIT_END).addData(SessionAttribute.SUCCESS, false).build());
            throw new IllegalArgumentException("A valid InitCallback required to ensure API calls are being made after initialize is successful");
        }
        if (context == null) {
            SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.INIT_END).addData(SessionAttribute.SUCCESS, false).build());
            callback.onError(new VungleException(6));
            return;
        }
        final ServiceLocator serviceLocator = ServiceLocator.getInstance(context);
        final Platform platform = serviceLocator.getService(Platform.class);
        if (!platform.isAtLeastMinimumSDK()) {
            Log.e((String)TAG, (String)"SDK is supported only for API versions 21 and above");
            callback.onError(new VungleException(35));
            SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.INIT_END).addData(SessionAttribute.SUCCESS, false).build());
            return;
        }
        final RuntimeValues runtimeValues = ServiceLocator.getInstance(context).getService(RuntimeValues.class);
        runtimeValues.settings.set(settings);
        Executors sdkExecutors = serviceLocator.getService(Executors.class);
        InitCallback initCallback2 = initCallback = callback instanceof InitCallbackWrapper ? callback : new InitCallbackWrapper(sdkExecutors.getUIExecutor(), callback);
        if (appId == null || appId.isEmpty()) {
            initCallback.onError(new VungleException(6));
            SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.INIT_END).addData(SessionAttribute.SUCCESS, false).build());
            return;
        }
        if (!(context instanceof Application)) {
            initCallback.onError(new VungleException(7));
            SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.INIT_END).addData(SessionAttribute.SUCCESS, false).build());
            return;
        }
        if (Vungle.isInitialized()) {
            Log.d((String)TAG, (String)"init already complete");
            initCallback.onSuccess();
            VungleLogger.debug("Vungle#init", "init already complete");
            SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.INIT_END).addData(SessionAttribute.SUCCESS, false).build());
            return;
        }
        if (isInitializing.getAndSet(true)) {
            Log.d((String)TAG, (String)"init ongoing");
            Vungle.onInitError(initCallback, new VungleException(8));
            SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.INIT_END).addData(SessionAttribute.SUCCESS, false).build());
            return;
        }
        if (PermissionChecker.checkCallingOrSelfPermission((Context)context, (String)"android.permission.ACCESS_NETWORK_STATE") != 0 || PermissionChecker.checkCallingOrSelfPermission((Context)context, (String)"android.permission.INTERNET") != 0) {
            Log.e((String)TAG, (String)"Network permissions not granted");
            Vungle.onInitError(initCallback, new VungleException(34));
            isInitializing.set(false);
            SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.INIT_END).addData(SessionAttribute.SUCCESS, false).build());
            return;
        }
        SessionTracker.getInstance().setInitTimestamp(System.currentTimeMillis());
        runtimeValues.initCallback.set(initCallback);
        sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Repository repository;
                Cookie appIdCookie;
                Vungle._instance.appID = appId;
                InitCallback initCallback = runtimeValues.initCallback.get();
                if (!isDepInit.getAndSet(true)) {
                    LogManager logManager = serviceLocator.getService(LogManager.class);
                    VungleLogger.setupLoggerWithLogLevel(logManager, VungleLogger.LoggerLevel.DEBUG, 100);
                    CacheManager cacheManager = serviceLocator.getService(CacheManager.class);
                    VungleSettings settings = runtimeValues.settings.get();
                    if (settings != null && cacheManager.getBytesAvailable() < settings.getMinimumSpaceForInit()) {
                        Vungle.onInitError(initCallback, new VungleException(16));
                        Vungle.deInit();
                        return;
                    }
                    cacheManager.addListener(cacheListener);
                    _instance.context = context;
                    Repository repository2 = serviceLocator.getService(Repository.class);
                    try {
                        repository2.init();
                    }
                    catch (DatabaseHelper.DBException e2) {
                        Vungle.onInitError(initCallback, new VungleException(26));
                        Vungle.deInit();
                        return;
                    }
                    Executors sdkExecutors = serviceLocator.getService(Executors.class);
                    PrivacyManager.getInstance().init(sdkExecutors.getBackgroundExecutor(), repository2);
                    VungleApiClient vungleApiClient = serviceLocator.getService(VungleApiClient.class);
                    vungleApiClient.init();
                    if (settings != null) {
                        platform.setAndroidIdFallbackDisabled(settings.getAndroidIdOptOut());
                    }
                    JobRunner jobRunner = serviceLocator.getService(JobRunner.class);
                    AdLoader adLoader = serviceLocator.getService(AdLoader.class);
                    adLoader.init(jobRunner);
                    if (_instance.consent.get() != null) {
                        Vungle.saveGDPRConsent(repository2, (Consent)((Object)_instance.consent.get()), _instance.consentVersion);
                    } else {
                        Cookie gdprConsent = repository2.load("consentIsImportantToVungle", Cookie.class).get();
                        if (gdprConsent == null) {
                            _instance.consent.set(null);
                            _instance.consentVersion = null;
                        } else {
                            _instance.consent.set(Vungle.getConsent(gdprConsent));
                            _instance.consentVersion = Vungle.getConsentMessageVersion(gdprConsent);
                        }
                    }
                    if (_instance.ccpaStatus.get() != null) {
                        Vungle.updateCCPAStatus(repository2, (Consent)((Object)_instance.ccpaStatus.get()));
                    } else {
                        Cookie ccpaConsent = repository2.load("ccpaIsImportantToVungle", Cookie.class).get();
                        _instance.ccpaStatus.set(Vungle.getCCPAStatus(ccpaConsent));
                    }
                }
                if ((appIdCookie = (repository = serviceLocator.getService(Repository.class)).load("appId", Cookie.class).get()) == null) {
                    appIdCookie = new Cookie("appId");
                }
                appIdCookie.putValue("appId", appId);
                try {
                    repository.save(appIdCookie);
                }
                catch (DatabaseHelper.DBException e3) {
                    if (initCallback != null) {
                        Vungle.onInitError(initCallback, new VungleException(26));
                    }
                    isInitializing.set(false);
                    return;
                }
                _instance.configure(initCallback, false);
                JobRunner jobRunner = serviceLocator.getService(JobRunner.class);
                jobRunner.execute(AnalyticsJob.makeJob(2, null, null, 1));
            }
        }, new Runnable(){

            @Override
            public void run() {
                Vungle.onInitError(callback, new VungleException(39));
            }
        });
    }

    private static void onInitError(InitCallback initCallback, VungleException e2) {
        if (initCallback != null) {
            initCallback.onError(e2);
        }
        if (e2 != null) {
            String exMsg = e2.getLocalizedMessage() != null && e2.getLocalizedMessage().isEmpty() ? e2.getLocalizedMessage() : Integer.toString(e2.getExceptionCode());
            VungleLogger.error("Vungle#init", exMsg);
        }
    }

    static void reConfigure() {
        if (Vungle._instance.context == null) {
            return;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        Executors sdkExecutors = serviceLocator.getService(Executors.class);
        final RuntimeValues runtimeValues = serviceLocator.getService(RuntimeValues.class);
        if (Vungle.isInitialized()) {
            sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    _instance.configure(runtimeValues.initCallback.get(), true);
                }
            }, new Runnable(){

                @Override
                public void run() {
                    Vungle.onInitError(runtimeValues.initCallback.get(), new VungleException(39));
                }
            });
        } else {
            Vungle.init(Vungle._instance.appID, Vungle._instance.context, runtimeValues.initCallback.get());
        }
    }

    private void configure(@NonNull InitCallback callback, boolean isReconfig) {
        try {
            Cookie configCookie;
            boolean enabled;
            LogManager logManager;
            if (this.context == null) {
                throw new IllegalArgumentException("Context is null");
            }
            ServiceLocator serviceLocator = ServiceLocator.getInstance(this.context);
            VungleApiClient vungleApiClient = serviceLocator.getService(VungleApiClient.class);
            vungleApiClient.setAppId(this.appID);
            Repository repository = serviceLocator.getService(Repository.class);
            JobRunner jobRunner = serviceLocator.getService(JobRunner.class);
            RuntimeValues runtimeValues = serviceLocator.getService(RuntimeValues.class);
            Response response = vungleApiClient.config();
            if (response == null) {
                Vungle.onInitError(callback, new VungleException(2));
                isInitializing.set(false);
                return;
            }
            if (!response.isSuccessful()) {
                long retryAfterHeaderValue = vungleApiClient.getRetryAfterHeaderValue(response);
                if (retryAfterHeaderValue > 0L) {
                    jobRunner.execute(ReconfigJob.makeJobInfo(Vungle._instance.appID).setDelay(retryAfterHeaderValue));
                    Vungle.onInitError(callback, new VungleException(14));
                    isInitializing.set(false);
                    return;
                }
                Vungle.onInitError(callback, new VungleException(3));
                isInitializing.set(false);
                return;
            }
            final FilePreferences preferences = serviceLocator.getService(FilePreferences.class);
            JsonObject jsonObject = (JsonObject)response.body();
            JsonArray placementsData = jsonObject.getAsJsonArray("placements");
            if (placementsData == null) {
                Vungle.onInitError(callback, new VungleException(3));
                isInitializing.set(false);
                return;
            }
            CleverCacheSettings settings = CleverCacheSettings.fromJson(jsonObject);
            Downloader downloader = serviceLocator.getService(Downloader.class);
            if (settings != null) {
                boolean timestampChanged;
                CleverCacheSettings currentCacheSettings = CleverCacheSettings.deserializeFromString(preferences.getString("clever_cache", null));
                boolean bl = timestampChanged = currentCacheSettings == null || currentCacheSettings.getTimestamp() != settings.getTimestamp();
                if (!settings.isEnabled() || timestampChanged) {
                    downloader.clearCache();
                }
                downloader.setCacheEnabled(settings.isEnabled());
                preferences.put("clever_cache", settings.serializeToString()).apply();
            } else {
                downloader.setCacheEnabled(true);
            }
            final AdLoader adLoader = serviceLocator.getService(AdLoader.class);
            ArrayList<Placement> newPlacements = new ArrayList<Placement>();
            for (JsonElement jsonElement : placementsData) {
                newPlacements.add(new Placement(jsonElement.getAsJsonObject()));
            }
            repository.setValidPlacements(newPlacements);
            if (jsonObject.has("session")) {
                JsonObject sessionData = jsonObject.getAsJsonObject("session");
                boolean sessionDataEnabled = JsonUtil.hasNonNull((JsonElement)sessionData, "enabled") && sessionData.get("enabled").getAsBoolean();
                int sendLimit = JsonUtil.getAsInt((JsonElement)sessionData, "limit", 0);
                SessionTracker.getInstance().init(new SessionTracker.SessionCallback(){

                    @Override
                    public void onSessionTimeout() {
                        _instance.hbpOrdinalViewCount.set(0);
                    }
                }, new UtilityResource(), serviceLocator.getService(Repository.class), serviceLocator.getService(SDKExecutors.class).getSessionDataExecutor(), serviceLocator.getService(VungleApiClient.class), sessionDataEnabled, sendLimit);
                SessionTracker.getInstance().setAppSessionTimeout(JsonUtil.getAsInt((JsonElement)sessionData, "timeout", 900));
            }
            if (jsonObject.has("gdpr")) {
                TimeoutProvider provider = serviceLocator.getService(TimeoutProvider.class);
                GdprCookie gdprCookie = new GdprCookie(repository, provider);
                JsonObject gdprJsonObject = jsonObject.getAsJsonObject("gdpr");
                gdprCookie.save(gdprJsonObject);
            }
            if (jsonObject.has("logging")) {
                logManager = serviceLocator.getService(LogManager.class);
                JsonObject attributionLogging = jsonObject.getAsJsonObject("logging");
                enabled = JsonUtil.hasNonNull((JsonElement)attributionLogging, "enabled") ? attributionLogging.get("enabled").getAsBoolean() : false;
                logManager.setLoggingEnabled(enabled);
            }
            if (jsonObject.has("crash_report")) {
                logManager = serviceLocator.getService(LogManager.class);
                JsonObject crashConfig = jsonObject.getAsJsonObject("crash_report");
                enabled = JsonUtil.hasNonNull((JsonElement)crashConfig, "enabled") ? crashConfig.get("enabled").getAsBoolean() : false;
                String filter = JsonUtil.hasNonNull((JsonElement)crashConfig, "collect_filter") ? crashConfig.get("collect_filter").getAsString() : LogManager.sDefaultCollectFilter;
                int batchMax = JsonUtil.hasNonNull((JsonElement)crashConfig, "max_send_amount") ? crashConfig.get("max_send_amount").getAsInt() : 5;
                logManager.updateCrashReportConfig(enabled, filter, batchMax);
            }
            boolean cacheBustEnabled = false;
            int cacheBustInterval = 0;
            if (jsonObject.has("cache_bust")) {
                JsonObject cacheBustConfig = jsonObject.getAsJsonObject("cache_bust");
                if (cacheBustConfig.has("enabled")) {
                    cacheBustEnabled = cacheBustConfig.get("enabled").getAsBoolean();
                }
                if (cacheBustConfig.has("interval")) {
                    cacheBustInterval = cacheBustConfig.get("interval").getAsInt() * 1000;
                }
            }
            if ((configCookie = repository.load("configSettings", Cookie.class).get()) == null) {
                configCookie = new Cookie("configSettings");
            }
            JsonObject adLoadOptObject = jsonObject.getAsJsonObject("ad_load_optimization");
            boolean isAdDownloadOptEnabled = JsonUtil.getAsBoolean((JsonElement)adLoadOptObject, "enabled", false);
            adLoader.setAdLoadOptimizationEnabled(isAdDownloadOptEnabled);
            configCookie.putValue("isAdDownloadOptEnabled", isAdDownloadOptEnabled);
            if (jsonObject.has("ri")) {
                boolean isReportIncentivizedEnabled = jsonObject.getAsJsonObject("ri").get("enabled").getAsBoolean();
                configCookie.putValue("isReportIncentivizedEnabled", isReportIncentivizedEnabled);
            }
            boolean disableAdId = JsonUtil.getAsBoolean((JsonElement)jsonObject, "disable_ad_id", true);
            PrivacyManager.getInstance().updateDisableAdId(disableAdId);
            repository.save(configCookie);
            this.saveConfigExtension(repository, jsonObject);
            if (jsonObject.has("config")) {
                long sleep = jsonObject.getAsJsonObject("config").get("refresh_time").getAsLong();
                jobRunner.execute(ReconfigJob.makeJobInfo(this.appID).setDelay(sleep));
            }
            try {
                serviceLocator.getService(VisionController.class).setConfig(JsonUtil.hasNonNull((JsonElement)jsonObject, "vision") ? (VisionConfig)gson.fromJson((JsonElement)jsonObject.getAsJsonObject("vision"), VisionConfig.class) : new VisionConfig());
            }
            catch (DatabaseHelper.DBException dbException) {
                Log.e((String)TAG, (String)"not able to apply vision data config");
            }
            isInitialized = true;
            callback.onSuccess();
            VungleLogger.debug("Vungle#init", "onSuccess");
            isInitializing.set(false);
            SessionTracker.getInstance().observe();
            Collection<Placement> placements = repository.loadValidPlacements().get();
            jobRunner.execute(CleanupJob.makeJobInfo());
            if (placements != null) {
                final ArrayList<Placement> placementList = new ArrayList<Placement>(placements);
                final VungleSettings vungleSettings = runtimeValues.settings.get();
                Collections.sort(placementList, new Comparator<Placement>(){

                    @Override
                    public int compare(Placement o1, Placement o2) {
                        if (vungleSettings != null) {
                            if (o1.getId().equals(vungleSettings.getPriorityPlacement())) {
                                return -1;
                            }
                            if (o2.getId().equals(vungleSettings.getPriorityPlacement())) {
                                return 1;
                            }
                        }
                        return Integer.valueOf(o1.getAutoCachePriority()).compareTo(o2.getAutoCachePriority());
                    }
                });
                Log.d((String)TAG, (String)"starting jobs for autocached advs");
                ExecutorService uiExecutor = serviceLocator.getService(Executors.class).getUIExecutor();
                uiExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        for (Placement placement : placementList) {
                            adLoader.loadEndlessIfNeeded(placement, placement.getAdSize(), 0L, false);
                        }
                    }
                });
            }
            if (cacheBustEnabled) {
                CacheBustManager cacheBustManager = serviceLocator.getService(CacheBustManager.class);
                cacheBustManager.setRefreshRate(cacheBustInterval);
                cacheBustManager.startBust();
            }
            jobRunner.execute(SendReportsJob.makeJobInfo(!isReconfig));
            jobRunner.execute(SendLogsJob.makeJobInfo());
            SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.INIT_END).addData(SessionAttribute.SUCCESS, true).build());
            if (!preferences.getBoolean("reported", false)) {
                vungleApiClient.reportNew().enqueue(new Callback<JsonObject>(){

                    @Override
                    public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                        if (response.isSuccessful()) {
                            preferences.put("reported", true);
                            preferences.apply();
                            Log.d((String)TAG, (String)"Saving reported state to shared preferences");
                        }
                    }

                    @Override
                    public void onFailure(Call<JsonObject> call, Throwable throwable) {
                    }
                });
            }
        }
        catch (Throwable throwable) {
            isInitialized = false;
            isInitializing.set(false);
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)throwable));
            if (throwable instanceof HttpException) {
                Vungle.onInitError(callback, new VungleException(3));
            } else if (throwable instanceof DatabaseHelper.DBException) {
                Vungle.onInitError(callback, new VungleException(26));
            } else if (throwable instanceof UnknownHostException || throwable instanceof SecurityException) {
                Vungle.onInitError(callback, new VungleException(33));
            } else {
                Vungle.onInitError(callback, new VungleException(2));
            }
            SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.INIT_END).addData(SessionAttribute.SUCCESS, false).build());
        }
    }

    public static boolean isInitialized() {
        return isInitialized && Vungle._instance.context != null;
    }

    public static void setIncentivizedFields(final @Nullable String userID, final @Nullable String title, final @Nullable String body, final @Nullable String keepWatching, final @Nullable String close) {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized, context is null");
            return;
        }
        final ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        serviceLocator.getService(Executors.class).getBackgroundExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (!Vungle.isInitialized()) {
                    Log.e((String)TAG, (String)"Vungle is not initialized");
                    return;
                }
                Repository repository = serviceLocator.getService(Repository.class);
                Cookie incentivizedCookie = repository.load("incentivizedTextSetByPub", Cookie.class).get();
                if (incentivizedCookie == null) {
                    incentivizedCookie = new Cookie("incentivizedTextSetByPub");
                }
                String titleText = TextUtils.isEmpty((CharSequence)title) ? "" : title;
                String bodyText = TextUtils.isEmpty((CharSequence)body) ? "" : body;
                String continueText = TextUtils.isEmpty((CharSequence)keepWatching) ? "" : keepWatching;
                String closeText = TextUtils.isEmpty((CharSequence)close) ? "" : close;
                String userIdStr = TextUtils.isEmpty((CharSequence)userID) ? "" : userID;
                incentivizedCookie.putValue("title", titleText);
                incentivizedCookie.putValue("body", bodyText);
                incentivizedCookie.putValue("continue", continueText);
                incentivizedCookie.putValue("close", closeText);
                incentivizedCookie.putValue("userID", userIdStr);
                try {
                    repository.save(incentivizedCookie);
                }
                catch (DatabaseHelper.DBException e2) {
                    Log.e((String)TAG, (String)"Cannot save incentivized cookie", (Throwable)e2);
                }
            }
        });
    }

    public static boolean canPlayAd(@NonNull String placementId) {
        return Vungle.canPlayAd(placementId, null);
    }

    public static boolean canPlayAd(final @NonNull String placementId, final @Nullable String markup) {
        final Context context = Vungle._instance.context;
        if (context == null) {
            Log.e((String)TAG, (String)"Context is null");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)placementId)) {
            Log.e((String)TAG, (String)"AdMarkup/PlacementId is null");
            return false;
        }
        AdMarkup serializedAdMarkup = AdMarkupDecoder.decode(markup);
        if (markup != null && serializedAdMarkup == null) {
            Log.e((String)TAG, (String)"Invalid AdMarkup");
            return false;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(context);
        Executors sdkExecutors = serviceLocator.getService(Executors.class);
        TimeoutProvider provider = serviceLocator.getService(TimeoutProvider.class);
        FutureResult<Boolean> futureResult = new FutureResult<Boolean>(sdkExecutors.getApiExecutor().submit(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                if (!Vungle.isInitialized()) {
                    Log.e((String)TAG, (String)"Vungle is not initialized");
                    return false;
                }
                ServiceLocator serviceLocator = ServiceLocator.getInstance(context);
                Repository repository = serviceLocator.getService(Repository.class);
                AdMarkup adMarkup = AdMarkupDecoder.decode(markup);
                String eventId = adMarkup != null ? adMarkup.getEventId() : null;
                Placement placement = repository.load(placementId, Placement.class).get();
                if (placement == null || !placement.isValid()) {
                    return false;
                }
                if (placement.isMultipleHBPEnabled() && eventId == null) {
                    return false;
                }
                Advertisement advertisement = repository.findValidAdvertisementForPlacement(placementId, eventId).get();
                if (advertisement == null) {
                    return false;
                }
                if (placement.getPlacementAdType() == 1 || !AdConfig.AdSize.isDefaultAdSize(placement.getAdSize()) && !placement.getAdSize().equals((Object)advertisement.getAdConfig().getAdSize())) {
                    return false;
                }
                return Vungle.canPlayAd(advertisement);
            }
        }));
        return Boolean.TRUE.equals(futureResult.get(provider.getTimeout(), TimeUnit.MILLISECONDS));
    }

    static boolean canPlayAd(Advertisement advertisement) {
        if (Vungle._instance.context == null) {
            return false;
        }
        AdLoader adLoader = ServiceLocator.getInstance(Vungle._instance.context).getService(AdLoader.class);
        return adLoader.canPlayAd(advertisement);
    }

    private static void onPlayError(String placementId, PlayAdCallback playAdCallback, VungleException e2) {
        if (playAdCallback != null) {
            playAdCallback.onError(placementId, e2);
        }
        if (e2 != null) {
            String exMsg = e2.getLocalizedMessage() != null && e2.getLocalizedMessage().isEmpty() ? e2.getLocalizedMessage() : Integer.toString(e2.getExceptionCode());
            VungleLogger.error("Vungle#playAd", exMsg);
        }
        SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.PLAY_AD).addData(SessionAttribute.SUCCESS, false).build());
    }

    public static void playAd(@NonNull String placementId, AdConfig settings, @Nullable PlayAdCallback callback) {
        Vungle.playAd(placementId, null, settings, callback);
    }

    public static void playAd(final @NonNull String placementId, final @Nullable String markup, final AdConfig settings, @Nullable PlayAdCallback callback) {
        VungleLogger.debug("Vungle#playAd", "playAd call invoked");
        SessionTracker.getInstance().trackAdConfig(settings);
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Locator is not initialized");
            if (callback != null) {
                Vungle.onPlayError(placementId, callback, new VungleException(9));
            }
            return;
        }
        if (TextUtils.isEmpty((CharSequence)placementId)) {
            Vungle.onPlayError(placementId, callback, new VungleException(13));
            return;
        }
        AdMarkup serializedAdMarkup = AdMarkupDecoder.decode(markup);
        if (markup != null && serializedAdMarkup == null) {
            Vungle.onPlayError(placementId, callback, new VungleException(36));
            return;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        final Executors sdkExecutors = serviceLocator.getService(Executors.class);
        final Repository repository = serviceLocator.getService(Repository.class);
        final AdLoader adLoader = serviceLocator.getService(AdLoader.class);
        final VungleApiClient vungleApiClient = serviceLocator.getService(VungleApiClient.class);
        final PlayAdCallbackWrapper listener = new PlayAdCallbackWrapper(sdkExecutors.getUIExecutor(), callback);
        final Runnable OOMRunnable = new Runnable(){

            @Override
            public void run() {
                Vungle.onPlayError(placementId, listener, new VungleException(39));
            }
        };
        sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

            @Override
            public void run() {
                AdMarkup adMarkup = AdMarkupDecoder.decode(markup);
                final AdRequest request = new AdRequest(placementId, adMarkup, false);
                if (Boolean.TRUE.equals(_instance.playOperations.get(placementId)) || adLoader.isLoading(request)) {
                    Vungle.onPlayError(placementId, listener, new VungleException(8));
                    return;
                }
                final Placement placement = repository.load(placementId, Placement.class).get();
                if (placement == null) {
                    Vungle.onPlayError(placementId, listener, new VungleException(13));
                    return;
                }
                if (AdConfig.AdSize.isBannerAdSize(placement.getAdSize())) {
                    Log.e((String)TAG, (String)"Incorrect API for Banners and MREC");
                    Vungle.onPlayError(placementId, listener, new VungleException(28));
                    return;
                }
                boolean streamingOnly = false;
                Advertisement advertisement = repository.findPotentiallyExpiredAd(placementId, request.getEventId()).get();
                try {
                    boolean hasExpired;
                    long currentTime = System.currentTimeMillis() / 1000L;
                    boolean bl = hasExpired = advertisement != null && advertisement.getExpireTime() < currentTime;
                    if (!Vungle.canPlayAd(advertisement) || hasExpired) {
                        streamingOnly = true;
                        if (advertisement != null && (advertisement.getState() == 1 || hasExpired)) {
                            repository.saveAndApplyState(advertisement, placementId, 4);
                            adLoader.loadEndlessIfNeeded(placement, placement.getAdSize(), 0L, false);
                        }
                        if (hasExpired) {
                            SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.AD_EXPIRED).addData(SessionAttribute.EVENT_ID, advertisement.getId()).build());
                            Vungle.onPlayError(request.getPlacementId(), listener, new VungleException(37));
                            return;
                        }
                    } else {
                        advertisement.configure(settings);
                        repository.save(advertisement);
                    }
                }
                catch (DatabaseHelper.DBException ignored) {
                    Vungle.onPlayError(placementId, listener, new VungleException(26));
                    return;
                }
                if (_instance.context != null) {
                    final boolean finalStreamingOnly = streamingOnly;
                    final Advertisement finalAdvertisement = advertisement;
                    if (vungleApiClient.canCallWillPlayAd()) {
                        vungleApiClient.willPlayAd(placement.getId(), placement.isAutoCached(), streamingOnly ? "" : advertisement.getAdToken()).enqueue(new Callback<JsonObject>(){

                            @Override
                            public void onResponse(Call<JsonObject> call, final Response<JsonObject> response) {
                                sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        JsonObject responseBody;
                                        Advertisement streamingAd = null;
                                        if (response.isSuccessful() && (responseBody = (JsonObject)response.body()) != null && responseBody.has("ad")) {
                                            try {
                                                JsonObject adJson = responseBody.getAsJsonObject("ad");
                                                streamingAd = new Advertisement(adJson);
                                                streamingAd.configure(settings);
                                                repository.saveAndApplyState(streamingAd, placementId, 0);
                                            }
                                            catch (IllegalArgumentException e2) {
                                                VungleLogger.debug("Vungle#playAd", "streaming ads IllegalArgumentException");
                                                Log.v((String)TAG, (String)"Will Play Ad did not respond with a replacement. Move on.");
                                            }
                                            catch (Exception e3) {
                                                VungleLogger.error("Vungle#playAd", "streaming ads Exception :" + e3.getLocalizedMessage());
                                                Log.e((String)TAG, (String)"Error using will_play_ad!", (Throwable)e3);
                                            }
                                        }
                                        if (finalStreamingOnly) {
                                            if (streamingAd == null) {
                                                Vungle.onPlayError(placementId, listener, new VungleException(1));
                                            } else {
                                                Vungle.renderAd(request, listener, placement, streamingAd);
                                            }
                                        } else {
                                            Vungle.renderAd(request, listener, placement, finalAdvertisement);
                                        }
                                    }
                                }, OOMRunnable);
                            }

                            @Override
                            public void onFailure(Call<JsonObject> call, Throwable throwable) {
                                sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (finalStreamingOnly) {
                                            Vungle.onPlayError(placementId, listener, new VungleException(1));
                                        } else {
                                            Vungle.renderAd(request, listener, placement, finalAdvertisement);
                                        }
                                    }
                                }, OOMRunnable);
                            }
                        });
                    } else if (finalStreamingOnly) {
                        Vungle.onPlayError(placementId, listener, new VungleException(1));
                    } else {
                        Vungle.renderAd(request, listener, placement, finalAdvertisement);
                    }
                }
            }
        }, OOMRunnable);
    }

    private static synchronized void renderAd(@NonNull AdRequest request, @Nullable PlayAdCallback listener, Placement placement, Advertisement advertisement) {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Sdk is not initialized");
            return;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        VungleActivity.setEventListener(new AdEventListener(request, (Map)Vungle._instance.playOperations, listener, serviceLocator.getService(Repository.class), serviceLocator.getService(AdLoader.class), serviceLocator.getService(JobRunner.class), serviceLocator.getService(VisionController.class), placement, advertisement){

            @Override
            protected void onFinished() {
                super.onFinished();
                VungleActivity.setEventListener(null);
            }
        });
        Intent intent = AdActivity.createIntent(Vungle._instance.context, request);
        ActivityManager.startWhenForeground(Vungle._instance.context, null, intent, null);
    }

    static AdEventListener getEventListener(@NonNull AdRequest request, @Nullable PlayAdCallback listener) {
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        return new AdEventListener(request, Vungle._instance.playOperations, listener, serviceLocator.getService(Repository.class), serviceLocator.getService(AdLoader.class), serviceLocator.getService(JobRunner.class), serviceLocator.getService(VisionController.class), null, null);
    }

    private static void onLoadError(String placementId, @Nullable LoadAdCallback loadAdCallback, VungleException e2) {
        if (loadAdCallback != null) {
            loadAdCallback.onError(placementId, e2);
        }
        if (e2 != null) {
            String exMsg = e2.getLocalizedMessage() != null && e2.getLocalizedMessage().isEmpty() ? e2.getLocalizedMessage() : Integer.toString(e2.getExceptionCode());
            VungleLogger.error("Vungle#loadAd", exMsg);
        }
    }

    public static void loadAd(@NonNull String placementId, @Nullable LoadAdCallback callback) {
        Vungle.loadAd(placementId, new AdConfig(), callback);
    }

    public static void loadAd(@NonNull String placementId, @Nullable AdConfig adConfig, @Nullable LoadAdCallback callback) {
        Vungle.loadAd(placementId, null, adConfig, callback);
    }

    public static void loadAd(@NonNull String placementId, @Nullable String markup, @Nullable AdConfig adConfig, @Nullable LoadAdCallback callback) {
        VungleLogger.debug("Vungle#loadAd", "loadAd API call invoked");
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized");
            Vungle.onLoadError(placementId, callback, new VungleException(9));
            return;
        }
        if (adConfig != null && !AdConfig.AdSize.isDefaultAdSize(adConfig.getAdSize())) {
            Vungle.onLoadError(placementId, callback, new VungleException(29));
            return;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        Repository repository = serviceLocator.getService(Repository.class);
        TimeoutProvider provider = serviceLocator.getService(TimeoutProvider.class);
        Placement placement = repository.load(placementId, Placement.class).get(provider.getTimeout(), TimeUnit.MILLISECONDS);
        if (placement != null && placement.getPlacementAdType() == 4) {
            Vungle.onLoadError(placementId, callback, new VungleException(41));
            return;
        }
        Vungle.loadAdInternal(placementId, markup, adConfig, callback);
    }

    static void loadAdInternal(@NonNull String placementId, @Nullable String markup, @Nullable AdConfig adConfig, @Nullable LoadAdCallback callback) {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized");
            Vungle.onLoadError(placementId, callback, new VungleException(9));
            return;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        LoadAdCallbackWrapper listener = callback instanceof LoadNativeAdCallback ? new LoadNativeAdCallbackWrapper(serviceLocator.getService(Executors.class).getUIExecutor(), (LoadNativeAdCallback)callback) : new LoadAdCallbackWrapper(serviceLocator.getService(Executors.class).getUIExecutor(), callback);
        AdMarkup serializedAdMarkup = AdMarkupDecoder.decode(markup);
        if (!TextUtils.isEmpty((CharSequence)markup) && serializedAdMarkup == null) {
            Vungle.onLoadError(placementId, callback, new VungleException(36));
            return;
        }
        AdMarkup adMarkup = AdMarkupDecoder.decode(markup);
        AdLoader adLoader = serviceLocator.getService(AdLoader.class);
        if (adConfig == null) {
            adConfig = new AdConfig();
        }
        adLoader.load(new AdRequest(placementId, adMarkup, true), adConfig, listener);
    }

    private static void clearCache() {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized");
            return;
        }
        final ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        serviceLocator.getService(Executors.class).getBackgroundExecutor().execute(new Runnable(){

            @Override
            public void run() {
                serviceLocator.getService(Downloader.class).cancelAll();
                serviceLocator.getService(AdLoader.class).clear();
                serviceLocator.getService(Repository.class).clearAllData();
                _instance.playOperations.clear();
                _instance.ccpaStatus.set(null);
                _instance.configure(serviceLocator.getService(RuntimeValues.class).initCallback.get(), true);
            }
        });
    }

    private static void clearAdvertisements() {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized");
            return;
        }
        final ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        serviceLocator.getService(Executors.class).getBackgroundExecutor().execute(new Runnable(){

            @Override
            public void run() {
                serviceLocator.getService(Downloader.class).cancelAll();
                serviceLocator.getService(AdLoader.class).clear();
                final Repository repository = serviceLocator.getService(Repository.class);
                Executors sdkExecutors = serviceLocator.getService(Executors.class);
                sdkExecutors.getBackgroundExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        List<Advertisement> ads = repository.loadAll(Advertisement.class).get();
                        if (ads != null) {
                            for (Advertisement ad : ads) {
                                try {
                                    repository.deleteAdvertisement(ad.getId());
                                }
                                catch (DatabaseHelper.DBException dBException) {}
                            }
                        }
                    }
                });
            }
        });
    }

    @Nullable
    static VungleBannerView getBannerViewInternal(String placementId, AdMarkup markup, AdConfig adConfig, PlayAdCallback playAdCallback) {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized, returned VungleBannerView = null");
            Vungle.onPlayError(placementId, playAdCallback, new VungleException(9));
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)placementId)) {
            Vungle.onPlayError(placementId, playAdCallback, new VungleException(13));
            return null;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        AdLoader adLoader = serviceLocator.getService(AdLoader.class);
        AdRequest request = new AdRequest(placementId, markup, true);
        boolean isLoading = adLoader.isLoading(request);
        if (Boolean.TRUE.equals(Vungle._instance.playOperations.get(placementId)) || isLoading) {
            Log.e((String)TAG, (String)("Playing or Loading operation ongoing. Playing " + Vungle._instance.playOperations.get(request.getPlacementId()) + " Loading: " + isLoading));
            Vungle.onPlayError(placementId, playAdCallback, new VungleException(8));
            return null;
        }
        try {
            return new VungleBannerView(Vungle._instance.context.getApplicationContext(), request, adConfig, serviceLocator.getService(PresentationFactory.class), new AdEventListener(request, Vungle._instance.playOperations, playAdCallback, serviceLocator.getService(Repository.class), adLoader, serviceLocator.getService(JobRunner.class), serviceLocator.getService(VisionController.class), null, null));
        }
        catch (Exception e2) {
            VungleLogger.error("Vungle#playAd", "Vungle banner ad fail: " + e2.getLocalizedMessage());
            if (playAdCallback != null) {
                playAdCallback.onError(placementId, new VungleException(10));
            }
            return null;
        }
    }

    public static Collection<String> getValidPlacements() {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized return empty placements list");
            return Collections.emptyList();
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        Repository repository = serviceLocator.getService(Repository.class);
        TimeoutProvider provider = serviceLocator.getService(TimeoutProvider.class);
        Collection<String> placements = repository.getValidPlacementIds().get(provider.getTimeout(), TimeUnit.MILLISECONDS);
        if (placements == null) {
            return Collections.emptyList();
        }
        return placements;
    }

    @VisibleForTesting
    static Collection<Placement> getValidPlacementModels() {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized return empty placements list");
            return Collections.emptyList();
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        Repository repository = serviceLocator.getService(Repository.class);
        TimeoutProvider provider = serviceLocator.getService(TimeoutProvider.class);
        Collection<Placement> placements = repository.loadValidPlacements().get(provider.getTimeout(), TimeUnit.MILLISECONDS);
        if (placements == null) {
            return Collections.emptyList();
        }
        return placements;
    }

    @VisibleForTesting
    static Collection<Advertisement> getValidAdvertisementModels(@NonNull String placementId) {
        if (!Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"Vungle is not initialized return empty placements list");
            return Collections.emptyList();
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        Repository repository = serviceLocator.getService(Repository.class);
        TimeoutProvider provider = serviceLocator.getService(TimeoutProvider.class);
        Collection advertisements = repository.findValidAdvertisementsForPlacement(placementId, null).get(provider.getTimeout(), TimeUnit.MILLISECONDS);
        if (advertisements == null) {
            return Collections.emptyList();
        }
        return advertisements;
    }

    public static void updateConsentStatus(@NonNull Consent status, @Nullable String consentMessageVersion) {
        if (status == null) {
            Log.e((String)TAG, (String)"Cannot set consent with a null consent, please check your code");
            return;
        }
        Vungle._instance.consent.set(status);
        Vungle._instance.consentVersion = consentMessageVersion;
        if (Vungle.isInitialized() && isDepInit.get()) {
            ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
            Repository repository = serviceLocator.getService(Repository.class);
            Vungle.saveGDPRConsent(repository, Vungle._instance.consent.get(), Vungle._instance.consentVersion);
        } else {
            Log.e((String)TAG, (String)"Vungle is not initialized");
        }
    }

    private static void saveGDPRConsent(final @NonNull Repository repository, final @NonNull Consent status, final @Nullable String consentMessageVersion) {
        repository.load("consentIsImportantToVungle", Cookie.class, new Repository.LoadCallback<Cookie>(){

            @Override
            public void onLoaded(Cookie gdprConsent) {
                if (gdprConsent == null) {
                    gdprConsent = new Cookie("consentIsImportantToVungle");
                }
                gdprConsent.putValue("consent_status", status == Consent.OPTED_IN ? "opted_in" : "opted_out");
                gdprConsent.putValue("timestamp", System.currentTimeMillis() / 1000L);
                gdprConsent.putValue("consent_source", "publisher");
                gdprConsent.putValue("consent_message_version", consentMessageVersion == null ? "" : consentMessageVersion);
                repository.save(gdprConsent, null, false);
            }
        });
    }

    @Nullable
    public static Consent getConsentStatus() {
        if (Vungle.isInitialized() && isDepInit.get()) {
            Cookie consentCookie = Vungle.getGDPRConsent();
            return Vungle.getConsentStatus(consentCookie);
        }
        return Vungle._instance.consent.get();
    }

    private static Consent getConsentStatus(Cookie cookie) {
        String consentString;
        if (cookie == null) {
            return null;
        }
        switch (consentString = cookie.getString("consent_status")) {
            case "opted_out_by_timeout": 
            case "opted_out": {
                Vungle._instance.consent.set(Consent.OPTED_OUT);
                return Consent.OPTED_OUT;
            }
            case "opted_in": {
                Vungle._instance.consent.set(Consent.OPTED_IN);
                return Consent.OPTED_IN;
            }
        }
        return null;
    }

    @Nullable
    private static Cookie getGDPRConsent() {
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        TimeoutProvider provider = serviceLocator.getService(TimeoutProvider.class);
        return serviceLocator.getService(Repository.class).load("consentIsImportantToVungle", Cookie.class).get(provider.getTimeout(), TimeUnit.MILLISECONDS);
    }

    public static String getConsentMessageVersion() {
        return Vungle._instance.consentVersion;
    }

    private static Consent getConsent(Cookie gdprConsent) {
        if (gdprConsent == null) {
            return null;
        }
        return "opted_in".equals(gdprConsent.getString("consent_status")) ? Consent.OPTED_IN : Consent.OPTED_OUT;
    }

    private static String getConsentMessageVersion(Cookie gdprConsent) {
        if (gdprConsent == null) {
            return null;
        }
        return gdprConsent.getString("consent_message_version");
    }

    private static String getConsentSource(Cookie gdprConsent) {
        if (gdprConsent == null) {
            return null;
        }
        return gdprConsent.getString("consent_source");
    }

    public static void updateCCPAStatus(@NonNull Consent status) {
        if (status == null) {
            Log.e((String)TAG, (String)"Unable to update CCPA status, Invalid input parameter.");
            return;
        }
        Vungle._instance.ccpaStatus.set(status);
        if (!Vungle.isInitialized() || !isDepInit.get()) {
            Log.e((String)TAG, (String)"Vungle is not initialized");
            return;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        Repository repository = serviceLocator.getService(Repository.class);
        Vungle.updateCCPAStatus(repository, status);
    }

    private static void updateCCPAStatus(final @NonNull Repository repository, final @NonNull Consent status) {
        repository.load("ccpaIsImportantToVungle", Cookie.class, new Repository.LoadCallback<Cookie>(){

            @Override
            public void onLoaded(Cookie ccpaConsent) {
                if (ccpaConsent == null) {
                    ccpaConsent = new Cookie("ccpaIsImportantToVungle");
                }
                ccpaConsent.putValue("ccpa_status", status == Consent.OPTED_OUT ? "opted_out" : "opted_in");
                repository.save(ccpaConsent, null, false);
            }
        });
    }

    @Nullable
    public static Consent getCCPAStatus() {
        return Vungle._instance.ccpaStatus.get();
    }

    private static Consent getCCPAStatus(@Nullable Cookie ccpaConsent) {
        if (ccpaConsent == null) {
            return null;
        }
        return "opted_out".equals(ccpaConsent.getString("ccpa_status")) ? Consent.OPTED_OUT : Consent.OPTED_IN;
    }

    public static void setHeaderBiddingCallback(HeaderBiddingCallback headerBiddingCallback) {
        if (Vungle._instance.context == null) {
            return;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
        RuntimeValues runtimeValues = serviceLocator.getService(RuntimeValues.class);
        runtimeValues.headerBiddingCallback.set(new HeaderBiddingCallbackWrapper(serviceLocator.getService(Executors.class).getUIExecutor(), headerBiddingCallback));
    }

    public static String getAvailableBidTokens(@NonNull Context context) {
        return Vungle.getAvailableBidTokens(context, null, 0);
    }

    public static void updateUserCoppaStatus(boolean isUserCoppa) {
        PrivacyManager.getInstance().updateCoppaStatus(isUserCoppa);
        if (Vungle.isInitialized()) {
            Log.e((String)TAG, (String)"COPPA status changes should be passed before SDK initialization, they will ONLY take into effect during future SDK initializations and sessions");
            return;
        }
    }

    @Deprecated
    public static String getAvailableBidTokensBySize(@NonNull Context context, int maxBidTokenSizeBytes) {
        return Vungle.getAvailableBidTokens(context, null, maxBidTokenSizeBytes);
    }

    @Nullable
    public static String getAvailableBidTokens(@NonNull Context context, final @Nullable String placementId, final int maxBidTokenSizeBytes) {
        if (context == null) {
            Log.e((String)TAG, (String)"Context is null");
            return null;
        }
        ServiceLocator serviceLocator = ServiceLocator.getInstance(context);
        Executors sdkExecutors = serviceLocator.getService(Executors.class);
        TimeoutProvider provider = serviceLocator.getService(TimeoutProvider.class);
        final BidTokenEncoder bidTokenEncoder = serviceLocator.getService(BidTokenEncoder.class);
        FutureResult<String> futureResult = new FutureResult<String>(sdkExecutors.getApiExecutor().submit(new Callable<String>(){

            @Override
            public String call() {
                String superToken = bidTokenEncoder.encode(placementId, maxBidTokenSizeBytes, _instance.hbpOrdinalViewCount.incrementAndGet());
                Log.d((String)TAG, (String)("Supertoken is " + superToken));
                return superToken;
            }
        }));
        return futureResult.get(provider.getTimeout(), TimeUnit.MILLISECONDS);
    }

    private void saveConfigExtension(Repository repository, JsonObject jsonObject) throws DatabaseHelper.DBException {
        Cookie configExt = new Cookie("config_extension");
        String configExtension = "";
        if (jsonObject.has("config_extension")) {
            configExtension = JsonUtil.getAsString((JsonElement)jsonObject, "config_extension", "");
        }
        configExt.putValue("config_extension", configExtension);
        repository.save(configExt);
    }

    protected static void deInit() {
        if (Vungle._instance.context != null) {
            ServiceLocator serviceLocator = ServiceLocator.getInstance(Vungle._instance.context);
            if (serviceLocator.isCreated(CacheManager.class)) {
                serviceLocator.getService(CacheManager.class).removeListener(cacheListener);
            }
            if (serviceLocator.isCreated(Downloader.class)) {
                serviceLocator.getService(Downloader.class).cancelAll();
            }
            if (serviceLocator.isCreated(AdLoader.class)) {
                serviceLocator.getService(AdLoader.class).clear();
            }
            Vungle._instance.playOperations.clear();
        }
        ServiceLocator.deInit();
        isInitialized = false;
        isDepInit.set(false);
        isInitializing.set(false);
    }

    private static void stopPlaying() {
        if (Vungle._instance.context == null) {
            return;
        }
        Intent broadcast = new Intent("AdvertisementBus");
        broadcast.putExtra("command", "stopAll");
        LocalBroadcastManager.getInstance((Context)Vungle._instance.context).sendBroadcast(broadcast);
    }

    @Nullable
    static Context appContext() {
        if (_instance != null) {
            return Vungle._instance.context;
        }
        return null;
    }

    static {
        isInitializing = new AtomicBoolean(false);
        isDepInit = new AtomicBoolean(false);
        gson = new GsonBuilder().create();
        cacheListener = new CacheManager.Listener(){

            @Override
            public void onCacheChanged() {
                if (_instance.context == null) {
                    return;
                }
                Vungle.stopPlaying();
                ServiceLocator serviceLocator = ServiceLocator.getInstance(_instance.context);
                CacheManager cacheManager = serviceLocator.getService(CacheManager.class);
                Downloader downloader = serviceLocator.getService(Downloader.class);
                if (cacheManager.getCache() != null) {
                    List<DownloadRequest> requests = downloader.getAllRequests();
                    String newPath = cacheManager.getCache().getPath();
                    for (DownloadRequest request : requests) {
                        if (request.path.startsWith(newPath)) continue;
                        downloader.cancel(request);
                    }
                }
                downloader.init();
            }
        };
    }

    @Keep
    public static enum Consent {
        OPTED_IN,
        OPTED_OUT;

    }
}

