/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.downloader;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.downloader.DownloadRequest;
import java.io.File;

public interface AssetDownloadListener {
    public void onError(@NonNull DownloadError var1, @Nullable DownloadRequest var2);

    public void onProgress(@NonNull Progress var1, @NonNull DownloadRequest var2);

    public void onSuccess(@NonNull File var1, @NonNull DownloadRequest var2);

    public static class Progress {
        @ProgressStatus
        public int status;
        public int progressPercent;
        public long timestampDownloadStart;
        public long startBytes;
        public long sizeBytes;

        public static Progress copy(Progress progress) {
            Progress copy = new Progress();
            copy.status = progress.status;
            copy.progressPercent = progress.progressPercent;
            copy.timestampDownloadStart = progress.timestampDownloadStart;
            copy.sizeBytes = progress.sizeBytes;
            copy.startBytes = progress.startBytes;
            return copy;
        }

        public static @interface ProgressStatus {
            public static final int STARTED = 0;
            public static final int IN_PROGRESS = 1;
            public static final int PAUSED = 2;
            public static final int CANCELLED = 3;
            public static final int DONE = 4;
            public static final int LOST_CONNECTION = 5;
            public static final int STATE_CHANGED = 6;
        }
    }

    public static class DownloadError {
        @ErrorReason
        public final int reason;
        public final int serverCode;
        public final Throwable cause;

        public DownloadError(int serverCode, Throwable th, int reason) {
            this.serverCode = serverCode;
            this.cause = th;
            this.reason = reason;
        }

        public static @interface ErrorReason {
            public static final int CONNECTION_ERROR = 0;
            public static final int REQUEST_ERROR = 1;
            public static final int DISK_ERROR = 2;
            public static final int FILE_NOT_FOUND_ERROR = 3;
            public static final int INTERNAL_ERROR = 4;
        }
    }
}

