/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.log;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.utility.FileUtility;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

class BaseFilePersistor {
    private static final String TAG = BaseFilePersistor.class.getSimpleName();
    @Nullable
    protected File fileDir;
    protected String fileNamePrefix;
    protected String fileNameSuffix;
    protected String rootFileDirectory;

    public BaseFilePersistor(@Nullable File cacheDir, String rootFileDirectory, String fileNamePrefix, String fileNameSuffix) {
        this.fileNamePrefix = fileNamePrefix;
        this.fileNameSuffix = fileNameSuffix;
        this.rootFileDirectory = rootFileDirectory;
        if (cacheDir != null) {
            this.fileDir = this.getOrCreateDirectory(cacheDir, rootFileDirectory);
        }
    }

    @Nullable
    protected File getOrCreateDirectory(@NonNull File baseDir, String newDirectory) {
        File dataDir = this.createFileOrDirectory(baseDir, newDirectory, true);
        if (dataDir == null || !dataDir.exists()) {
            return null;
        }
        return dataDir;
    }

    protected static String getDateText(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());
        return sdf.format(new Date(time));
    }

    protected boolean renameFile(@NonNull File srcFile, @NonNull String destFileName) {
        if (!srcFile.exists() || !srcFile.isFile()) {
            return false;
        }
        File destFile = new File(this.fileDir, destFileName);
        if (destFile.exists()) {
            return false;
        }
        boolean ret = srcFile.renameTo(destFile);
        return ret;
    }

    @Nullable
    protected File createFileOrDirectory(@NonNull File parentDir, @NonNull String fileName, boolean isDir) {
        boolean ret = false;
        File file = new File(parentDir, fileName);
        if (!file.exists()) {
            if (!isDir) {
                try {
                    ret = file.createNewFile();
                }
                catch (IOException e2) {
                    Log.e((String)TAG, (String)("Can't create new file " + file.getName()), (Throwable)e2);
                }
            } else {
                ret = file.mkdir();
            }
        } else {
            ret = true;
        }
        return ret ? file : null;
    }

    @Nullable
    protected File[] getFilesWithSuffix(final String suffix) {
        if (this.isRootDirInvalid()) {
            return null;
        }
        return this.fileDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(suffix);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean appendLineToFile(File file, String value, @Nullable FileSaveCallback saveCallback) {
        FileWriter fileWriter = null;
        int lineCount = 0;
        try {
            fileWriter = new FileWriter(file, true);
            lineCount = this.getLineCount(file);
            if (lineCount > 0) {
                fileWriter.append("\n");
            }
            fileWriter.append(value);
            fileWriter.flush();
        }
        catch (IOException e2) {
            boolean bl;
            try {
                if (saveCallback != null) {
                    saveCallback.onFailure();
                }
                bl = false;
            }
            catch (Throwable throwable) {
                FileUtility.closeQuietly(fileWriter);
                throw throwable;
            }
            FileUtility.closeQuietly(fileWriter);
            return bl;
        }
        FileUtility.closeQuietly(fileWriter);
        if (saveCallback != null) {
            saveCallback.onSuccess(file, lineCount + 1);
        }
        return true;
    }

    @Nullable
    File getNewFile(String name) {
        return this.createFileOrDirectory(this.fileDir, name, false);
    }

    public void sortFilesByNewest(File[] files) {
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o2.getName().compareTo(o1.getName());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getLineCount(File file) {
        int lineCount;
        if (file == null) {
            return 0;
        }
        LineNumberReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(file.getAbsolutePath()));
            while (reader.readLine() != null) {
            }
            lineCount = reader.getLineNumber();
            FileUtility.closeQuietly(reader);
        }
        catch (Exception ex) {
            lineCount = -1;
        }
        finally {
            FileUtility.closeQuietly(reader);
        }
        return lineCount;
    }

    public boolean isRootDirInvalid() {
        return this.fileDir == null || !this.fileDir.exists();
    }

    public void deleteFile(File file) {
        try {
            FileUtility.delete(file);
        }
        catch (IOException e2) {
            Log.e((String)TAG, (String)"File failed to delete");
        }
    }

    static interface FileSaveCallback {
        public void onSuccess(File var1, int var2);

        public void onFailure();
    }
}

