/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.log;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.gson.Gson;
import com.vungle.warren.Vungle;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.log.JVMCrashCollector;
import com.vungle.warren.log.LogPersister;
import com.vungle.warren.log.LogSender;
import com.vungle.warren.persistence.CacheManager;
import com.vungle.warren.persistence.FilePreferences;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class LogManager {
    private static final String TAG = LogManager.class.getSimpleName();
    static final String LOGGER_PREFS_FILENAME = "com.vungle.sdk";
    @VisibleForTesting
    static final String PREFS_LOGGING_ENABLED_KEY = "logging_enabled";
    static final String PREFS_CRASH_REPORT_ENABLED_KEY = "crash_report_enabled";
    static final String PREFS_CRASH_COLLECT_FILTER_KEY = "crash_collect_filter";
    static final String PREFS_CRASH_BATCH_MAX_KEY = "crash_batch_max";
    public static final boolean DEFAULT_LOGGING_ENABLED = false;
    public static final boolean DEFAULT_CRASH_COLLECT_ENABLED = false;
    public static final int DEFAULT_CRASH_SEND_BATCH_MAX = 5;
    public static String sDefaultCollectFilter = "com.vungle";
    private final LogPersister logPersister;
    private final LogSender logSender;
    private final Executor ioExecutor;
    private final FilePreferences prefs;
    private JVMCrashCollector jvmCrashCollector;
    private final AtomicBoolean loggingEnabled = new AtomicBoolean(false);
    private final AtomicBoolean crashReportEnabled = new AtomicBoolean(false);
    private String crashCollectFilter = sDefaultCollectFilter;
    private AtomicInteger crashBatchMax = new AtomicInteger(5);
    private boolean isCrashReportInit = false;
    private final String bundleID;
    private final Map<String, String> customDataMap = new ConcurrentHashMap<String, String>();
    private Gson gson = new Gson();
    private SdkLoggingEventListener sdkLoggingEventListener = new SdkLoggingEventListener(){

        @Override
        public void sendPendingLogs() {
            LogManager.this.sendPendingLogs();
        }

        @Override
        public boolean isCrashReportEnabled() {
            return LogManager.this.isCrashReportEnabled();
        }

        @Override
        public void saveLog(@NonNull VungleLogger.LoggerLevel level, @NonNull String context, @NonNull String message, @Nullable String exClass, @Nullable String threadId) {
            LogManager.this.saveLog(level, context, message, exClass, threadId);
        }
    };

    public LogManager(@NonNull Context context, @NonNull CacheManager cacheManager, @NonNull VungleApiClient vungleApiClient, @NonNull Executor executor, @NonNull FilePreferences prefs) {
        this(context, new LogPersister(cacheManager.getCache()), new LogSender(vungleApiClient, prefs), executor, prefs);
    }

    @VisibleForTesting
    LogManager(@NonNull Context context, @NonNull LogPersister logPersister, @NonNull LogSender logSender, @NonNull Executor executor, @NonNull FilePreferences prefs) {
        this.bundleID = context.getPackageName();
        this.logSender = logSender;
        this.logPersister = logPersister;
        this.ioExecutor = executor;
        this.prefs = prefs;
        this.logPersister.setSdkLoggingEventListener(this.sdkLoggingEventListener);
        Package vungleSdkPackage = Vungle.class.getPackage();
        if (vungleSdkPackage != null) {
            sDefaultCollectFilter = vungleSdkPackage.getName();
        }
        this.loggingEnabled.set(prefs.getBoolean(PREFS_LOGGING_ENABLED_KEY, false));
        this.crashReportEnabled.set(prefs.getBoolean(PREFS_CRASH_REPORT_ENABLED_KEY, false));
        this.crashCollectFilter = prefs.getString(PREFS_CRASH_COLLECT_FILTER_KEY, sDefaultCollectFilter);
        this.crashBatchMax.set(prefs.getInt(PREFS_CRASH_BATCH_MAX_KEY, 5));
        this.initJvmCollector();
    }

    public void setMaxEntries(int maxEntries) {
        this.logPersister.setMaximumEntries(maxEntries <= 0 ? 100 : maxEntries);
    }

    public void setLoggingEnabled(boolean isEnabled) {
        if (this.loggingEnabled.compareAndSet(!isEnabled, isEnabled)) {
            this.prefs.put(PREFS_LOGGING_ENABLED_KEY, isEnabled);
            this.prefs.apply();
        }
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled.get();
    }

    public boolean isCrashReportEnabled() {
        return this.crashReportEnabled.get();
    }

    public void addCustomData(@NonNull String key, @NonNull String value) {
        this.customDataMap.put(key, value);
    }

    public void removeCustomData(@NonNull String key) {
        this.customDataMap.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLog(final @NonNull VungleLogger.LoggerLevel level, final @NonNull String context, final @NonNull String message, final @Nullable String exClass, final @Nullable String threadId) {
        String eventID = "";
        final String userAgent = VungleApiClient.getHeaderUa();
        if (level == VungleLogger.LoggerLevel.CRASH && this.isCrashReportEnabled()) {
            LogManager logManager = this;
            synchronized (logManager) {
                this.logPersister.saveCrashLogData(message, level.toString(), context, "", userAgent, this.bundleID, this.getCustomData(), exClass, threadId);
            }
        } else {
            this.ioExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (LogManager.this.isLoggingEnabled()) {
                        LogManager.this.logPersister.saveLogData(message, level.toString(), context, "", userAgent, LogManager.this.bundleID, LogManager.this.getCustomData(), exClass, threadId);
                    }
                }
            });
        }
    }

    public void sendSdkLogs() {
        this.sendCrashLogs();
        this.sendPendingLogs();
    }

    private String getCustomData() {
        return this.customDataMap.isEmpty() ? null : this.gson.toJson(this.customDataMap);
    }

    private void sendPendingLogs() {
        if (!this.isLoggingEnabled()) {
            Log.d((String)TAG, (String)"Logging disabled, no need to send log files.");
            return;
        }
        File[] pendingFiles = this.logPersister.getPendingFiles();
        if (pendingFiles == null || pendingFiles.length == 0) {
            Log.d((String)TAG, (String)"No need to send empty files.");
            return;
        }
        this.logSender.sendLogs(pendingFiles);
    }

    public synchronized void updateCrashReportConfig(boolean enabled, @Nullable String collectFilter, int batchMax) {
        boolean batchMaxChanged;
        boolean enableChanged = this.crashReportEnabled.get() != enabled;
        boolean filterChanged = !TextUtils.isEmpty((CharSequence)collectFilter) && !collectFilter.equals(this.crashCollectFilter);
        batchMax = Math.max(batchMax, 0);
        boolean bl = batchMaxChanged = this.crashBatchMax.get() != batchMax;
        if (enableChanged || filterChanged || batchMaxChanged) {
            if (enableChanged) {
                this.crashReportEnabled.set(enabled);
                this.prefs.put(PREFS_CRASH_REPORT_ENABLED_KEY, enabled);
            }
            if (filterChanged) {
                this.crashCollectFilter = "*".equals(collectFilter) ? "" : collectFilter;
                this.prefs.put(PREFS_CRASH_COLLECT_FILTER_KEY, this.crashCollectFilter);
            }
            if (batchMaxChanged) {
                this.crashBatchMax.set(batchMax);
                this.prefs.put(PREFS_CRASH_BATCH_MAX_KEY, batchMax);
            }
            this.prefs.apply();
            if (this.jvmCrashCollector != null) {
                this.jvmCrashCollector.updateConfig(this.crashCollectFilter);
            }
            if (enabled) {
                this.initJvmCollector();
            }
        }
    }

    private void sendCrashLogs() {
        if (!this.isCrashReportEnabled()) {
            Log.d((String)TAG, (String)"Crash report disabled, no need to send crash log files.");
            return;
        }
        File[] crashReportFiles = this.logPersister.getCrashReportFiles(this.crashBatchMax.get());
        if (crashReportFiles == null || crashReportFiles.length == 0) {
            Log.d((String)TAG, (String)"No need to send empty crash log files.");
            return;
        }
        this.logSender.sendLogs(crashReportFiles);
    }

    synchronized void initJvmCollector() {
        if (!this.isCrashReportInit) {
            if (!this.isCrashReportEnabled()) {
                Log.d((String)TAG, (String)"crash report is disabled.");
                return;
            }
            if (this.jvmCrashCollector == null) {
                this.jvmCrashCollector = new JVMCrashCollector(this.sdkLoggingEventListener);
            }
            this.jvmCrashCollector.updateConfig(this.crashCollectFilter);
            this.isCrashReportInit = true;
        }
    }

    static interface SdkLoggingEventListener {
        public void sendPendingLogs();

        public boolean isCrashReportEnabled();

        public void saveLog(@NonNull VungleLogger.LoggerLevel var1, @NonNull String var2, @NonNull String var3, @Nullable String var4, @Nullable String var5);
    }
}

