/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.log;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.log.BaseFilePersistor;
import com.vungle.warren.log.LogEntry;
import com.vungle.warren.log.LogManager;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.TimeZone;
import java.util.UUID;

class LogPersister
extends BaseFilePersistor {
    private static final String TAG = LogPersister.class.getSimpleName();
    private static final String SDK_LOGS_DIR = "sdk_logs";
    private static final String SDK_LOG_FILE_PATTERN = "log_";
    private static final String SDK_CRASH_LOG_FILE_PATTERN = "crash_";
    private static final String SDK_LOG_FILE_PENDING = "_pending";
    private static final String SDK_LOG_FILE_CRASH = "_crash";
    private LogManager.SdkLoggingEventListener listener;
    private File currentFile;
    private int maximumEntries = 100;

    LogPersister(@Nullable File cacheDir) {
        super(cacheDir, SDK_LOGS_DIR, SDK_LOG_FILE_PATTERN, SDK_LOG_FILE_PENDING);
        if (this.fileDir != null) {
            this.currentFile = this.getOrCreateLastFile();
        }
    }

    void setSdkLoggingEventListener(@NonNull LogManager.SdkLoggingEventListener listener) {
        this.listener = listener;
    }

    void setMaximumEntries(int maximumEntries) {
        this.maximumEntries = maximumEntries;
    }

    void saveLogData(@NonNull String message, @NonNull String logLevel, @NonNull String context, @Nullable String eventID, @Nullable String userAgent, @Nullable String bundleID, @Nullable String customData, @Nullable String exClass, @Nullable String threadId) {
        String timeZone = TimeZone.getDefault().getID();
        String creationDate = LogPersister.getDateText(System.currentTimeMillis());
        LogEntry logEntry = new LogEntry(message, logLevel, context, eventID, userAgent, bundleID, timeZone, creationDate, customData, exClass, threadId);
        this.saveEntryToFile(this.currentFile, logEntry.toJsonString(), new BaseFilePersistor.FileSaveCallback(){

            @Override
            public void onSuccess(File file, int lineCount) {
                boolean pendingSucceed;
                if (lineCount >= LogPersister.this.maximumEntries && (pendingSucceed = LogPersister.this.renameFile(LogPersister.this.currentFile, file.getName() + LogPersister.SDK_LOG_FILE_PENDING))) {
                    LogPersister.this.currentFile = LogPersister.this.getOrCreateLastFile();
                    if (LogPersister.this.listener != null) {
                        LogPersister.this.listener.sendPendingLogs();
                    }
                }
            }

            @Override
            public void onFailure() {
                Log.e((String)TAG, (String)"Failed to write sdk logs.");
            }
        });
    }

    @Nullable
    File[] getPendingFiles() {
        return this.getFilesWithSuffix(SDK_LOG_FILE_PENDING);
    }

    @Nullable
    File[] getCrashReportFiles(int crashBatchMax) {
        File[] crashFiles = this.getFilesWithSuffix(SDK_LOG_FILE_CRASH);
        if (crashFiles == null || crashFiles.length == 0) {
            return null;
        }
        this.sortFilesByNewest(crashFiles);
        return Arrays.copyOfRange(crashFiles, 0, Math.min(crashFiles.length, crashBatchMax));
    }

    protected boolean saveEntryToFile(File file, String value, @Nullable BaseFilePersistor.FileSaveCallback fileSaveCallback) {
        if (file == null || !file.exists()) {
            Log.d((String)TAG, (String)"current log file maybe deleted, create new one.");
            file = this.currentFile = this.getOrCreateLastFile();
            if (this.currentFile == null || !this.currentFile.exists()) {
                Log.w((String)TAG, (String)"Can't create log file, maybe no space left.");
                return false;
            }
        }
        return this.appendLineToFile(file, value, fileSaveCallback);
    }

    @Nullable
    File getOrCreateLastFile() {
        if (this.fileDir == null || !this.fileDir.exists()) {
            Log.w((String)TAG, (String)"No log cache dir found.");
            return null;
        }
        File[] dataFiles = this.fileDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.endsWith(LogPersister.this.fileNameSuffix);
            }
        });
        if (dataFiles == null || dataFiles.length == 0) {
            return this.getNewFile(this.fileNamePrefix + System.currentTimeMillis() + UUID.randomUUID().toString());
        }
        this.sortFilesByNewest(dataFiles);
        File loggingFile = dataFiles[0];
        int lineCount = this.getLineCount(loggingFile);
        if (lineCount <= 0 || lineCount < this.maximumEntries) {
            return loggingFile;
        }
        File newLoggingFile = null;
        try {
            boolean pendingSucceed = this.renameFile(loggingFile, loggingFile.getName() + this.fileNameSuffix);
            if (pendingSucceed) {
                newLoggingFile = this.getOrCreateLastFile();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (newLoggingFile == null) {
            newLoggingFile = loggingFile;
        }
        return newLoggingFile;
    }

    public void saveCrashLogData(@NonNull String message, @NonNull String logLevel, @NonNull String context, @Nullable String eventID, @Nullable String userAgent, @Nullable String bundleID, @Nullable String customData, @Nullable String exClass, @Nullable String threadId) {
        if (this.fileDir == null) {
            Log.w((String)TAG, (String)"No log cache dir found.");
            return;
        }
        String timeZone = TimeZone.getDefault().getID();
        String creationDate = LogPersister.getDateText(System.currentTimeMillis());
        LogEntry logEntry = new LogEntry(message, logLevel, context, eventID, userAgent, bundleID, timeZone, creationDate, customData, exClass, threadId);
        String crashFileName = SDK_CRASH_LOG_FILE_PATTERN + System.currentTimeMillis();
        final File crashFile = this.createFileOrDirectory(this.fileDir, crashFileName, false);
        if (crashFile != null) {
            this.appendLineToFile(crashFile, logEntry.toJsonString(), new BaseFilePersistor.FileSaveCallback(){

                @Override
                public void onSuccess(File file, int lineCount) {
                    LogPersister.this.renameFile(crashFile, crashFile.getName() + LogPersister.SDK_LOG_FILE_CRASH);
                }

                @Override
                public void onFailure() {
                    Log.e((String)TAG, (String)"Failed to write crash log.");
                }
            });
        }
    }
}

