/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.log;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.network.Response;
import com.vungle.warren.persistence.FilePreferences;
import com.vungle.warren.utility.FileUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.UUID;

class LogSender {
    private static final String TAG = LogSender.class.getSimpleName();
    private static final String PREFS_DEVICE_ID_KEY = "device_id";
    private static final String PREFS_BATCH_ID_KEY = "batch_id";
    private static final String HEADER_LOG_BATCH_ID = "batch_id";
    private static final String HEADER_LOG_DEVICE_ID = "device_guid";
    private static final String HEADER_LOG_PAYLOAD = "payload";
    private final VungleApiClient vungleApiClient;
    private final FilePreferences prefs;
    private final String deviceId;
    private int batchId;

    LogSender(@NonNull VungleApiClient apiClient, @NonNull FilePreferences prefs) {
        this.vungleApiClient = apiClient;
        this.prefs = prefs;
        this.deviceId = this.getDeviceId();
        this.batchId = this.getBatchId();
    }

    void sendLogs(@NonNull File[] pendingFiles) {
        for (File loggingFile : pendingFiles) {
            JsonObject requestBody = new JsonObject();
            requestBody.addProperty("batch_id", (Number)this.batchId);
            requestBody.addProperty(HEADER_LOG_DEVICE_ID, this.deviceId);
            try {
                JsonArray payload = this.getPayload(loggingFile);
                if (payload == null) {
                    FileUtility.delete(loggingFile);
                    continue;
                }
                requestBody.add(HEADER_LOG_PAYLOAD, (JsonElement)payload);
                Response<JsonObject> response = this.vungleApiClient.sendLog(requestBody).execute();
                if (response.isSuccessful()) {
                    FileUtility.delete(loggingFile);
                }
            }
            catch (IOException e2) {
                Log.e((String)TAG, (String)"Failed to generate request payload.");
            }
            if (this.batchId >= Integer.MAX_VALUE) {
                this.batchId = -1;
            }
            ++this.batchId;
        }
        this.saveBatchId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private JsonArray getPayload(@NonNull File logFile) {
        JsonArray logArray = new JsonArray();
        BufferedReader reader = null;
        try {
            String logItem;
            reader = new BufferedReader(new FileReader(logFile));
            while ((logItem = reader.readLine()) != null) {
                JsonObject logEntry = JsonParser.parseString((String)logItem).getAsJsonObject();
                logArray.add((JsonElement)logEntry);
            }
        }
        catch (Exception e2) {
            JsonArray jsonArray;
            try {
                Log.e((String)TAG, (String)"Invalidate log document file.");
                jsonArray = null;
            }
            catch (Throwable throwable) {
                FileUtility.closeQuietly(reader);
                throw throwable;
            }
            FileUtility.closeQuietly(reader);
            return jsonArray;
        }
        FileUtility.closeQuietly(reader);
        return logArray;
    }

    @NonNull
    private String getDeviceId() {
        String uuid = this.prefs.getString(PREFS_DEVICE_ID_KEY, "");
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            uuid = UUID.randomUUID().toString();
            this.prefs.put(PREFS_DEVICE_ID_KEY, uuid);
            this.prefs.apply();
        }
        return uuid;
    }

    private int getBatchId() {
        return this.prefs.getInt("batch_id", 0);
    }

    private void saveBatchId() {
        this.prefs.put("batch_id", this.batchId);
        this.prefs.apply();
    }
}

