/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.UUID;

public class AdAsset {
    public final String identifier;
    public final String adIdentifier;
    public String parentId;
    public final String serverPath;
    public final String localPath;
    public int status;
    public int fileType;
    public long fileSize;
    public int retryCount;
    int retryTypeError;

    public AdAsset(@NonNull String adIdentifier, @Nullable String serverPath, @NonNull String localPath) {
        this(adIdentifier, serverPath, localPath, UUID.randomUUID().toString());
    }

    AdAsset(@NonNull String adIdentifier, @Nullable String serverPath, @NonNull String localPath, String id) {
        this.identifier = id;
        this.adIdentifier = adIdentifier;
        this.serverPath = serverPath;
        this.localPath = localPath;
        this.fileSize = -1L;
        this.retryCount = 0;
        this.retryTypeError = 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdAsset adAsset = (AdAsset)o;
        if (this.status != adAsset.status) {
            return false;
        }
        if (this.fileType != adAsset.fileType) {
            return false;
        }
        if (this.fileSize != adAsset.fileSize) {
            return false;
        }
        if (this.retryCount != adAsset.retryCount) {
            return false;
        }
        if (this.retryTypeError != adAsset.retryTypeError) {
            return false;
        }
        if (this.identifier != null ? !this.identifier.equals(adAsset.identifier) : adAsset.identifier != null) {
            return false;
        }
        if (this.adIdentifier != null ? !this.adIdentifier.equals(adAsset.adIdentifier) : adAsset.adIdentifier != null) {
            return false;
        }
        if (this.parentId != null ? !this.parentId.equals(adAsset.parentId) : adAsset.parentId != null) {
            return false;
        }
        if (this.serverPath != null ? !this.serverPath.equals(adAsset.serverPath) : adAsset.serverPath != null) {
            return false;
        }
        return this.localPath != null ? this.localPath.equals(adAsset.localPath) : adAsset.localPath == null;
    }

    public int hashCode() {
        int result = this.identifier != null ? this.identifier.hashCode() : 0;
        result = 31 * result + (this.adIdentifier != null ? this.adIdentifier.hashCode() : 0);
        result = 31 * result + (this.parentId != null ? this.parentId.hashCode() : 0);
        result = 31 * result + (this.serverPath != null ? this.serverPath.hashCode() : 0);
        result = 31 * result + (this.localPath != null ? this.localPath.hashCode() : 0);
        result = 31 * result + this.status;
        result = 31 * result + this.fileType;
        result = 31 * result + (int)(this.fileSize ^ this.fileSize >>> 32);
        result = 31 * result + this.retryCount;
        result = 31 * result + this.retryTypeError;
        return result;
    }

    public String toString() {
        return "AdAsset{identifier='" + this.identifier + '\'' + ", adIdentifier='" + this.adIdentifier + '\'' + ", serverPath='" + this.serverPath + '\'' + ", localPath='" + this.localPath + '\'' + ", status=" + this.status + ", fileType=" + this.fileType + ", fileSize=" + this.fileSize + ", retryCount=" + this.retryCount + ", retryTypeError=" + this.retryTypeError + '}';
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ErrorType {
        public static final int NO_ERROR = 0;
        public static final int CAN_RETRY_ERROR = 1;
        public static final int CANNOT_RETRY_ERROR = 2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FileType {
        public static final int ZIP = 0;
        public static final int ZIP_ASSET = 1;
        public static final int ASSET = 2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
        public static final int NEW = 0;
        public static final int DOWNLOAD_RUNNING = 1;
        public static final int DOWNLOAD_FAILED = 2;
        public static final int DOWNLOAD_SUCCESS = 3;
        public static final int PROCESSED = 4;
    }
}

