/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model;

import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.webkit.URLUtil;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.LinkedTreeMap;
import com.vungle.warren.AdConfig;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.model.AdAsset;
import com.vungle.warren.model.AdvertisementDBAdapter;
import com.vungle.warren.model.JsonUtil;
import com.vungle.warren.utility.HashUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import okhttp3.HttpUrl;
import org.json.JSONException;
import org.json.JSONObject;

public class Advertisement
implements Comparable<Advertisement> {
    private static final String TAG = "Advertisement";
    public static final String TPAT_CLICK_COORDINATES_URLS = "video.clickCoordinates";
    private static final String MRAID_ARGS = "mraid_args";
    public static final String FILE_SCHEME = "file://";
    static final String START_MUTED = "START_MUTED";
    static final String INCENTIVIZED_TITLE_TEXT = "INCENTIVIZED_TITLE_TEXT";
    static final String INCENTIVIZED_BODY_TEXT = "INCENTIVIZED_BODY_TEXT";
    static final String INCENTIVIZED_CLOSE_TEXT = "INCENTIVIZED_CLOSE_TEXT";
    static final String INCENTIVIZED_CONTINUE_TEXT = "INCENTIVIZED_CONTINUE_TEXT";
    private static final String UNKNOWN = "unknown";
    private static final Collection<String> STATIC_TPAT_EVENTS = Arrays.asList("play_percentage", "checkpoint.0", "checkpoint.25", "checkpoint.50", "checkpoint.75", "checkpoint.100");
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private Gson gson;
    public static final int TYPE_VUNGLE_LOCAL = 0;
    public static final int TYPE_VUNGLE_MRAID = 1;
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    public static final String KEY_POSTROLL = "postroll";
    public static final String KEY_VIDEO = "video";
    public static final String KEY_TEMPLATE = "template";
    public static final int NEW = 0;
    public static final int READY = 1;
    public static final int VIEWING = 2;
    public static final int DONE = 3;
    public static final int ERROR = 4;
    public static final int INVALID = 5;
    @AdType
    int adType;
    String identifier;
    String appID;
    long expireTime;
    List<Checkpoint> checkpoints;
    Map<String, ArrayList<String>> dynamicEventsAndUrls;
    int delay;
    String campaign;
    int showCloseDelay;
    int showCloseIncentivized;
    int countdown;
    String videoUrl;
    int videoWidth;
    int videoHeight;
    String md5;
    String postrollBundleUrl;
    boolean ctaOverlayEnabled;
    boolean ctaClickArea;
    String ctaDestinationUrl;
    String ctaUrl;
    AdConfig adConfig;
    int retryCount;
    String adToken;
    String videoIdentifier;
    String templateUrl;
    Map<String, String> templateSettings;
    Map<String, String> mraidFiles;
    Map<String, Pair<String, String>> cacheableAssets;
    Map<String, String> incentivizedTextSettings;
    String templateId;
    String templateType;
    boolean enableOm;
    @Nullable
    String omExtraVast;
    boolean requiresNonMarketInstall;
    String adMarketId;
    String bidToken;
    boolean headerBidding;
    int state;
    String placementId;
    long ttDownload;
    String deeplink;
    @VisibleForTesting
    public long assetDownloadStartTime;
    @VisibleForTesting
    public long assetDownloadDuration;
    @VisibleForTesting
    public long adRequestStartTime;
    long serverRequestTimestamp;
    boolean clickCoordinatesEnabled;
    public boolean assetsFullyDownloaded;
    private List<String> winNotifications;

    @Override
    public int compareTo(Advertisement o) {
        if (o == null) {
            return 1;
        }
        if (o.identifier == null) {
            if (this.identifier == null) {
                return 0;
            }
            return 1;
        }
        if (this.identifier == null) {
            return -1;
        }
        return this.identifier.compareTo(o.identifier);
    }

    Advertisement() {
        this.gson = new Gson();
        this.dynamicEventsAndUrls = new LinkedTreeMap();
        this.ctaClickArea = true;
        this.mraidFiles = new HashMap<String, String>();
        this.cacheableAssets = new HashMap<String, Pair<String, String>>();
        this.incentivizedTextSettings = new HashMap<String, String>();
        this.state = 0;
        this.assetsFullyDownloaded = false;
        this.winNotifications = new ArrayList<String>();
    }

    public long getTtDownload() {
        return this.ttDownload;
    }

    public String getPlacementId() {
        return this.placementId;
    }

    public void setPlacementId(String placementId) {
        this.placementId = placementId;
    }

    public void setAssetDownloadStartTime(long timeStamp) {
        this.assetDownloadStartTime = timeStamp;
    }

    public void setFinishedDownloadingTime(long timeStamp) {
        this.assetDownloadDuration = timeStamp - this.assetDownloadStartTime;
        this.ttDownload = timeStamp - this.adRequestStartTime;
    }

    public void setAdRequestStartTime(long timeStamp) {
        this.adRequestStartTime = timeStamp;
    }

    public long getAssetDownloadDuration() {
        return this.assetDownloadDuration;
    }

    public boolean isCtaOverlayEnabled() {
        return this.ctaOverlayEnabled;
    }

    public boolean getCtaClickArea() {
        return this.ctaClickArea;
    }

    public long getServerRequestTimestamp() {
        return this.serverRequestTimestamp;
    }

    public boolean isRequiresNonMarketInstall() {
        return this.requiresNonMarketInstall;
    }

    public Advertisement(@NonNull JsonObject json) throws IllegalArgumentException {
        long expire;
        String tempVideoUrl;
        JsonObject adMarkup;
        block47: {
            block46: {
                this.gson = new Gson();
                this.dynamicEventsAndUrls = new LinkedTreeMap();
                this.ctaClickArea = true;
                this.mraidFiles = new HashMap<String, String>();
                this.cacheableAssets = new HashMap<String, Pair<String, String>>();
                this.incentivizedTextSettings = new HashMap<String, String>();
                this.state = 0;
                this.assetsFullyDownloaded = false;
                this.winNotifications = new ArrayList<String>();
                if (!JsonUtil.hasNonNull((JsonElement)json, "ad_markup")) {
                    throw new IllegalArgumentException("JSON does not contain ad markup!");
                }
                adMarkup = json.getAsJsonObject("ad_markup");
                tempVideoUrl = "";
                if (!JsonUtil.hasNonNull((JsonElement)adMarkup, "adType")) break block46;
                String adTypeRaw = adMarkup.get("adType").getAsString();
                switch (adTypeRaw) {
                    case "vungle_local": {
                        this.adType = 0;
                        String string = this.postrollBundleUrl = JsonUtil.hasNonNull((JsonElement)adMarkup, "postBundle") ? adMarkup.get("postBundle").getAsString() : "";
                        if (JsonUtil.hasNonNull((JsonElement)adMarkup, "url")) {
                            tempVideoUrl = adMarkup.get("url").getAsString();
                        }
                        this.templateSettings = new HashMap<String, String>();
                        this.templateUrl = "";
                        this.templateId = "";
                        this.templateType = "";
                        break;
                    }
                    case "vungle_mraid": {
                        this.adType = 1;
                        this.postrollBundleUrl = "";
                        if (JsonUtil.hasNonNull((JsonElement)adMarkup, "templateSettings")) {
                            this.templateSettings = new HashMap<String, String>();
                            JsonObject templateJson = adMarkup.getAsJsonObject("templateSettings");
                            if (JsonUtil.hasNonNull((JsonElement)templateJson, "normal_replacements")) {
                                JsonObject normalReplacements = templateJson.getAsJsonObject("normal_replacements");
                                for (Map.Entry element : normalReplacements.entrySet()) {
                                    if (TextUtils.isEmpty((CharSequence)((CharSequence)element.getKey()))) continue;
                                    String value = element.getValue() == null || ((JsonElement)element.getValue()).isJsonNull() ? null : ((JsonElement)element.getValue()).getAsString();
                                    this.templateSettings.put((String)element.getKey(), value);
                                }
                            }
                            if (JsonUtil.hasNonNull((JsonElement)templateJson, "cacheable_replacements")) {
                                JsonObject cacheable = templateJson.getAsJsonObject("cacheable_replacements");
                                for (Map.Entry element : cacheable.entrySet()) {
                                    if (TextUtils.isEmpty((CharSequence)((CharSequence)element.getKey())) || element.getValue() == null || !JsonUtil.hasNonNull((JsonElement)element.getValue(), "url") || !JsonUtil.hasNonNull((JsonElement)element.getValue(), "extension")) continue;
                                    String url = ((JsonElement)element.getValue()).getAsJsonObject().get("url").getAsString();
                                    String ext = ((JsonElement)element.getValue()).getAsJsonObject().get("extension").getAsString();
                                    this.cacheableAssets.put((String)element.getKey(), (Pair<String, String>)new Pair((Object)url, (Object)ext));
                                    if (!((String)element.getKey()).equalsIgnoreCase("MAIN_VIDEO")) continue;
                                    tempVideoUrl = url;
                                }
                            }
                        } else {
                            throw new IllegalArgumentException("Missing template adConfig!");
                        }
                        if (!JsonUtil.hasNonNull((JsonElement)adMarkup, "templateId")) {
                            throw new IllegalArgumentException("Missing templateID!");
                        }
                        this.templateId = adMarkup.get("templateId").getAsString();
                        if (!JsonUtil.hasNonNull((JsonElement)adMarkup, "template_type")) {
                            throw new IllegalArgumentException("Template Type missing!");
                        }
                        this.templateType = adMarkup.get("template_type").getAsString();
                        if (!this.isNativeTemplateType()) {
                            if (JsonUtil.hasNonNull((JsonElement)adMarkup, "templateURL")) {
                                this.templateUrl = adMarkup.get("templateURL").getAsString();
                                break;
                            }
                            throw new IllegalArgumentException("Template URL missing!");
                        }
                        break block47;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown Ad Type " + adTypeRaw + "! Please add this ad type");
                    }
                }
                break block47;
            }
            throw new IllegalArgumentException("Advertisement did not contain an adType!");
        }
        this.videoUrl = !TextUtils.isEmpty((CharSequence)tempVideoUrl) ? tempVideoUrl : "";
        if (JsonUtil.hasNonNull((JsonElement)adMarkup, "deeplinkUrl")) {
            this.deeplink = adMarkup.get("deeplinkUrl").getAsString();
        }
        if (!JsonUtil.hasNonNull((JsonElement)adMarkup, "id")) {
            throw new IllegalArgumentException("Missing identifier, cannot process advertisement!");
        }
        this.identifier = adMarkup.get("id").getAsString();
        if (!JsonUtil.hasNonNull((JsonElement)adMarkup, "campaign")) {
            throw new IllegalArgumentException("Missing campaign information, cannot process advertisement!");
        }
        this.campaign = adMarkup.get("campaign").getAsString();
        if (!JsonUtil.hasNonNull((JsonElement)adMarkup, "app_id")) {
            throw new IllegalArgumentException("Missing app Id, cannot process advertisement!");
        }
        this.appID = adMarkup.get("app_id").getAsString();
        this.expireTime = JsonUtil.hasNonNull((JsonElement)adMarkup, "expiry") && !adMarkup.get("expiry").isJsonNull() ? ((expire = adMarkup.get("expiry").getAsLong()) > 0L ? expire : System.currentTimeMillis() / 1000L) : System.currentTimeMillis() / 1000L;
        if (JsonUtil.hasNonNull((JsonElement)adMarkup, "notification")) {
            JsonArray notifications = adMarkup.getAsJsonArray("notification");
            for (JsonElement notification : notifications) {
                this.winNotifications.add(notification.getAsString());
            }
        }
        if (JsonUtil.hasNonNull((JsonElement)adMarkup, "tpat")) {
            JsonObject tpat = adMarkup.getAsJsonObject("tpat");
            this.checkpoints = new ArrayList<Checkpoint>(5);
            switch (this.adType) {
                case 0: {
                    int x;
                    if (!JsonUtil.hasNonNull((JsonElement)tpat, "play_percentage")) break;
                    JsonArray checkpointData = tpat.getAsJsonArray("play_percentage");
                    for (x = 0; x < checkpointData.size(); ++x) {
                        if (checkpointData.get(x) == null) continue;
                        this.checkpoints.add(new Checkpoint(checkpointData.get(x).getAsJsonObject()));
                    }
                    Collections.sort(this.checkpoints);
                    break;
                }
                case 1: {
                    int x;
                    String checkpoint = null;
                    for (x = 0; x < 5; ++x) {
                        int percent = x * 25;
                        checkpoint = String.format(Locale.ENGLISH, "checkpoint.%d", percent);
                        Checkpoint cpoint = null;
                        if (JsonUtil.hasNonNull((JsonElement)tpat, checkpoint)) {
                            cpoint = new Checkpoint(tpat.getAsJsonArray(checkpoint), (byte)percent);
                        }
                        this.checkpoints.add(x, cpoint);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Ad Type!");
                }
            }
            TreeSet tpatEntries = new TreeSet(tpat.keySet());
            tpatEntries.remove("moat");
            tpatEntries.removeAll(STATIC_TPAT_EVENTS);
            if (!tpatEntries.isEmpty()) {
                for (String tpatEntryKey : tpatEntries) {
                    JsonArray urls = tpat.get(tpatEntryKey).getAsJsonArray();
                    ArrayList<String> actionUrls = new ArrayList<String>();
                    for (int x = 0; x < urls.size(); ++x) {
                        if (null == urls.get(x) || "null".equalsIgnoreCase(urls.get(x).toString())) {
                            actionUrls.add(x, "");
                            continue;
                        }
                        actionUrls.add(x, urls.get(x).getAsString());
                    }
                    this.dynamicEventsAndUrls.put(tpatEntryKey, actionUrls);
                }
            }
        } else {
            this.checkpoints = new ArrayList<Checkpoint>();
        }
        this.delay = JsonUtil.hasNonNull((JsonElement)adMarkup, "delay") ? adMarkup.get("delay").getAsInt() : 0;
        this.showCloseDelay = JsonUtil.hasNonNull((JsonElement)adMarkup, "showClose") ? adMarkup.get("showClose").getAsInt() : 0;
        this.showCloseIncentivized = JsonUtil.hasNonNull((JsonElement)adMarkup, "showCloseIncentivized") ? adMarkup.get("showCloseIncentivized").getAsInt() : 0;
        this.countdown = JsonUtil.hasNonNull((JsonElement)adMarkup, "countdown") ? adMarkup.get("countdown").getAsInt() : 0;
        if (!JsonUtil.hasNonNull((JsonElement)adMarkup, "videoWidth")) {
            throw new IllegalArgumentException("Missing video width!");
        }
        this.videoWidth = adMarkup.get("videoWidth").getAsInt();
        if (!JsonUtil.hasNonNull((JsonElement)adMarkup, "videoHeight")) {
            throw new IllegalArgumentException("Missing video height!");
        }
        this.videoHeight = adMarkup.get("videoHeight").getAsInt();
        this.md5 = JsonUtil.hasNonNull((JsonElement)adMarkup, "md5") ? adMarkup.get("md5").getAsString() : "";
        if (JsonUtil.hasNonNull((JsonElement)adMarkup, "cta_overlay")) {
            JsonObject cta = adMarkup.getAsJsonObject("cta_overlay");
            this.ctaOverlayEnabled = JsonUtil.hasNonNull((JsonElement)cta, "enabled") ? cta.get("enabled").getAsBoolean() : false;
            if (JsonUtil.hasNonNull((JsonElement)cta, "click_area") && !cta.get("click_area").getAsString().isEmpty() && cta.get("click_area").getAsDouble() == 0.0) {
                this.ctaClickArea = false;
            }
        } else {
            this.ctaOverlayEnabled = false;
        }
        this.ctaDestinationUrl = JsonUtil.hasNonNull((JsonElement)adMarkup, "callToActionDest") ? adMarkup.get("callToActionDest").getAsString() : "";
        String string = this.ctaUrl = JsonUtil.hasNonNull((JsonElement)adMarkup, "callToActionUrl") ? adMarkup.get("callToActionUrl").getAsString() : "";
        if (TextUtils.isEmpty((CharSequence)this.ctaUrl)) {
            this.ctaUrl = this.templateSettings.get("CTA_BUTTON_URL");
        }
        this.retryCount = JsonUtil.hasNonNull((JsonElement)adMarkup, "retryCount") ? adMarkup.get("retryCount").getAsInt() : 1;
        if (!JsonUtil.hasNonNull((JsonElement)adMarkup, "ad_token")) {
            throw new IllegalArgumentException("AdToken missing!");
        }
        this.adToken = adMarkup.get("ad_token").getAsString();
        this.videoIdentifier = JsonUtil.hasNonNull((JsonElement)adMarkup, "video_object_id") ? adMarkup.get("video_object_id").getAsString() : "";
        this.requiresNonMarketInstall = JsonUtil.hasNonNull((JsonElement)adMarkup, "requires_sideloading") ? adMarkup.get("requires_sideloading").getAsBoolean() : false;
        this.adMarketId = JsonUtil.hasNonNull((JsonElement)adMarkup, "ad_market_id") ? adMarkup.get("ad_market_id").getAsString() : "";
        this.bidToken = JsonUtil.hasNonNull((JsonElement)adMarkup, "bid_token") ? adMarkup.get("bid_token").getAsString() : "";
        this.serverRequestTimestamp = JsonUtil.hasNonNull((JsonElement)adMarkup, "timestamp") ? adMarkup.get("timestamp").getAsLong() : 1L;
        JsonObject viewability = JsonUtil.getAsObject((JsonElement)adMarkup, "viewability");
        JsonObject om = JsonUtil.getAsObject((JsonElement)viewability, "om");
        this.enableOm = JsonUtil.getAsBoolean((JsonElement)om, "is_enabled", false);
        this.omExtraVast = JsonUtil.getAsString((JsonElement)om, "extra_vast", null);
        this.clickCoordinatesEnabled = JsonUtil.getAsBoolean((JsonElement)adMarkup, "click_coordinates_enabled", false);
        this.adConfig = new AdConfig();
    }

    @AdType
    public int getAdType() {
        return this.adType;
    }

    public List<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    public void configure(AdConfig settings) {
        this.adConfig = settings == null ? new AdConfig() : settings;
    }

    public AdConfig getAdConfig() {
        return this.adConfig;
    }

    @Orientation
    public int getOrientation() {
        if (this.videoWidth > this.videoHeight) {
            return 1;
        }
        return 0;
    }

    public boolean isNativeTemplateType() {
        return "native".equals(this.templateType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Advertisement)) {
            return false;
        }
        Advertisement wrap = (Advertisement)obj;
        if (wrap.adType != this.adType) {
            return false;
        }
        if (wrap.delay != this.delay) {
            return false;
        }
        if (wrap.showCloseDelay != this.showCloseDelay) {
            return false;
        }
        if (wrap.showCloseIncentivized != this.showCloseIncentivized) {
            return false;
        }
        if (wrap.countdown != this.countdown) {
            return false;
        }
        if (wrap.videoWidth != this.videoWidth) {
            return false;
        }
        if (wrap.videoHeight != this.videoHeight) {
            return false;
        }
        if (wrap.ctaOverlayEnabled != this.ctaOverlayEnabled) {
            return false;
        }
        if (wrap.ctaClickArea != this.ctaClickArea) {
            return false;
        }
        if (wrap.retryCount != this.retryCount) {
            return false;
        }
        if (wrap.enableOm != this.enableOm) {
            return false;
        }
        if (wrap.requiresNonMarketInstall != this.requiresNonMarketInstall) {
            return false;
        }
        if (wrap.state != this.state) {
            return false;
        }
        if (wrap.identifier == null || this.identifier == null) {
            return false;
        }
        if (!wrap.identifier.equals(this.identifier)) {
            return false;
        }
        if (!wrap.campaign.equals(this.campaign)) {
            return false;
        }
        if (!wrap.videoUrl.equals(this.videoUrl)) {
            return false;
        }
        if (!wrap.md5.equals(this.md5)) {
            return false;
        }
        if (!wrap.postrollBundleUrl.equals(this.postrollBundleUrl)) {
            return false;
        }
        if (!wrap.ctaDestinationUrl.equals(this.ctaDestinationUrl)) {
            return false;
        }
        if (!wrap.ctaUrl.equals(this.ctaUrl)) {
            return false;
        }
        if (!wrap.adToken.equals(this.adToken)) {
            return false;
        }
        if (!wrap.videoIdentifier.equals(this.videoIdentifier)) {
            return false;
        }
        if (wrap.omExtraVast != null ? !wrap.omExtraVast.equals(this.omExtraVast) : this.omExtraVast != null) {
            return false;
        }
        if (!wrap.adMarketId.equals(this.adMarketId)) {
            return false;
        }
        if (!wrap.bidToken.equals(this.bidToken)) {
            return false;
        }
        if (wrap.checkpoints.size() != this.checkpoints.size()) {
            return false;
        }
        for (int x = 0; x < this.checkpoints.size(); ++x) {
            if (wrap.checkpoints.get(x).equals(this.checkpoints.get(x))) continue;
            return false;
        }
        if (!this.dynamicEventsAndUrls.equals(wrap.dynamicEventsAndUrls)) {
            return false;
        }
        if (wrap.serverRequestTimestamp != this.serverRequestTimestamp) {
            return false;
        }
        if (wrap.clickCoordinatesEnabled != this.clickCoordinatesEnabled) {
            return false;
        }
        return wrap.headerBidding == this.headerBidding;
    }

    public int hashCode() {
        int result = this.adType;
        result = 31 * result + HashUtility.getHashCode(this.identifier);
        result = 31 * result + HashUtility.getHashCode(this.checkpoints);
        result = 31 * result + HashUtility.getHashCode(this.dynamicEventsAndUrls);
        result = 31 * result + this.delay;
        result = 31 * result + HashUtility.getHashCode(this.campaign);
        result = 31 * result + this.showCloseDelay;
        result = 31 * result + this.showCloseIncentivized;
        result = 31 * result + this.countdown;
        result = 31 * result + HashUtility.getHashCode(this.videoUrl);
        result = 31 * result + this.videoWidth;
        result = 31 * result + this.videoHeight;
        result = 31 * result + HashUtility.getHashCode(this.md5);
        result = 31 * result + HashUtility.getHashCode(this.postrollBundleUrl);
        result = 31 * result + (this.ctaOverlayEnabled ? 1 : 0);
        result = 31 * result + (this.ctaClickArea ? 1 : 0);
        result = 31 * result + HashUtility.getHashCode(this.ctaDestinationUrl);
        result = 31 * result + HashUtility.getHashCode(this.ctaUrl);
        result = 31 * result + this.retryCount;
        result = 31 * result + HashUtility.getHashCode(this.adToken);
        result = 31 * result + HashUtility.getHashCode(this.videoIdentifier);
        result = 31 * result + HashUtility.getHashCode(this.winNotifications);
        result = 31 * result + (this.enableOm ? 1 : 0);
        result = 31 * result + HashUtility.getHashCode(this.omExtraVast);
        result = 31 * result + (this.requiresNonMarketInstall ? 1 : 0);
        result = 31 * result + HashUtility.getHashCode(this.adMarketId);
        result = 31 * result + HashUtility.getHashCode(this.bidToken);
        result = 31 * result + this.state;
        result = (int)((long)(31 * result) + this.serverRequestTimestamp);
        result = 31 * result + (this.clickCoordinatesEnabled ? 1 : 0);
        result = 31 * result + (this.headerBidding ? 1 : 0);
        return result;
    }

    public String getPrivacyUrl() {
        return this.templateSettings.get("VUNGLE_PRIVACY_URL");
    }

    public String[] getTpatUrls(@NonNull String event) {
        String unknownTpatEvent = "Unknown TPAT Event " + event;
        ArrayList<String> urls = this.dynamicEventsAndUrls.get(event);
        switch (this.adType) {
            case 0: {
                if (urls == null) {
                    VungleLogger.warn(Advertisement.class.getSimpleName() + "#getTpatUrls", unknownTpatEvent);
                    return EMPTY_STRING_ARRAY;
                }
                return urls.toArray(EMPTY_STRING_ARRAY);
            }
            case 1: {
                if (event.startsWith("checkpoint")) {
                    String[] ret = EMPTY_STRING_ARRAY;
                    int percent = Integer.parseInt(event.split("\\.")[1]);
                    Checkpoint cpoint = this.checkpoints.get(percent / 25);
                    if (cpoint != null) {
                        ret = cpoint.getUrls();
                    }
                    return ret;
                }
                if (urls == null) {
                    VungleLogger.warn(Advertisement.class.getSimpleName() + "#getTpatUrls", unknownTpatEvent);
                    return EMPTY_STRING_ARRAY;
                }
                return urls.toArray(EMPTY_STRING_ARRAY);
            }
        }
        throw new IllegalStateException("Unknown Advertisement Type!");
    }

    @NonNull
    public String getId() {
        if (this.identifier == null) {
            return "";
        }
        return this.identifier;
    }

    public String getAdToken() {
        return this.adToken;
    }

    public String getAppID() {
        return this.appID;
    }

    String getUrl() {
        return this.videoUrl;
    }

    public String getCampaign() {
        return this.campaign;
    }

    String getTemplateId() {
        return this.templateId;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public int getShowCloseDelay(boolean incentivized) {
        if (incentivized) {
            return this.showCloseIncentivized * 1000;
        }
        return this.showCloseDelay * 1000;
    }

    public boolean getOmEnabled() {
        return this.enableOm;
    }

    public boolean isClickCoordinatesTrackingEnabled() {
        return this.clickCoordinatesEnabled;
    }

    @Nullable
    public String getOmExtraVast() {
        return this.omExtraVast;
    }

    public long getExpireTime() {
        return this.expireTime * 1000L;
    }

    public Map<String, String> getMRAIDArgsInMap() {
        if (this.templateSettings == null) {
            throw new IllegalArgumentException("Advertisement does not have MRAID Arguments!");
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(this.templateSettings);
        for (Map.Entry<String, Pair<String, String>> entry : this.cacheableAssets.entrySet()) {
            resultMap.put(entry.getKey(), (String)entry.getValue().first);
        }
        if (!this.mraidFiles.isEmpty()) {
            resultMap.putAll(this.mraidFiles);
        }
        if (!this.incentivizedTextSettings.isEmpty()) {
            resultMap.putAll(this.incentivizedTextSettings);
        }
        if (!"true".equalsIgnoreCase((String)resultMap.get(START_MUTED))) {
            resultMap.put(START_MUTED, (this.getAdConfig().getSettings() & 1) != 0 ? "true" : "false");
        }
        return resultMap;
    }

    public JsonObject createMRAIDArgs() {
        Map<String, String> resultMap = this.getMRAIDArgsInMap();
        JsonObject ret = new JsonObject();
        for (Map.Entry<String, String> entry : resultMap.entrySet()) {
            ret.addProperty(entry.getKey(), entry.getValue());
        }
        VungleLogger.verbose(true, TAG, MRAID_ARGS, ret.toString());
        return ret;
    }

    @Nullable
    public String getCTAURL(boolean tpat) {
        switch (this.adType) {
            case 0: {
                return tpat ? this.ctaUrl : this.ctaDestinationUrl;
            }
            case 1: {
                return this.ctaUrl;
            }
        }
        throw new IllegalArgumentException("Unknown AdType " + this.adType);
    }

    @Nullable
    public String getDeeplinkUrl() {
        return this.deeplink;
    }

    public boolean hasPostroll() {
        return !TextUtils.isEmpty((CharSequence)this.postrollBundleUrl);
    }

    public Map<String, String> getDownloadableUrls() {
        HashMap<String, String> ret = new HashMap<String, String>();
        switch (this.adType) {
            case 0: {
                ret.put(KEY_VIDEO, this.videoUrl);
                if (TextUtils.isEmpty((CharSequence)this.postrollBundleUrl)) break;
                ret.put(KEY_POSTROLL, this.postrollBundleUrl);
                break;
            }
            case 1: {
                if (!this.isNativeTemplateType()) {
                    ret.put(KEY_TEMPLATE, this.templateUrl);
                }
                for (Map.Entry<String, Pair<String, String>> entry : this.cacheableAssets.entrySet()) {
                    String httpUrl = (String)entry.getValue().first;
                    if (!this.isValidUrl(httpUrl)) continue;
                    String fileName = URLUtil.guessFileName((String)httpUrl, null, null);
                    ret.put(fileName, httpUrl);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Advertisement created without adType!");
            }
        }
        return ret;
    }

    private boolean isValidUrl(String httpUrl) {
        return !TextUtils.isEmpty((CharSequence)httpUrl) && HttpUrl.parse((String)httpUrl) != null;
    }

    public void setMraidAssetDir(File dir) {
        for (Map.Entry<String, Pair<String, String>> entry : this.cacheableAssets.entrySet()) {
            String fileName;
            File file;
            String httpUrl = (String)entry.getValue().first;
            if (!this.isValidUrl(httpUrl) || !(file = new File(dir, fileName = URLUtil.guessFileName((String)httpUrl, null, null))).exists()) continue;
            this.mraidFiles.put(entry.getKey(), FILE_SCHEME + file.getPath());
        }
        this.assetsFullyDownloaded = true;
    }

    public void updateMRAIDTokensFromAssetDB(List<AdAsset> adAssets) {
        block0: for (Map.Entry<String, Pair<String, String>> entry : this.cacheableAssets.entrySet()) {
            String httpUrl = (String)entry.getValue().first;
            for (AdAsset adAsset : adAssets) {
                if (TextUtils.isEmpty((CharSequence)adAsset.serverPath) || !adAsset.serverPath.equals(httpUrl)) continue;
                File adAssetFile = new File(adAsset.localPath);
                if (!adAssetFile.exists()) continue block0;
                this.mraidFiles.put(entry.getKey(), FILE_SCHEME + adAssetFile.getPath());
                continue block0;
            }
        }
    }

    public void setIncentivizedText(@Nullable String title, @Nullable String body, @Nullable String keepWatching, @Nullable String close) {
        if (!TextUtils.isEmpty((CharSequence)title)) {
            this.incentivizedTextSettings.put(INCENTIVIZED_TITLE_TEXT, title);
        }
        if (!TextUtils.isEmpty((CharSequence)body)) {
            this.incentivizedTextSettings.put(INCENTIVIZED_BODY_TEXT, body);
        }
        if (!TextUtils.isEmpty((CharSequence)keepWatching)) {
            this.incentivizedTextSettings.put(INCENTIVIZED_CONTINUE_TEXT, keepWatching);
        }
        if (!TextUtils.isEmpty((CharSequence)close)) {
            this.incentivizedTextSettings.put(INCENTIVIZED_CLOSE_TEXT, close);
        }
    }

    public void setState(@State int state) {
        this.state = state;
    }

    @State
    public int getState() {
        return this.state;
    }

    public String getAdMarketId() {
        return this.adMarketId;
    }

    @NonNull
    public List<String> getWinNotifications() {
        return this.winNotifications;
    }

    void setWinNotifications(List<String> winNotifications) {
        if (winNotifications == null) {
            this.winNotifications.clear();
        } else {
            this.winNotifications = winNotifications;
        }
    }

    public String getBidToken() {
        return this.bidToken;
    }

    public boolean isHeaderBidding() {
        return this.headerBidding;
    }

    public void setHeaderBidding(boolean headerBidding) {
        this.headerBidding = headerBidding;
    }

    @NonNull
    public String toString() {
        return "Advertisement{adType=" + this.adType + ", identifier='" + this.identifier + '\'' + ", appID='" + this.appID + '\'' + ", expireTime=" + this.expireTime + ", checkpoints=" + this.gson.toJson(this.checkpoints, AdvertisementDBAdapter.CHECKPOINT_LIST_TYPE) + ", winNotifications='" + TextUtils.join((CharSequence)",", this.winNotifications) + ", dynamicEventsAndUrls=" + this.gson.toJson(this.dynamicEventsAndUrls, AdvertisementDBAdapter.DYNAMIC_EVENTS_AND_URLS_TYPE) + ", delay=" + this.delay + ", campaign='" + this.campaign + '\'' + ", showCloseDelay=" + this.showCloseDelay + ", showCloseIncentivized=" + this.showCloseIncentivized + ", countdown=" + this.countdown + ", videoUrl='" + this.videoUrl + '\'' + ", videoWidth=" + this.videoWidth + ", videoHeight=" + this.videoHeight + ", md5='" + this.md5 + '\'' + ", postrollBundleUrl='" + this.postrollBundleUrl + '\'' + ", ctaOverlayEnabled=" + this.ctaOverlayEnabled + ", ctaClickArea=" + this.ctaClickArea + ", ctaDestinationUrl='" + this.ctaDestinationUrl + '\'' + ", ctaUrl='" + this.ctaUrl + '\'' + ", adConfig=" + this.adConfig + ", retryCount=" + this.retryCount + ", adToken='" + this.adToken + '\'' + ", videoIdentifier='" + this.videoIdentifier + '\'' + ", templateUrl='" + this.templateUrl + '\'' + ", templateSettings=" + this.templateSettings + ", mraidFiles=" + this.mraidFiles + ", cacheableAssets=" + this.cacheableAssets + ", templateId='" + this.templateId + '\'' + ", templateType='" + this.templateType + '\'' + ", enableOm=" + this.enableOm + ", oMSDKExtraVast='" + this.omExtraVast + '\'' + ", requiresNonMarketInstall=" + this.requiresNonMarketInstall + ", adMarketId='" + this.adMarketId + '\'' + ", bidToken='" + this.bidToken + '\'' + ", state=" + this.state + '\'' + ", assetDownloadStartTime='" + this.assetDownloadStartTime + '\'' + ", assetDownloadDuration='" + this.assetDownloadDuration + '\'' + ", adRequestStartTime='" + this.adRequestStartTime + '\'' + ", requestTimestamp='" + this.serverRequestTimestamp + '\'' + ", headerBidding='" + this.headerBidding + '}';
    }

    public String getAdvertiserAppId() {
        String advertiserAppId = this.getAppID();
        String rawAppIdJson = this.getAppID();
        if (rawAppIdJson != null && rawAppIdJson.length() > 3) {
            try {
                JSONObject appIdJson = new JSONObject(rawAppIdJson.substring(3));
                advertiserAppId = appIdJson.isNull("app_id") ? null : appIdJson.optString("app_id", null);
            }
            catch (JSONException e2) {
                Log.e((String)TAG, (String)"JsonException : ", (Throwable)e2);
            }
        }
        return TextUtils.isEmpty((CharSequence)advertiserAppId) ? UNKNOWN : advertiserAppId;
    }

    public String getCampaignId() {
        String[] campaignArr;
        String campaignId = null;
        String campaign = this.getCampaign();
        if (!TextUtils.isEmpty((CharSequence)campaign) && (campaignArr = campaign.split("\\|")).length >= 1) {
            campaignId = campaignArr[0];
        }
        return TextUtils.isEmpty(campaignId) ? UNKNOWN : campaignId;
    }

    public String getCreativeId() {
        String[] campaignArr;
        String creativeId = null;
        String campaign = this.getCampaign();
        if (!TextUtils.isEmpty((CharSequence)campaign) && (campaignArr = campaign.split("\\|")).length >= 2) {
            creativeId = campaignArr[1];
        }
        return TextUtils.isEmpty(creativeId) ? UNKNOWN : creativeId;
    }

    public static class Checkpoint
    implements Comparable<Checkpoint> {
        @SerializedName(value="percentage")
        private byte percentage;
        @SerializedName(value="urls")
        private String[] urls;

        public Checkpoint(JsonObject json) throws IllegalArgumentException {
            if (!JsonUtil.hasNonNull((JsonElement)json, "checkpoint")) {
                throw new IllegalArgumentException("Checkpoint missing percentage!");
            }
            this.percentage = (byte)(json.get("checkpoint").getAsFloat() * 100.0f);
            if (JsonUtil.hasNonNull((JsonElement)json, "urls")) {
                JsonArray urlsArray = json.getAsJsonArray("urls");
                this.urls = new String[urlsArray.size()];
                for (int x = 0; x < urlsArray.size(); ++x) {
                    this.urls[x] = null == urlsArray.get(x) || "null".equalsIgnoreCase(urlsArray.get(x).toString()) ? "" : urlsArray.get(x).getAsString();
                }
            } else {
                throw new IllegalArgumentException("Checkpoint missing reporting URL!");
            }
        }

        public Checkpoint(JsonArray urlsArray, byte percentage) {
            if (urlsArray.size() == 0) {
                throw new IllegalArgumentException("Empty URLS!");
            }
            this.urls = new String[urlsArray.size()];
            for (int x = 0; x < urlsArray.size(); ++x) {
                this.urls[x] = urlsArray.get(x).getAsString();
            }
            this.percentage = percentage;
        }

        public String[] getUrls() {
            return (String[])this.urls.clone();
        }

        public byte getPercentage() {
            return this.percentage;
        }

        @Override
        public int compareTo(@NonNull Checkpoint o) {
            return Float.compare(this.percentage, o.percentage);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Checkpoint)) {
                return false;
            }
            Checkpoint wrap = (Checkpoint)obj;
            if (wrap.percentage != this.percentage) {
                return false;
            }
            if (wrap.urls.length != this.urls.length) {
                return false;
            }
            for (int x = 0; x < this.urls.length; ++x) {
                if (wrap.urls[x].equals(this.urls[x])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = this.percentage;
            result = 31 * result + this.urls.length;
            result = 31 * result + Arrays.hashCode(this.urls);
            return result;
        }
    }

    public static @interface State {
    }

    public static @interface CacheKey {
    }

    public static @interface Orientation {
    }

    public static @interface AdType {
    }
}

