/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model;

import android.content.ContentValues;
import android.util.Pair;
import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.vungle.warren.AdConfig;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.persistence.ContentValuesUtil;
import com.vungle.warren.persistence.DBAdapter;
import com.vungle.warren.persistence.IdColumns;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AdvertisementDBAdapter
implements DBAdapter<Advertisement> {
    private Gson gson = new GsonBuilder().create();
    private Type stringArrayType = new TypeToken<String[]>(){}.getType();
    private Type stringMapType = new TypeToken<Map<String, String>>(){}.getType();
    static final Type CHECKPOINT_LIST_TYPE = new TypeToken<List<Advertisement.Checkpoint>>(){}.getType();
    static final Type DYNAMIC_EVENTS_AND_URLS_TYPE = new TypeToken<Map<String, ArrayList<String>>>(){}.getType();
    private Type cacheableMapType = new TypeToken<Map<String, Pair<String, String>>>(){}.getType();
    private final Type STRING_LIST_TYPE = new TypeToken<List<String>>(){}.getType();
    public static final String CREATE_ADVERTISEMENT_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS advertisement(_id INTEGER PRIMARY KEY AUTOINCREMENT,  item_id TEXT UNIQUE, ad_config TEXT,ad_type INT, expire_time NUMERIC, delay NUMERIC, show_close_delay INT, show_close_incentivized INT, countdown INT, video_height INT, video_width INT, cta_overlay_enabled SHORT, cta_click_area NUMERIC, retry_count INT, requires_non_market_install SHORT, app_id TEXT, campaign TEXT, video_url TEXT, md5 TEXT, postroll_bundle_url TEXT, cta_destination_url TEXT, cta_url TEXT, ad_token TEXT, video_identifier TEXT, template_url TEXT, TEMPLATE_ID TEXT, TEMPLATE_TYPE TEXT, ad_market_id TEXT,bid_token TEXT,  checkpoints TEXT, template_settings TEXT, mraid_files TEXT, cacheable_assets TEXT, state INT, placement_id TEXT, tt_download NUMERIC,asset_download_timestamp NUMERIC,asset_download_duration NUMERIC,ad_request_start_time NUMERIC,column_enable_om_sdk SHORT,column_om_sdk_extra_vast TEXT,column_request_timestamp NUMERIC,column_click_coordinates_enabled SHORT,dynamic_events_and_urls TEXT, column_deep_link TEXT, column_notifications TEXT, column_assets_fully_downloaded SHORT, column_header_bidding SHORT)";

    @Override
    public ContentValues toContentValues(Advertisement item) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("item_id", item.identifier);
        contentValues.put("ad_type", Integer.valueOf(item.getAdType()));
        contentValues.put("expire_time", Long.valueOf(item.expireTime));
        contentValues.put("delay", Integer.valueOf(item.delay));
        contentValues.put("show_close_delay", Integer.valueOf(item.showCloseDelay));
        contentValues.put("show_close_incentivized", Integer.valueOf(item.showCloseIncentivized));
        contentValues.put("countdown", Integer.valueOf(item.countdown));
        contentValues.put("video_width", Integer.valueOf(item.videoWidth));
        contentValues.put("video_height", Integer.valueOf(item.videoHeight));
        contentValues.put("cta_overlay_enabled", Boolean.valueOf(item.ctaOverlayEnabled));
        contentValues.put("cta_click_area", Boolean.valueOf(item.ctaClickArea));
        contentValues.put("retry_count", Integer.valueOf(item.retryCount));
        contentValues.put("requires_non_market_install", Boolean.valueOf(item.requiresNonMarketInstall));
        contentValues.put("app_id", item.appID);
        contentValues.put("campaign", item.campaign);
        contentValues.put("video_url", item.videoUrl);
        contentValues.put("md5", item.md5);
        contentValues.put("postroll_bundle_url", item.postrollBundleUrl);
        contentValues.put("cta_destination_url", item.ctaDestinationUrl);
        contentValues.put("cta_url", item.ctaUrl);
        contentValues.put("ad_token", item.adToken);
        contentValues.put("video_identifier", item.videoIdentifier);
        contentValues.put("template_url", item.templateUrl);
        contentValues.put("TEMPLATE_ID", item.templateId);
        contentValues.put("TEMPLATE_TYPE", item.templateType);
        contentValues.put("ad_market_id", item.adMarketId);
        contentValues.put("bid_token", item.bidToken);
        contentValues.put("state", Integer.valueOf(item.state));
        contentValues.put("placement_id", item.placementId);
        contentValues.put("ad_config", this.gson.toJson((Object)item.adConfig));
        contentValues.put("checkpoints", this.gson.toJson(item.checkpoints, CHECKPOINT_LIST_TYPE));
        contentValues.put("dynamic_events_and_urls", this.gson.toJson(item.dynamicEventsAndUrls, DYNAMIC_EVENTS_AND_URLS_TYPE));
        contentValues.put("template_settings", this.gson.toJson(item.templateSettings, this.stringMapType));
        contentValues.put("mraid_files", this.gson.toJson(item.mraidFiles, this.stringMapType));
        contentValues.put("cacheable_assets", this.gson.toJson(item.cacheableAssets, this.cacheableMapType));
        contentValues.put("column_notifications", this.gson.toJson(item.getWinNotifications(), this.STRING_LIST_TYPE));
        contentValues.put("tt_download", Long.valueOf(item.ttDownload));
        contentValues.put("asset_download_timestamp", Long.valueOf(item.assetDownloadStartTime));
        contentValues.put("asset_download_duration", Long.valueOf(item.assetDownloadDuration));
        contentValues.put("ad_request_start_time", Long.valueOf(item.adRequestStartTime));
        contentValues.put("column_enable_om_sdk", Boolean.valueOf(item.enableOm));
        contentValues.put("column_om_sdk_extra_vast", item.omExtraVast);
        contentValues.put("column_request_timestamp", Long.valueOf(item.serverRequestTimestamp));
        contentValues.put("column_click_coordinates_enabled", Boolean.valueOf(item.clickCoordinatesEnabled));
        contentValues.put("column_assets_fully_downloaded", Boolean.valueOf(item.assetsFullyDownloaded));
        contentValues.put("column_deep_link", item.deeplink);
        contentValues.put("column_header_bidding", Boolean.valueOf(item.headerBidding));
        return contentValues;
    }

    @Override
    @NonNull
    public Advertisement fromContentValues(ContentValues values) {
        Advertisement item = new Advertisement();
        item.identifier = values.getAsString("item_id");
        item.adType = values.getAsInteger("ad_type");
        item.expireTime = values.getAsLong("expire_time");
        item.delay = values.getAsInteger("delay");
        item.showCloseDelay = values.getAsInteger("show_close_delay");
        item.showCloseIncentivized = values.getAsInteger("show_close_incentivized");
        item.countdown = values.getAsInteger("countdown");
        item.videoWidth = values.getAsInteger("video_width");
        item.videoHeight = values.getAsInteger("video_height");
        item.retryCount = values.getAsInteger("retry_count");
        item.requiresNonMarketInstall = ContentValuesUtil.getBoolean(values, "requires_non_market_install");
        item.appID = values.getAsString("app_id");
        item.campaign = values.getAsString("campaign");
        item.videoUrl = values.getAsString("video_url");
        item.md5 = values.getAsString("md5");
        item.postrollBundleUrl = values.getAsString("postroll_bundle_url");
        item.ctaDestinationUrl = values.getAsString("cta_destination_url");
        item.ctaUrl = values.getAsString("cta_url");
        item.adToken = values.getAsString("ad_token");
        item.videoIdentifier = values.getAsString("video_identifier");
        item.templateUrl = values.getAsString("template_url");
        item.templateId = values.getAsString("TEMPLATE_ID");
        item.templateType = values.getAsString("TEMPLATE_TYPE");
        item.adMarketId = values.getAsString("ad_market_id");
        item.bidToken = values.getAsString("bid_token");
        item.state = values.getAsInteger("state");
        item.placementId = values.getAsString("placement_id");
        item.ctaOverlayEnabled = ContentValuesUtil.getBoolean(values, "cta_overlay_enabled");
        item.ctaClickArea = ContentValuesUtil.getBoolean(values, "cta_click_area");
        item.adConfig = (AdConfig)this.gson.fromJson(values.getAsString("ad_config"), AdConfig.class);
        item.checkpoints = (List)this.gson.fromJson(values.getAsString("checkpoints"), CHECKPOINT_LIST_TYPE);
        item.dynamicEventsAndUrls = (Map)this.gson.fromJson(values.getAsString("dynamic_events_and_urls"), DYNAMIC_EVENTS_AND_URLS_TYPE);
        item.templateSettings = (Map)this.gson.fromJson(values.getAsString("template_settings"), this.stringMapType);
        item.mraidFiles = (Map)this.gson.fromJson(values.getAsString("mraid_files"), this.stringMapType);
        item.cacheableAssets = (Map)this.gson.fromJson(values.getAsString("cacheable_assets"), this.cacheableMapType);
        item.ttDownload = values.getAsLong("tt_download");
        item.assetDownloadStartTime = values.getAsLong("asset_download_timestamp");
        item.assetDownloadDuration = values.getAsLong("asset_download_duration");
        item.adRequestStartTime = values.getAsLong("ad_request_start_time");
        item.enableOm = ContentValuesUtil.getBoolean(values, "column_enable_om_sdk");
        List notificationUrls = (List)this.gson.fromJson(values.getAsString("column_notifications"), this.STRING_LIST_TYPE);
        item.setWinNotifications(notificationUrls);
        item.omExtraVast = values.getAsString("column_om_sdk_extra_vast");
        item.serverRequestTimestamp = values.getAsLong("column_request_timestamp");
        item.clickCoordinatesEnabled = values.getAsBoolean("column_click_coordinates_enabled");
        item.assetsFullyDownloaded = ContentValuesUtil.getBoolean(values, "column_assets_fully_downloaded");
        item.deeplink = values.getAsString("column_deep_link");
        item.headerBidding = values.getAsBoolean("column_header_bidding");
        return item;
    }

    @Override
    public String tableName() {
        return "advertisement";
    }

    public static interface AdvertisementColumns
    extends IdColumns {
        public static final String TABLE_NAME = "advertisement";
        public static final String COLUMN_AD_TYPE = "ad_type";
        public static final String COLUMN_APP_ID = "app_id";
        public static final String COLUMN_EXPIRE_TIME = "expire_time";
        public static final String COLUMN_CHECKPOINTS = "checkpoints";
        public static final String COLUMN_DYNAMIC_EVENTS_AND_URLS = "dynamic_events_and_urls";
        public static final String COLUMN_DELAY = "delay";
        public static final String COLUMN_CAMPAIGN = "campaign";
        public static final String COLUMN_SHOW_CLOSE_DELAY = "show_close_delay";
        public static final String COLUMN_SHOW_CLOSE_INCENTIVISED = "show_close_incentivized";
        public static final String COLUMN_COUNTDOWN = "countdown";
        public static final String COLUMN_VIDEO_URL = "video_url";
        public static final String COLUMN_VIDEO_WIDTH = "video_width";
        public static final String COLUMN_VIDEO_HEIGHT = "video_height";
        public static final String COLUMN_MD5 = "md5";
        public static final String COLUMN_POSTROLL_BUNDLE_URL = "postroll_bundle_url";
        public static final String COLUMN_CTA_OVERLAY_ENABLED = "cta_overlay_enabled";
        public static final String COLUMN_CTA_CLICK_AREA = "cta_click_area";
        public static final String COLUMN_CTA_DESTINATION_URL = "cta_destination_url";
        public static final String COLUMN_CTA_URL = "cta_url";
        public static final String COLUMN_AD_CONFIG = "ad_config";
        public static final String COLUMN_RETRY_COUNT = "retry_count";
        public static final String COLUMN_AD_TOKEN = "ad_token";
        public static final String COLUMN_VIDEO_IDENTIFIER = "video_identifier";
        public static final String COLUMN_TEMPLATE_URL = "template_url";
        public static final String COLUMN_TEMPLATE_SETTINGS = "template_settings";
        public static final String COLUMN_MRAID_FILES = "mraid_files";
        public static final String COLUMN_TEMPLATE_ID = "TEMPLATE_ID";
        public static final String COLUMN_TEMPLATE_TYPE = "TEMPLATE_TYPE";
        public static final String COLUMN_REQUIRES_NON_MARKET_INSTALL = "requires_non_market_install";
        public static final String COLUMN_AD_MARKET_ID = "ad_market_id";
        public static final String COLUMN_BID_TOKEN = "bid_token";
        public static final String COLUMN_PLACEMENT_ID = "placement_id";
        public static final String COLUMN_STATE = "state";
        public static final String COLUMN_CACHEABLE_ASSETS = "cacheable_assets";
        public static final String COLUMN_TT_DOWNLOAD = "tt_download";
        public static final String COLUMN_ASSET_DOWNLOAD_TIMESTAMP = "asset_download_timestamp";
        public static final String COLUMN_ASSET_DOWNLOAD_DURATION = "asset_download_duration";
        public static final String COLUMN_AD_REQUEST_START_TIMESTAMP = "ad_request_start_time";
        public static final String COLUMN_ENABLE_OM_SDK = "column_enable_om_sdk";
        public static final String COLUMN_OM_SDK_EXTRA_VAST = "column_om_sdk_extra_vast";
        public static final String COLUMN_SERVER_REQUEST_TIMESTAMP = "column_request_timestamp";
        public static final String COLUMN_CLICK_COORDINATES_ENABLED = "column_click_coordinates_enabled";
        public static final String COLUMN_ASSETS_FULLY_DOWNLOADED = "column_assets_fully_downloaded";
        public static final String COLUMN_DEEP_LINK = "column_deep_link";
        public static final String COLUMN_NOTIFICATIONS = "column_notifications";
        public static final String COLUMN_HEADER_BIDDING = "column_header_bidding";
    }
}

