/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model;

import android.content.ContentValues;
import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.persistence.DBAdapter;
import com.vungle.warren.persistence.IdColumns;
import java.lang.reflect.Type;
import java.util.Map;

public class CookieDBAdapter
implements DBAdapter<Cookie> {
    private Gson gson = new GsonBuilder().create();
    Type boolType = new TypeToken<Map<String, Boolean>>(){}.getType();
    Type intType = new TypeToken<Map<String, Integer>>(){}.getType();
    Type longType = new TypeToken<Map<String, Long>>(){}.getType();
    Type stringType = new TypeToken<Map<String, String>>(){}.getType();
    public static final String CREATE_COOKIE_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS cookie(_id INTEGER PRIMARY KEY AUTOINCREMENT, item_id TEXT UNIQUE, bools TEXT, ints TEXT, longs TEXT, strings TEXT )";

    @Override
    public ContentValues toContentValues(Cookie item) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("item_id", item.identifier);
        contentValues.put("bools", this.gson.toJson(item.booleans, this.boolType));
        contentValues.put("ints", this.gson.toJson(item.integers, this.intType));
        contentValues.put("longs", this.gson.toJson(item.longs, this.longType));
        contentValues.put("strings", this.gson.toJson(item.strings, this.stringType));
        return contentValues;
    }

    @Override
    @NonNull
    public Cookie fromContentValues(ContentValues values) {
        Cookie cookie = new Cookie(values.getAsString("item_id"));
        cookie.booleans = (Map)this.gson.fromJson(values.getAsString("bools"), this.boolType);
        cookie.longs = (Map)this.gson.fromJson(values.getAsString("longs"), this.longType);
        cookie.integers = (Map)this.gson.fromJson(values.getAsString("ints"), this.intType);
        cookie.strings = (Map)this.gson.fromJson(values.getAsString("strings"), this.stringType);
        return cookie;
    }

    @Override
    public String tableName() {
        return "cookie";
    }

    public static interface CookieColumns
    extends IdColumns {
        public static final String TABLE_NAME = "cookie";
        public static final String COLUMN_INTS = "ints";
        public static final String COLUMN_STRINGS = "strings";
        public static final String COLUMN_LONGS = "longs";
        public static final String COLUMN_BOOLS = "bools";
    }
}

