/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model;

import android.content.ContentValues;
import androidx.annotation.NonNull;
import com.vungle.warren.AdConfig;
import com.vungle.warren.model.Placement;
import com.vungle.warren.persistence.ContentValuesUtil;
import com.vungle.warren.persistence.DBAdapter;
import com.vungle.warren.persistence.IdColumns;

public class PlacementDBAdapter
implements DBAdapter<Placement> {
    public static final String CREATE_PLACEMENT_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS placement(_id INTEGER PRIMARY KEY AUTOINCREMENT, item_id TEXT UNIQUE, incentivized SHORT, auto_cached SHORT, is_valid SHORT, wakeup_time NUMERIC, header_bidding SHORT, refresh_duration NUMERIC, supported_template_types NUMERIC, ad_size TEXT, autocache_priority NUMERIC, max_hb_cache NUMERIC, recommended_ad_size TEXT)";

    @Override
    public ContentValues toContentValues(Placement item) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("item_id", item.identifier);
        contentValues.put("incentivized", Boolean.valueOf(item.incentivized));
        contentValues.put("header_bidding", Boolean.valueOf(item.headerBidding));
        contentValues.put("auto_cached", Boolean.valueOf(item.autoCached));
        contentValues.put("wakeup_time", Long.valueOf(item.wakeupTime));
        contentValues.put("is_valid", Boolean.valueOf(item.isValid));
        contentValues.put("refresh_duration", Integer.valueOf(item.adRefreshDuration));
        contentValues.put("supported_template_types", Integer.valueOf(item.placementAdType));
        contentValues.put("ad_size", item.getAdSize().getName());
        contentValues.put("autocache_priority", Integer.valueOf(item.autoCachePriority));
        contentValues.put("max_hb_cache", Integer.valueOf(item.maxHbCache));
        contentValues.put("recommended_ad_size", item.getRecommendedAdSize().getName());
        return contentValues;
    }

    @Override
    @NonNull
    public Placement fromContentValues(ContentValues values) {
        Placement placement = new Placement();
        placement.identifier = values.getAsString("item_id");
        placement.wakeupTime = values.getAsLong("wakeup_time");
        placement.incentivized = ContentValuesUtil.getBoolean(values, "incentivized");
        placement.headerBidding = ContentValuesUtil.getBoolean(values, "header_bidding");
        placement.autoCached = ContentValuesUtil.getBoolean(values, "auto_cached");
        placement.isValid = ContentValuesUtil.getBoolean(values, "is_valid");
        placement.adRefreshDuration = values.getAsInteger("refresh_duration");
        placement.placementAdType = values.getAsInteger("supported_template_types");
        placement.adSize = AdConfig.AdSize.fromName(values.getAsString("ad_size"));
        placement.autoCachePriority = values.getAsInteger("autocache_priority");
        placement.maxHbCache = values.getAsInteger("max_hb_cache");
        placement.recommendedAdSize = AdConfig.AdSize.fromName(values.getAsString("recommended_ad_size"));
        return placement;
    }

    @Override
    public String tableName() {
        return "placement";
    }

    public static interface PlacementColumns
    extends IdColumns {
        public static final String TABLE_NAME = "placement";
        public static final String COLUMN_INCENTIVIZED = "incentivized";
        public static final String COLUMN_HEADERBIDDING = "header_bidding";
        public static final String COLUMN_AUTOCACHED = "auto_cached";
        public static final String COLUMN_WAKEUP_TIME = "wakeup_time";
        public static final String COLUMN_IS_VALID = "is_valid";
        public static final String COLUMN_REFRESH_DURATION = "refresh_duration";
        public static final String COLUMN_SUPPORTED_TEMPLATE_TYPES = "supported_template_types";
        public static final String COLUMN_AD_SIZE = "ad_size";
        public static final String COLUMN_AUTOCACHE_PRIORITY = "autocache_priority";
        public static final String COLUMN_MAX_HB_CACHE = "max_hb_cache";
        public static final String COLUMN_RECOMMENDED_AD_SIZE = "recommended_ad_size";
    }
}

