/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vungle.warren.session.SessionAttribute;
import com.vungle.warren.session.SessionEvent;
import com.vungle.warren.utility.HashUtility;

public class SessionData {
    public SessionEvent sessionEvent;
    private static final Gson GSON = new Gson();
    private int sendAttempts;
    private JsonObject sessionEventJsonObject;

    protected SessionData(String jsonString, int sendAttempts) {
        this.sessionEventJsonObject = (JsonObject)GSON.fromJson(jsonString, JsonObject.class);
        this.sendAttempts = sendAttempts;
    }

    private SessionData(SessionEvent sessionEvent, JsonObject attributes) {
        this.sessionEvent = sessionEvent;
        this.sessionEventJsonObject = attributes;
        attributes.addProperty(SessionAttribute.TIMESTAMP.toString(), (Number)System.currentTimeMillis());
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null || !(obj instanceof SessionData)) {
            return false;
        }
        SessionData sessionData = (SessionData)obj;
        if (!this.sessionEvent.equals((Object)sessionData.sessionEvent)) {
            return false;
        }
        return this.sessionEventJsonObject.equals((Object)sessionData.sessionEventJsonObject);
    }

    public void removeEvent(SessionAttribute attribute) {
        this.sessionEventJsonObject.remove(attribute.toString());
    }

    public void addAttribute(SessionAttribute attribute, String data) {
        this.sessionEventJsonObject.addProperty(attribute.toString(), data);
    }

    public String getAsJsonString() {
        String gsonString = GSON.toJson((JsonElement)this.sessionEventJsonObject);
        return gsonString;
    }

    public String getStringAttribute(SessionAttribute attribute) {
        JsonElement element = this.sessionEventJsonObject.get(attribute.toString());
        if (element != null) {
            return element.getAsString();
        }
        return null;
    }

    @NonNull
    public String getId() {
        String id2 = HashUtility.sha256(this.getAsJsonString());
        if (id2 == null) {
            id2 = String.valueOf(this.getAsJsonString().hashCode());
        }
        return id2;
    }

    public int getSendAttempts() {
        return this.sendAttempts;
    }

    public int incrementSendAttempt() {
        return this.sendAttempts++;
    }

    public static class Builder {
        JsonObject jsonObject = new JsonObject();
        SessionEvent event;

        public SessionData build() {
            if (this.event == null) {
                throw new IllegalArgumentException("SessionData must have event");
            }
            return new SessionData(this.event, this.jsonObject);
        }

        public Builder setEvent(SessionEvent event) {
            this.event = event;
            this.jsonObject.addProperty("event", event.toString());
            return this;
        }

        public Builder addData(SessionAttribute attribute, String value) {
            this.jsonObject.addProperty(attribute.toString(), value);
            return this;
        }

        public Builder addData(SessionAttribute attribute, int value) {
            this.jsonObject.addProperty(attribute.toString(), (Number)value);
            return this;
        }

        public Builder addData(SessionAttribute attribute, double value) {
            this.jsonObject.addProperty(attribute.toString(), (Number)value);
            return this;
        }

        public Builder addData(SessionAttribute attribute, boolean value) {
            this.jsonObject.addProperty(attribute.toString(), Boolean.valueOf(value));
            return this;
        }
    }
}

