/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model.admarkup;

import androidx.annotation.Nullable;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.vungle.warren.model.JsonUtil;
import com.vungle.warren.model.admarkup.AdMarkup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public final class AdMarkupV1
extends AdMarkup
implements Serializable {
    private final String eventId;

    private AdMarkupV1(String eventId, String[] impressions) {
        this.eventId = eventId;
        this.impressions = impressions;
    }

    @Override
    public String getEventId() {
        return this.eventId;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public String toString() {
        return "    AdMarkup {eventId='" + this.eventId + '\'' + ", impression=" + Arrays.toString(this.impressions) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdMarkupV1 adMarkup = (AdMarkupV1)o;
        return this.eventId != null ? this.eventId.equals(adMarkup.eventId) : adMarkup.eventId == null;
    }

    public int hashCode() {
        return this.eventId != null ? this.eventId.hashCode() : 0;
    }

    @Nullable
    public static AdMarkupV1 fromString(String string) {
        JsonArray jsonArray;
        JsonObject jsonObject;
        if (string == null) {
            return null;
        }
        try {
            jsonObject = (JsonObject)new GsonBuilder().create().fromJson(string, JsonObject.class);
        }
        catch (JsonSyntaxException ignored) {
            return null;
        }
        if (jsonObject == null) {
            return null;
        }
        ArrayList<String> impression = null;
        if (JsonUtil.hasNonNull((JsonElement)jsonObject, "impression") && (jsonArray = jsonObject.getAsJsonArray("impression")).isJsonArray()) {
            impression = new ArrayList<String>();
            for (JsonElement element : jsonArray.getAsJsonArray()) {
                impression.add(element.getAsString());
            }
        }
        return new AdMarkupV1(JsonUtil.getAsString((JsonElement)jsonObject, "event_id", null), impression != null ? impression.toArray(new String[0]) : null);
    }
}

