/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.model.admarkup;

import androidx.annotation.NonNull;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.admarkup.AdMarkup;
import java.io.Serializable;

public class AdMarkupV2
extends AdMarkup
implements Serializable {
    private final String advertisementJsonObject;
    private final String placementId;

    public AdMarkupV2(JsonObject json, String[] impressions) {
        this.impressions = impressions;
        JsonArray jsonArray = json.getAsJsonArray("ads");
        JsonElement e2 = jsonArray.get(0);
        this.placementId = e2.getAsJsonObject().get("placement_reference_id").getAsString();
        this.advertisementJsonObject = e2.getAsJsonObject().toString();
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public String getEventId() {
        return this.getAdvertisement().getId();
    }

    @NonNull
    public Advertisement getAdvertisement() {
        JsonObject jsonObject = JsonParser.parseString((String)this.advertisementJsonObject).getAsJsonObject();
        Advertisement ad = new Advertisement(jsonObject);
        ad.setPlacementId(this.placementId);
        ad.setHeaderBidding(true);
        return ad;
    }
}

