/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.persistence;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.utility.CollectionsConcurrencyUtil;
import com.vungle.warren.utility.FileUtility;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

public class FilePreferences {
    @VisibleForTesting
    static final String FILENAME = "vungle_settings";
    @VisibleForTesting
    static final String OLD_SHARED_PREFS = "com.vungle.sdk";
    private final File file;
    private final Executor ioExecutor;
    private final ConcurrentHashMap<String, Object> values = new ConcurrentHashMap();
    private final SharedPreferences preferences;
    private final HashSet<String> sharedPrefValues = new HashSet();

    @SuppressLint(value={"NewApi"})
    public FilePreferences(Context context, Executor ioExecutor) {
        Object saved;
        this.ioExecutor = ioExecutor;
        File dir = context.getNoBackupFilesDir();
        this.file = new File(dir, FILENAME);
        File old = new File(context.getFilesDir(), FILENAME);
        if (old.exists() && !old.renameTo(this.file)) {
            VungleLogger.error("FilePreferences", "Can't move old FilePreferences");
        }
        if ((saved = FileUtility.readSerializable(this.file)) instanceof HashMap) {
            this.values.putAll((HashMap)saved);
        }
        this.preferences = context.getSharedPreferences(OLD_SHARED_PREFS, 0);
        this.migrateFromSharedPrefs();
    }

    public void apply() {
        final HashMap<String, Object> serializable = new HashMap<String, Object>(this.values);
        this.ioExecutor.execute(new Runnable(){

            @Override
            public void run() {
                FileUtility.writeSerializable(FilePreferences.this.file, serializable);
            }
        });
    }

    public FilePreferences addSharedPrefsKey(String ... keys) {
        this.sharedPrefValues.addAll(Arrays.asList(keys));
        return this;
    }

    private void migrateFromSharedPrefs() {
        for (Map.Entry entry : this.preferences.getAll().entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Boolean) {
                this.put((String)entry.getKey(), (Boolean)value);
                continue;
            }
            if (value instanceof String) {
                this.put((String)entry.getKey(), (String)value);
                continue;
            }
            if (value instanceof Integer) {
                this.put((String)entry.getKey(), (Integer)value);
                continue;
            }
            if (!(value instanceof HashSet)) continue;
            this.put((String)entry.getKey(), (HashSet)value);
        }
        this.preferences.edit().clear().apply();
        this.apply();
    }

    public FilePreferences put(@NonNull String key, boolean value) {
        this.values.put(key, value);
        if (this.sharedPrefValues.contains(key)) {
            this.preferences.edit().putBoolean(key, value).apply();
        }
        return this;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object value = this.values.get(key);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public FilePreferences put(@NonNull String key, @NonNull String value) {
        this.values.put(key, value);
        if (this.sharedPrefValues.contains(key)) {
            this.preferences.edit().putString(key, value).apply();
        }
        return this;
    }

    public String getString(String key, String defaultValue) {
        Object value = this.values.get(key);
        return value instanceof String ? (String)value : defaultValue;
    }

    public FilePreferences put(@NonNull String key, int value) {
        this.values.put(key, value);
        if (this.sharedPrefValues.contains(key)) {
            this.preferences.edit().putInt(key, value).apply();
        }
        return this;
    }

    public int getInt(String key, int defaultValue) {
        Object value = this.values.get(key);
        return value instanceof Integer ? (Integer)value : defaultValue;
    }

    public FilePreferences put(@NonNull String key, @NonNull HashSet<String> value) {
        this.values.put(key, CollectionsConcurrencyUtil.getNewHashSet(value));
        if (this.sharedPrefValues.contains(key)) {
            this.preferences.edit().putStringSet(key, CollectionsConcurrencyUtil.getNewHashSet(value)).apply();
        }
        return this;
    }

    public HashSet<String> getStringSet(String key, HashSet<String> defaultValue) {
        Object value = this.values.get(key);
        return value instanceof HashSet ? CollectionsConcurrencyUtil.getNewHashSet((HashSet)value) : defaultValue;
    }
}

