/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.tasks;

import android.os.Bundle;
import androidx.annotation.NonNull;
import com.vungle.warren.AdLoader;
import com.vungle.warren.AdRequest;
import com.vungle.warren.VungleStaticApi;
import com.vungle.warren.tasks.Job;
import com.vungle.warren.tasks.JobInfo;
import com.vungle.warren.tasks.JobRunner;
import java.io.Serializable;
import java.util.Collection;

public class DownloadJob
implements Job {
    static final String TAG = DownloadJob.class.getCanonicalName();
    private static final String REQUEST_KEY_EXTRA = "request";
    private final AdLoader adLoader;
    private final VungleStaticApi vungleApi;

    public DownloadJob(@NonNull AdLoader adLoader, @NonNull VungleStaticApi vungleApi) {
        this.adLoader = adLoader;
        this.vungleApi = vungleApi;
    }

    public static JobInfo makeJobInfo(@NonNull AdRequest request) {
        Bundle extras = new Bundle();
        extras.putSerializable(REQUEST_KEY_EXTRA, (Serializable)request);
        String tag = TAG + " " + request;
        return new JobInfo(tag).setUpdateCurrent(true).setExtras(extras).setPriority(4);
    }

    @Override
    public int onRunJob(Bundle params, JobRunner jobRunner) {
        AdRequest request = (AdRequest)params.getSerializable(REQUEST_KEY_EXTRA);
        Collection<String> validPlacements = this.vungleApi.getValidPlacements();
        if (request == null || !validPlacements.contains(request.getPlacementId())) {
            return 1;
        }
        this.adLoader.loadPendingInternal(request);
        return 0;
    }
}

