/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.tasks;

import android.os.Bundle;
import androidx.annotation.NonNull;
import com.vungle.warren.tasks.Job;
import com.vungle.warren.tasks.JobInfo;
import com.vungle.warren.tasks.JobRunner;

public class ReconfigJob
implements Job {
    public static final String TAG = ReconfigJob.class.getCanonicalName();
    private ReconfigCall reconfigCall;

    public ReconfigJob(@NonNull ReconfigCall reconfigCall) {
        this.reconfigCall = reconfigCall;
    }

    public static JobInfo makeJobInfo(String appID) {
        Bundle extras = new Bundle();
        extras.putString("appId", appID);
        return new JobInfo(TAG).setExtras(extras).setUpdateCurrent(true).setPriority(4);
    }

    @Override
    public int onRunJob(Bundle params, JobRunner jobRunner) {
        String appID = params.getString("appId", null);
        if (appID == null) {
            return 1;
        }
        this.reconfigCall.reConfigVungle();
        return 0;
    }

    public static interface ReconfigCall {
        public void reConfigVungle();
    }
}

