/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.tasks;

import android.text.TextUtils;
import com.vungle.warren.AdLoader;
import com.vungle.warren.VungleApiClient;
import com.vungle.warren.VungleStaticApi;
import com.vungle.warren.analytics.AdAnalytics;
import com.vungle.warren.log.LogManager;
import com.vungle.warren.persistence.Designer;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.tasks.AnalyticsJob;
import com.vungle.warren.tasks.CacheBustJob;
import com.vungle.warren.tasks.CleanupJob;
import com.vungle.warren.tasks.DownloadJob;
import com.vungle.warren.tasks.Job;
import com.vungle.warren.tasks.JobCreator;
import com.vungle.warren.tasks.ReconfigJob;
import com.vungle.warren.tasks.SendLogsJob;
import com.vungle.warren.tasks.SendReportsJob;
import com.vungle.warren.tasks.UnknownTagException;

public class VungleJobCreator
implements JobCreator {
    private final Repository repository;
    private final Designer designer;
    private final ReconfigJob.ReconfigCall reconfigCall;
    private final VungleApiClient apiClient;
    private final AdAnalytics adAnalytics;
    private final AdLoader adLoader;
    private final VungleStaticApi vungleApi;
    private final LogManager logManager;

    public VungleJobCreator(Repository repository, Designer designer, VungleApiClient apiClient, AdAnalytics adAnalytics, ReconfigJob.ReconfigCall reconfigCall, AdLoader adLoader, VungleStaticApi vungleApi, LogManager logManager) {
        this.repository = repository;
        this.designer = designer;
        this.reconfigCall = reconfigCall;
        this.apiClient = apiClient;
        this.adAnalytics = adAnalytics;
        this.adLoader = adLoader;
        this.vungleApi = vungleApi;
        this.logManager = logManager;
    }

    @Override
    public Job create(String tag) throws UnknownTagException {
        if (TextUtils.isEmpty((CharSequence)tag)) {
            throw new UnknownTagException("Job tag is null");
        }
        if (tag.startsWith(ReconfigJob.TAG)) {
            return new ReconfigJob(this.reconfigCall);
        }
        if (tag.startsWith(DownloadJob.TAG)) {
            return new DownloadJob(this.adLoader, this.vungleApi);
        }
        if (tag.startsWith(SendReportsJob.TAG)) {
            return new SendReportsJob(this.repository, this.apiClient);
        }
        if (tag.startsWith(CleanupJob.TAG)) {
            return new CleanupJob(this.designer, this.repository, this.adLoader);
        }
        if (tag.startsWith(AnalyticsJob.TAG)) {
            return new AnalyticsJob(this.adAnalytics);
        }
        if (tag.startsWith(SendLogsJob.TAG)) {
            return new SendLogsJob(this.logManager);
        }
        if (tag.startsWith(CacheBustJob.TAG)) {
            return new CacheBustJob(this.apiClient, this.repository, this.adLoader);
        }
        throw new UnknownTagException("Unknown Job Type " + tag);
    }
}

