/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.tasks.runnable;

import android.os.Bundle;
import android.os.Process;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.tasks.Job;
import com.vungle.warren.tasks.JobCreator;
import com.vungle.warren.tasks.JobInfo;
import com.vungle.warren.tasks.JobRunner;
import com.vungle.warren.tasks.UnknownTagException;
import com.vungle.warren.tasks.utility.ThreadPriorityHelper;
import com.vungle.warren.utility.PriorityRunnable;

public class JobRunnable
extends PriorityRunnable {
    private static final String TAG = JobRunnable.class.getSimpleName();
    private final JobInfo jobinfo;
    private final JobCreator creator;
    private final JobRunner jobRunner;
    private final ThreadPriorityHelper threadPriorityHelper;

    public JobRunnable(@NonNull JobInfo jobInfo, @NonNull JobCreator jobCreator, @NonNull JobRunner jobRunner, @Nullable ThreadPriorityHelper threadPriorityHelper) {
        this.jobinfo = jobInfo;
        this.creator = jobCreator;
        this.jobRunner = jobRunner;
        this.threadPriorityHelper = threadPriorityHelper;
    }

    @Override
    public Integer getPriority() {
        return this.jobinfo.getPriority();
    }

    @Override
    public void run() {
        if (this.threadPriorityHelper != null) {
            try {
                int targetPriority = this.threadPriorityHelper.makeAndroidThreadPriority(this.jobinfo);
                Process.setThreadPriority((int)targetPriority);
                Log.d((String)TAG, (String)("Setting process thread prio = " + targetPriority + " for " + this.jobinfo.getJobTag()));
            }
            catch (Throwable throwable) {
                Log.e((String)TAG, (String)"Error on setting process thread priority");
            }
        }
        try {
            long nextReschedule;
            String jobTag = this.jobinfo.getJobTag();
            Bundle params = this.jobinfo.getExtras();
            Log.d((String)TAG, (String)("Start job " + jobTag + "Thread " + Thread.currentThread().getName()));
            Job job = this.creator.create(jobTag);
            int result = job.onRunJob(params, this.jobRunner);
            Log.d((String)TAG, (String)("On job finished " + jobTag + " with result " + result));
            if (result == 2 && (nextReschedule = this.jobinfo.makeNextRescedule()) > 0L) {
                this.jobinfo.setDelay(nextReschedule);
                this.jobRunner.execute(this.jobinfo);
                Log.d((String)TAG, (String)("Rescheduling " + jobTag + " in " + nextReschedule));
            }
        }
        catch (UnknownTagException e2) {
            Log.e((String)TAG, (String)("Cannot create job" + e2.getLocalizedMessage()));
        }
        catch (Throwable th) {
            Log.e((String)TAG, (String)"Can't start job", (Throwable)th);
        }
    }
}

