/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.ui;

import androidx.annotation.NonNull;
import com.vungle.warren.model.Report;
import com.vungle.warren.persistence.Repository;
import java.util.concurrent.atomic.AtomicBoolean;

public class DurationRecorder {
    private final Report report;
    private final Repository repository;
    private final Repository.SaveCallback repoCallback;
    private AtomicBoolean paused = new AtomicBoolean(true);
    private long startMillis;

    public DurationRecorder(@NonNull Report report, @NonNull Repository repository, @NonNull Repository.SaveCallback repoCallback) {
        this.report = report;
        this.repository = repository;
        this.repoCallback = repoCallback;
    }

    public void start() {
        if (this.paused.getAndSet(false)) {
            this.startMillis = System.currentTimeMillis() - this.report.getAdDuration();
        }
    }

    public void stop() {
        if (!this.paused.getAndSet(true)) {
            this.save();
        }
    }

    public void update() {
        if (!this.paused.get()) {
            this.save();
        }
    }

    private void save() {
        this.report.setAdDuration(System.currentTimeMillis() - this.startMillis);
        this.repository.save(this.report, this.repoCallback);
    }
}

