/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.ui.presenter;

import android.content.ActivityNotFoundException;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebView;
import android.webkit.WebViewRenderProcess;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.vungle.warren.SessionTracker;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.analytics.AdAnalytics;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.model.Placement;
import com.vungle.warren.model.Report;
import com.vungle.warren.model.SessionData;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.session.SessionAttribute;
import com.vungle.warren.session.SessionEvent;
import com.vungle.warren.ui.DurationRecorder;
import com.vungle.warren.ui.PresenterAdOpenCallback;
import com.vungle.warren.ui.PresenterAppLeftCallback;
import com.vungle.warren.ui.contract.AdContract;
import com.vungle.warren.ui.contract.LocalAdContract;
import com.vungle.warren.ui.state.OptionsState;
import com.vungle.warren.ui.view.WebViewAPI;
import com.vungle.warren.utility.AsyncFileUtils;
import com.vungle.warren.utility.Scheduler;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class LocalAdPresenter
implements LocalAdContract.LocalPresenter,
WebViewAPI.WebClientErrorHandler {
    static final String EXTRA_INCENTIVIZED_SENT = "incentivized_sent";
    static final String TAG = "LocalAdPresenter";
    static final String EXTRA_REPORT = "saved_report";
    static final String EXTRA_IN_POST = "in_post_roll";
    static final String EXTRA_IS_MUTED = "is_muted_mode";
    static final String EXTRA_VIDEO_POSITION = "videoPosition";
    static final String HTTPS_VUNGLE_COM_PRIVACY = "https://vungle.com/privacy/";
    public static final int INCENTIVIZED_TRESHOLD = 75;
    private final Scheduler scheduler;
    private final AdAnalytics analytics;
    private final WebViewAPI webViewAPI;
    private final Map<String, Cookie> cookies = new HashMap<String, Cookie>();
    private AsyncFileUtils.ExistenceOperation fileExistenceOperation;
    @NonNull
    private Placement placement;
    private Advertisement advertisement;
    private Report report;
    private Repository repository;
    private File assetDir;
    private boolean muted;
    private boolean userExitEnabled;
    private boolean inPost;
    private LocalAdContract.LocalView adView;
    private String dialogTitle = "Are you sure?";
    private String dialogBody = "If you exit now, you will not get your reward";
    private String dialogContinue = "Continue";
    private String dialogClose = "Close";
    private AdContract.AdvertisementPresenter.EventListener bus;
    private int duration;
    private boolean adViewed;
    private AtomicBoolean sendReportIncentivized = new AtomicBoolean(false);
    private AtomicBoolean isDestroying = new AtomicBoolean(false);
    private int videoPosition;
    private int progress;
    private LinkedList<Advertisement.Checkpoint> checkpointList = new LinkedList();
    private Repository.SaveCallback repoCallback = new Repository.SaveCallback(){
        boolean errorHappened = false;

        @Override
        public void onSaved() {
        }

        @Override
        public void onError(Exception e2) {
            if (this.errorHappened) {
                return;
            }
            this.errorHappened = true;
            LocalAdPresenter.this.makeBusError(26);
            VungleLogger.error(LocalAdPresenter.class.getSimpleName() + "#onError", new VungleException(26).getLocalizedMessage());
            LocalAdPresenter.this.closeAndReport();
        }
    };
    private DurationRecorder durationRecorder;
    @Nullable
    private final String[] impressionUrls;
    private AtomicBoolean busy = new AtomicBoolean(false);

    public LocalAdPresenter(@NonNull Advertisement advertisement, @NonNull Placement placement, @NonNull Repository repository, @NonNull Scheduler scheduler, @NonNull AdAnalytics adAnalytics, @NonNull WebViewAPI webViewAPI, @Nullable OptionsState state, @NonNull File assetDir, @Nullable String[] impressionUrls) {
        this.advertisement = advertisement;
        this.placement = placement;
        this.scheduler = scheduler;
        this.analytics = adAnalytics;
        this.webViewAPI = webViewAPI;
        this.repository = repository;
        this.assetDir = assetDir;
        this.impressionUrls = impressionUrls;
        if (advertisement.getCheckpoints() != null) {
            this.checkpointList.addAll(advertisement.getCheckpoints());
            Collections.sort(this.checkpointList);
        }
        this.loadData(state);
    }

    @Override
    public void setEventListener(@Nullable AdContract.AdvertisementPresenter.EventListener listener) {
        this.bus = listener;
    }

    private void reportError(@NonNull String error) {
        this.report.recordError(error);
        this.repository.save(this.report, this.repoCallback);
        this.makeBusError(27);
        if (!this.inPost && this.advertisement.hasPostroll()) {
            this.playPost();
        } else {
            this.makeBusError(10);
            this.adView.close();
        }
    }

    public void reportAction(@NonNull String action, @Nullable String value) {
        if (action.equals("videoLength")) {
            this.duration = Integer.parseInt(value);
            this.report.setVideoLength(this.duration);
            this.repository.save(this.report, this.repoCallback);
            return;
        }
        switch (action) {
            case "mute": 
            case "unmute": 
            case "video_close": {
                this.analytics.ping(this.advertisement.getTpatUrls(action));
            }
        }
        this.report.recordAction(action, value, System.currentTimeMillis());
        this.repository.save(this.report, this.repoCallback);
    }

    @Override
    public void onViewConfigurationChanged() {
        this.webViewAPI.notifyPropertiesChange(true);
        this.adView.refreshDialogIfVisible();
    }

    @Override
    public void attach(@NonNull LocalAdContract.LocalView adView, @Nullable OptionsState state) {
        int settings;
        this.isDestroying.set(false);
        this.adView = adView;
        adView.setPresenter(this);
        if (this.bus != null) {
            this.bus.onNext("attach", this.advertisement.getCreativeId(), this.placement.getId());
        }
        if ((settings = this.advertisement.getAdConfig().getSettings()) > 0) {
            this.muted = (settings & 1) == 1;
            this.userExitEnabled = (settings & 2) == 2;
        }
        int requestedOrientation = -1;
        int adOrientation = this.advertisement.getAdConfig().getAdOrientation();
        if (adOrientation == 3) {
            switch (this.advertisement.getOrientation()) {
                case 0: {
                    requestedOrientation = 7;
                    break;
                }
                case 1: {
                    requestedOrientation = 6;
                }
            }
        } else {
            requestedOrientation = adOrientation == 0 ? 7 : (adOrientation == 1 ? 6 : 4);
        }
        Log.d((String)TAG, (String)("Requested Orientation " + requestedOrientation));
        adView.setOrientation(requestedOrientation);
        this.prepare(state);
        SessionTracker.getInstance().trackEvent(new SessionData.Builder().setEvent(SessionEvent.PLAY_AD).addData(SessionAttribute.SUCCESS, true).addData(SessionAttribute.EVENT_ID, this.advertisement.getId()).build());
    }

    @Override
    public void detach(@AdContract.AdStopReason int flag) {
        if (this.fileExistenceOperation != null) {
            this.fileExistenceOperation.cancel();
        }
        this.stop(flag);
        this.adView.destroyAdView(0L);
    }

    private void playPost() {
        File post = new File(this.assetDir.getPath());
        final File indexHtml = new File(post.getPath() + File.separator + "index.html");
        this.fileExistenceOperation = AsyncFileUtils.isFileExistAsync(indexHtml, new AsyncFileUtils.FileExistCallback(){

            @Override
            public void status(boolean isExist) {
                if (isExist) {
                    LocalAdPresenter.this.adView.showWebsite("file://" + indexHtml.getPath());
                    LocalAdPresenter.this.analytics.ping(LocalAdPresenter.this.advertisement.getTpatUrls("postroll_view"));
                    LocalAdPresenter.this.inPost = true;
                } else {
                    LocalAdPresenter.this.makeBusError(27);
                    LocalAdPresenter.this.makeBusError(10);
                    VungleLogger.error(LocalAdPresenter.class.getSimpleName() + "#playPost", "Error Rendering Postroll");
                    LocalAdPresenter.this.closeAndReport();
                }
            }
        });
    }

    private void prepare(@Nullable OptionsState state) {
        String userIdFromCookie;
        this.restoreFromSave(state);
        Cookie incentivizedCookie = this.cookies.get("incentivizedTextSetByPub");
        String string = userIdFromCookie = incentivizedCookie == null ? null : incentivizedCookie.getString("userID");
        if (this.report == null) {
            this.report = new Report(this.advertisement, this.placement, System.currentTimeMillis(), userIdFromCookie);
            this.report.setTtDownload(this.advertisement.getTtDownload());
            this.repository.save(this.report, this.repoCallback);
        }
        if (this.durationRecorder == null) {
            this.durationRecorder = new DurationRecorder(this.report, this.repository, this.repoCallback);
        }
        this.webViewAPI.setErrorHandler(this);
        this.adView.showCTAOverlay(this.advertisement.isCtaOverlayEnabled(), this.advertisement.getCtaClickArea());
        if (this.bus != null) {
            this.bus.onNext("start", null, this.placement.getId());
        }
    }

    private boolean needShowGDPR(@Nullable Cookie gdprConsent) {
        return gdprConsent != null && gdprConsent.getBoolean("is_country_data_protected") != false && "unknown".equals(gdprConsent.getString("consent_status"));
    }

    private void showGDPR(@NonNull Cookie gdprConsent) {
        final Cookie finalGdpr = gdprConsent;
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                String consented = "opted_out_by_timeout";
                if (i == -2) {
                    consented = "opted_out";
                } else if (i == -1) {
                    consented = "opted_in";
                }
                finalGdpr.putValue("consent_status", consented);
                finalGdpr.putValue("timestamp", System.currentTimeMillis() / 1000L);
                finalGdpr.putValue("consent_source", "vungle_modal");
                LocalAdPresenter.this.repository.save(finalGdpr, null);
                LocalAdPresenter.this.start();
            }
        };
        gdprConsent.putValue("consent_status", "opted_out_by_timeout");
        finalGdpr.putValue("timestamp", System.currentTimeMillis() / 1000L);
        finalGdpr.putValue("consent_source", "vungle_modal");
        this.repository.save(finalGdpr, this.repoCallback);
        this.showDialog(gdprConsent.getString("consent_title"), gdprConsent.getString("consent_message"), gdprConsent.getString("button_accept"), gdprConsent.getString("button_deny"), listener);
    }

    @Override
    public boolean handleExit() {
        if (this.inPost) {
            this.closeAndReport();
            return true;
        }
        if (!this.userExitEnabled) {
            return false;
        }
        if (this.placement.isIncentivized() && this.progress <= 75) {
            this.showIncetivizedDialog();
            return false;
        }
        this.reportAction("video_close", null);
        if (this.advertisement.hasPostroll()) {
            this.playPost();
            return false;
        }
        this.closeAndReport();
        return true;
    }

    private void showIncetivizedDialog() {
        String titleText = this.dialogTitle;
        String bodyText = this.dialogBody;
        String continueText = this.dialogContinue;
        String closeText = this.dialogClose;
        Cookie incentivizedCookie = this.cookies.get("incentivizedTextSetByPub");
        if (incentivizedCookie != null) {
            String titleString = incentivizedCookie.getString("title");
            titleText = !TextUtils.isEmpty((CharSequence)titleString) ? titleString : this.dialogTitle;
            String bodyString = incentivizedCookie.getString("body");
            bodyText = !TextUtils.isEmpty((CharSequence)bodyString) ? bodyString : this.dialogBody;
            String continueString = incentivizedCookie.getString("continue");
            continueText = !TextUtils.isEmpty((CharSequence)continueString) ? continueString : this.dialogContinue;
            String closeString = incentivizedCookie.getString("close");
            closeText = !TextUtils.isEmpty((CharSequence)closeString) ? closeString : this.dialogClose;
        }
        this.showDialog(titleText, bodyText, continueText, closeText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (which == -2) {
                    LocalAdPresenter.this.reportAction("video_close", null);
                    LocalAdPresenter.this.continueWithPostroll();
                }
            }
        });
    }

    private void showDialog(String titleText, String bodyText, String continueText, String closeText, DialogInterface.OnClickListener listener) {
        this.adView.pauseVideo();
        this.adView.showDialog(titleText, bodyText, continueText, closeText, listener);
    }

    private void continueWithPostroll() {
        if (this.advertisement.hasPostroll()) {
            this.playPost();
        } else {
            this.closeAndReport();
        }
    }

    private boolean isWebPageBlank() {
        String url = this.adView.getWebsiteUrl();
        return TextUtils.isEmpty((CharSequence)url) || "about:blank".equalsIgnoreCase(url);
    }

    @Override
    public void start() {
        this.durationRecorder.start();
        if (!this.adView.hasWebView()) {
            this.reportErrorAndCloseAd(31);
            VungleLogger.error(LocalAdPresenter.class.getSimpleName() + "#start", new VungleException(31).getLocalizedMessage());
            return;
        }
        this.adView.setImmersiveMode();
        this.adView.resumeWeb();
        Cookie gdprConsent = this.cookies.get("consentIsImportantToVungle");
        if (this.needShowGDPR(gdprConsent)) {
            this.showGDPR(gdprConsent);
            return;
        }
        if (this.inPost) {
            if (this.isWebPageBlank()) {
                this.playPost();
            }
        } else if (!this.adView.isVideoPlaying() && !this.adView.isDialogVisible()) {
            File video = new File(this.assetDir.getPath() + File.separator + "video");
            this.adView.playVideo(video, this.muted, this.videoPosition);
            int delayInMillis = this.advertisement.getShowCloseDelay(this.placement.isIncentivized());
            if (delayInMillis > 0) {
                this.scheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        LocalAdPresenter.this.userExitEnabled = true;
                        if (!LocalAdPresenter.this.inPost) {
                            LocalAdPresenter.this.adView.showCloseButton();
                        }
                    }
                }, delayInMillis);
            } else {
                this.userExitEnabled = true;
                this.adView.showCloseButton();
            }
        }
    }

    @Override
    public void stop(@AdContract.AdStopReason int stopReason) {
        this.durationRecorder.stop();
        boolean isChangingConfigurations = (stopReason & 1) != 0;
        boolean isFinishing = (stopReason & 2) != 0;
        this.adView.pauseWeb();
        if (this.adView.isVideoPlaying()) {
            this.videoPosition = this.adView.getVideoPosition();
            this.adView.pauseVideo();
        }
        if (!isChangingConfigurations && isFinishing) {
            if (!this.isDestroying.getAndSet(true)) {
                this.reportAction("close", null);
                this.scheduler.cancelAll();
                if (this.bus != null) {
                    this.bus.onNext("end", this.report.isCTAClicked() ? "isCTAClicked" : null, this.placement.getId());
                }
            }
        } else if (this.inPost || isFinishing) {
            this.adView.showWebsite("about:blank");
        }
    }

    @Override
    public void onProgressUpdate(int position, float duration) {
        this.progress = (int)((float)position / duration * 100.0f);
        this.videoPosition = position;
        this.durationRecorder.update();
        if (this.bus != null) {
            this.bus.onNext("percentViewed:" + this.progress, null, this.placement.getId());
        }
        if (this.bus != null && position > 0 && !this.adViewed) {
            this.adViewed = true;
            this.bus.onNext("adViewed", null, this.placement.getId());
            if (this.impressionUrls != null) {
                this.analytics.ping(this.impressionUrls);
            }
        }
        this.reportAction("video_viewed", String.format(Locale.ENGLISH, "%d", position));
        if (this.progress == 100) {
            if (this.checkpointList.peekLast() != null && this.checkpointList.peekLast().getPercentage() == 100) {
                this.analytics.ping(this.checkpointList.pollLast().getUrls());
            }
            this.continueWithPostroll();
        }
        this.report.recordProgress(this.videoPosition);
        this.repository.save(this.report, this.repoCallback);
        while (this.checkpointList.peek() != null && this.progress > this.checkpointList.peek().getPercentage()) {
            this.analytics.ping(this.checkpointList.poll().getUrls());
        }
        Cookie configCookie = this.cookies.get("configSettings");
        if (this.placement.isIncentivized() && this.progress > 75 && configCookie != null && configCookie.getBoolean("isReportIncentivizedEnabled").booleanValue() && !this.sendReportIncentivized.getAndSet(true)) {
            JsonObject body = new JsonObject();
            body.add("placement_reference_id", (JsonElement)new JsonPrimitive(this.placement.getId()));
            body.add("app_id", (JsonElement)new JsonPrimitive(this.advertisement.getAppID()));
            body.add("adStartTime", (JsonElement)new JsonPrimitive((Number)this.report.getAdStartTime()));
            body.add("user", (JsonElement)new JsonPrimitive(this.report.getUserID()));
            this.analytics.ri(body);
        }
    }

    @Override
    public void onVideoStart(int position, float duration) {
        this.reportAction("videoLength", String.format(Locale.ENGLISH, "%d", (int)duration));
    }

    @Override
    public void onMute(boolean muted) {
        this.muted = muted;
        if (muted) {
            this.reportAction("mute", "true");
        } else {
            this.reportAction("unmute", "false");
        }
    }

    @Override
    public void onDownload() {
        this.download();
    }

    @Override
    public boolean onMediaError(@NonNull String description) {
        this.reportError(description);
        VungleLogger.error(LocalAdPresenter.class.getSimpleName() + "#onMediaError", "Media Error: " + description);
        return false;
    }

    @Override
    public void onPrivacy() {
        this.adView.open(null, HTTPS_VUNGLE_COM_PRIVACY, new PresenterAppLeftCallback(this.bus, this.placement), null);
    }

    @Override
    public void generateSaveState(@Nullable OptionsState state) {
        if (state == null) {
            return;
        }
        this.repository.save(this.report, this.repoCallback);
        state.put(EXTRA_REPORT, this.report == null ? null : this.report.getId());
        state.put(EXTRA_INCENTIVIZED_SENT, this.sendReportIncentivized.get());
        state.put(EXTRA_IN_POST, this.inPost);
        state.put(EXTRA_IS_MUTED, this.muted);
        state.put(EXTRA_VIDEO_POSITION, this.adView != null && this.adView.isVideoPlaying() ? this.adView.getVideoPosition() : this.videoPosition);
    }

    @Override
    public void restoreFromSave(@Nullable OptionsState state) {
        if (state == null) {
            return;
        }
        boolean isIncentivizedShown = state.getBoolean(EXTRA_INCENTIVIZED_SENT, false);
        if (isIncentivizedShown) {
            this.sendReportIncentivized.set(true);
        }
        this.inPost = state.getBoolean(EXTRA_IN_POST, this.inPost);
        this.muted = state.getBoolean(EXTRA_IS_MUTED, this.muted);
        this.videoPosition = state.getInt(EXTRA_VIDEO_POSITION, this.videoPosition);
    }

    @Override
    public void onMraidAction(@NonNull String action) {
        switch (action) {
            case "close": {
                this.closeAndReport();
                break;
            }
            case "download": {
                this.download();
                this.closeAndReport();
                break;
            }
            case "privacy": {
                break;
            }
            default: {
                VungleLogger.error(LocalAdPresenter.class.getSimpleName() + "#onMraidAction", "Unknown MRAID Command");
                throw new IllegalArgumentException("Unknown action " + action);
            }
        }
    }

    private void download() {
        this.reportAction("cta", "");
        try {
            this.analytics.ping(this.advertisement.getTpatUrls("postroll_click"));
            this.analytics.ping(this.advertisement.getTpatUrls("click_url"));
            this.analytics.ping(this.advertisement.getTpatUrls("video_click"));
            this.analytics.ping(new String[]{this.advertisement.getCTAURL(true)});
            this.reportAction("download", null);
            String url = this.advertisement.getCTAURL(false);
            if (url == null || url.isEmpty()) {
                Log.e((String)TAG, (String)"CTA destination URL is not configured properly");
            } else {
                this.adView.open(this.advertisement.getDeeplinkUrl(), url, new PresenterAppLeftCallback(this.bus, this.placement), new PresenterAdOpenCallback(){

                    @Override
                    public void onAdOpenType(PresenterAdOpenCallback.AdOpenType adOpenType) {
                        if (adOpenType == PresenterAdOpenCallback.AdOpenType.DEEP_LINK) {
                            LocalAdPresenter.this.reportAction("deeplinkSuccess", null);
                        }
                    }
                });
            }
            if (this.bus != null) {
                this.bus.onNext("open", "adClick", this.placement.getId());
            }
        }
        catch (ActivityNotFoundException invalid) {
            Log.e((String)TAG, (String)"Unable to find destination activity");
            VungleLogger.error(LocalAdPresenter.class.getSimpleName() + "#download", "Download - Activity Not Found");
        }
    }

    private void closeAndReport() {
        if (this.busy.get()) {
            Log.w((String)TAG, (String)"Busy with closing");
            return;
        }
        this.busy.set(true);
        this.reportAction("close", null);
        this.scheduler.cancelAll();
        this.adView.close();
    }

    private void loadData(OptionsState optionsState) {
        this.cookies.put("incentivizedTextSetByPub", this.repository.load("incentivizedTextSetByPub", Cookie.class).get());
        this.cookies.put("consentIsImportantToVungle", this.repository.load("consentIsImportantToVungle", Cookie.class).get());
        this.cookies.put("configSettings", this.repository.load("configSettings", Cookie.class).get());
        if (optionsState != null) {
            Report restoredReport;
            String reportId = optionsState.getString(EXTRA_REPORT);
            Report report = restoredReport = TextUtils.isEmpty((CharSequence)reportId) ? null : this.repository.load(reportId, Report.class).get();
            if (restoredReport != null) {
                this.report = restoredReport;
            }
        }
    }

    @Override
    public void onReceivedError(String errorDesc, boolean didCrash) {
        if (this.report != null) {
            this.report.recordError(errorDesc);
            this.repository.save(this.report, this.repoCallback);
            VungleLogger.error(LocalAdPresenter.class.getSimpleName() + "onReceivedError", errorDesc);
        }
    }

    @Override
    public boolean onWebRenderingProcessGone(WebView view, boolean didCrash) {
        this.handleWebViewException(31);
        VungleLogger.error(LocalAdPresenter.class.getSimpleName() + "#onWebRenderingProcessGone", new VungleException(31).getLocalizedMessage());
        return true;
    }

    @Override
    public void onRenderProcessUnresponsive(@NonNull WebView webView, @Nullable WebViewRenderProcess webViewRenderProcess) {
        this.handleWebViewException(32);
        VungleLogger.error(LocalAdPresenter.class.getSimpleName() + "#onRenderProcessUnresponsive", new VungleException(32).getLocalizedMessage());
    }

    private void handleWebViewException(@VungleException.ExceptionCode int reason) {
        if (this.adView != null) {
            this.adView.removeWebView();
        }
        this.reportErrorAndCloseAd(reason);
    }

    private void reportErrorAndCloseAd(@VungleException.ExceptionCode int reason) {
        this.makeBusError(reason);
        VungleLogger.error(LocalAdPresenter.class.getSimpleName(), "WebViewException: " + new VungleException(reason).getLocalizedMessage());
        this.closeAndReport();
    }

    private void makeBusError(@VungleException.ExceptionCode int code) {
        if (this.bus != null) {
            this.bus.onError(new VungleException(code), this.placement.getId());
        }
    }
}

