/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.ui.presenter;

import android.content.ActivityNotFoundException;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.analytics.AdAnalytics;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.model.Advertisement;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.model.Placement;
import com.vungle.warren.model.Report;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.ui.DurationRecorder;
import com.vungle.warren.ui.PresenterAdOpenCallback;
import com.vungle.warren.ui.PresenterAppLeftCallback;
import com.vungle.warren.ui.contract.AdContract;
import com.vungle.warren.ui.contract.NativeAdContract;
import com.vungle.warren.ui.presenter.LocalAdPresenter;
import com.vungle.warren.ui.presenter.MRAIDAdPresenter;
import com.vungle.warren.ui.state.OptionsState;
import com.vungle.warren.utility.Scheduler;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class NativeAdPresenter
implements NativeAdContract.NativePresenter {
    private static final String TAG = NativeAdPresenter.class.getSimpleName();
    private static final String EXTRA_REPORT = "saved_report";
    private static final String EXTRA_INCENTIVIZED_SENT = "incentivized_sent";
    private static final String OPEN_ACTION = "mraidOpen";
    private static final String OPEN_DEEPLINK_SUCCESS = "deeplinkSuccess";
    private static final String NO_VALUE = "";
    private final Advertisement advertisement;
    private final Placement placement;
    private final Repository repository;
    private final Scheduler scheduler;
    private final AdAnalytics analytics;
    private final String[] impressionUrls;
    private Report report;
    private final Map<String, Cookie> cookies = new HashMap<String, Cookie>();
    private NativeAdContract.NativeView adView;
    private boolean adViewed;
    private AdContract.AdvertisementPresenter.EventListener bus;
    private final AtomicBoolean sendReportIncentivized = new AtomicBoolean(false);
    private final AtomicBoolean isDestroying = new AtomicBoolean(false);
    private final LinkedList<Advertisement.Checkpoint> checkpointList = new LinkedList();
    private final Repository.SaveCallback repoCallback = new Repository.SaveCallback(){
        boolean errorHappened = false;

        @Override
        public void onSaved() {
        }

        @Override
        public void onError(Exception e2) {
            if (this.errorHappened) {
                return;
            }
            this.errorHappened = true;
            NativeAdPresenter.this.makeBusError(26);
            VungleLogger.error(LocalAdPresenter.class.getSimpleName() + "#onError", new VungleException(26).getLocalizedMessage());
            NativeAdPresenter.this.closeView();
        }
    };
    private DurationRecorder durationRecorder;

    public NativeAdPresenter(@NonNull Advertisement advertisement, @NonNull Placement placement, @NonNull Repository repository, @NonNull Scheduler scheduler, @NonNull AdAnalytics analytics, @Nullable OptionsState state, @Nullable String[] impressionUrls) {
        this.advertisement = advertisement;
        this.placement = placement;
        this.repository = repository;
        this.scheduler = scheduler;
        this.analytics = analytics;
        this.impressionUrls = impressionUrls;
        if (advertisement.getCheckpoints() != null) {
            this.checkpointList.addAll(advertisement.getCheckpoints());
        }
        this.loadData(state);
    }

    @Override
    public void onDownload() {
        this.reportAction(OPEN_ACTION, NO_VALUE);
        try {
            this.analytics.ping(this.advertisement.getTpatUrls("clickUrl"));
            this.analytics.ping(new String[]{this.advertisement.getCTAURL(true)});
            this.reportAction("download", null);
            String url = this.advertisement.getCTAURL(false);
            String deeplinkUrl = this.advertisement.getDeeplinkUrl();
            if ((deeplinkUrl == null || deeplinkUrl.isEmpty()) && (url == null || url.isEmpty())) {
                Log.e((String)TAG, (String)"CTA destination URL is not configured properly");
            } else {
                this.adView.open(deeplinkUrl, url, new PresenterAppLeftCallback(this.bus, this.placement), new PresenterAdOpenCallback(){

                    @Override
                    public void onAdOpenType(PresenterAdOpenCallback.AdOpenType adOpenType) {
                        if (adOpenType == PresenterAdOpenCallback.AdOpenType.DEEP_LINK) {
                            NativeAdPresenter.this.reportAction(NativeAdPresenter.OPEN_DEEPLINK_SUCCESS, null);
                        }
                    }
                });
            }
            if (this.bus != null) {
                this.bus.onNext("open", "adClick", this.placement.getId());
            }
        }
        catch (ActivityNotFoundException invalid) {
            Log.e((String)TAG, (String)"Unable to find destination activity");
            VungleLogger.error(LocalAdPresenter.class.getSimpleName() + "#download", "Download - Activity Not Found");
        }
    }

    @Override
    public void onPrivacy() {
        String privacyUrl = this.advertisement.getPrivacyUrl();
        this.adView.open(null, privacyUrl, new PresenterAppLeftCallback(this.bus, this.placement), null);
    }

    @Override
    public void setAdVisibility(boolean isViewable) {
        Log.d((String)TAG, (String)("isViewable=" + isViewable + " " + this.placement + " " + this.hashCode()));
        if (isViewable) {
            this.durationRecorder.start();
        } else {
            this.durationRecorder.stop();
        }
    }

    @Override
    public void attach(@NonNull NativeAdContract.NativeView adView, @Nullable OptionsState state) {
        Log.d((String)TAG, (String)("attach() " + this.placement + " " + this.hashCode()));
        this.isDestroying.set(false);
        this.adView = adView;
        adView.setPresenter(this);
        if (this.bus != null) {
            this.bus.onNext("attach", this.advertisement.getCreativeId(), this.placement.getId());
        }
        int requestedOrientation = -1;
        int adOrientation = this.advertisement.getAdConfig().getAdOrientation();
        if (adOrientation == 3) {
            switch (this.advertisement.getOrientation()) {
                case 0: {
                    requestedOrientation = 7;
                    break;
                }
                case 1: {
                    requestedOrientation = 6;
                }
            }
        } else {
            requestedOrientation = adOrientation == 0 ? 7 : (adOrientation == 1 ? 6 : 4);
        }
        Log.d((String)TAG, (String)("Requested Orientation " + requestedOrientation));
        adView.setOrientation(requestedOrientation);
        this.prepare(state);
    }

    private void prepare(OptionsState state) {
        String userIdFromCookie;
        this.restoreFromSave(state);
        Cookie incentivizedCookie = this.cookies.get("incentivizedTextSetByPub");
        String string = userIdFromCookie = incentivizedCookie == null ? null : incentivizedCookie.getString("userID");
        if (this.report == null) {
            this.report = new Report(this.advertisement, this.placement, System.currentTimeMillis(), userIdFromCookie);
            this.report.setTtDownload(this.advertisement.getTtDownload());
            this.repository.save(this.report, this.repoCallback);
        }
        if (this.durationRecorder == null) {
            this.durationRecorder = new DurationRecorder(this.report, this.repository, this.repoCallback);
        }
        if (this.bus != null) {
            this.bus.onNext("start", null, this.placement.getId());
        }
    }

    @Override
    public void detach(@AdContract.AdStopReason int stopReason) {
        Log.d((String)TAG, (String)("detach() " + this.placement + " " + this.hashCode()));
        this.stop(stopReason);
        this.adView.destroyAdView(0L);
    }

    @Override
    public boolean handleExit() {
        this.closeView();
        return true;
    }

    @Override
    public void start() {
        Log.d((String)TAG, (String)("start() " + this.placement + " " + this.hashCode()));
        this.durationRecorder.start();
        Cookie gdprConsent = this.cookies.get("consentIsImportantToVungle");
        if (this.needShowGDPR(gdprConsent)) {
            this.showGDPR(gdprConsent);
        }
    }

    @Override
    public void stop(@AdContract.AdStopReason int stopReason) {
        boolean isFinishByAPI;
        Log.d((String)TAG, (String)("stop() " + this.placement + " " + this.hashCode()));
        this.durationRecorder.stop();
        boolean isChangingConfigurations = (stopReason & 1) != 0;
        boolean isFinishing = (stopReason & 2) != 0;
        boolean bl = isFinishByAPI = (stopReason & 4) != 0;
        if (!isChangingConfigurations && isFinishing && !this.isDestroying.getAndSet(true)) {
            if (isFinishByAPI) {
                this.reportAction("mraidCloseByApi", null);
            }
            this.repository.save(this.report, this.repoCallback);
            this.closeView();
            if (this.bus != null) {
                this.bus.onNext("end", this.report.isCTAClicked() ? "isCTAClicked" : null, this.placement.getId());
            }
        }
    }

    @Override
    public void generateSaveState(@Nullable OptionsState state) {
        if (state == null) {
            return;
        }
        this.repository.save(this.report, this.repoCallback);
        state.put(EXTRA_REPORT, this.report == null ? null : this.report.getId());
        state.put(EXTRA_INCENTIVIZED_SENT, this.sendReportIncentivized.get());
    }

    @Override
    public void restoreFromSave(@Nullable OptionsState state) {
        if (state == null) {
            return;
        }
        boolean incentivizedShown = state.getBoolean(EXTRA_INCENTIVIZED_SENT, false);
        if (incentivizedShown) {
            this.sendReportIncentivized.set(incentivizedShown);
        }
        if (this.report == null) {
            this.adView.close();
            VungleLogger.error(MRAIDAdPresenter.class.getSimpleName() + "#restoreFromSave", "The advertisement was not started and cannot be restored.");
            return;
        }
    }

    @Override
    public void setEventListener(@Nullable AdContract.AdvertisementPresenter.EventListener listener) {
        this.bus = listener;
    }

    @Override
    public void onViewConfigurationChanged() {
        this.adView.refreshDialogIfVisible();
    }

    @Override
    public void onMraidAction(String action) {
    }

    @Override
    public void onProgressUpdate(int position, float duration) {
        Log.d((String)TAG, (String)("onProgressUpdate() " + this.placement + " " + this.hashCode()));
        if (this.bus != null && position > 0 && !this.adViewed) {
            this.adViewed = true;
            this.bus.onNext("adViewed", null, this.placement.getId());
            if (this.impressionUrls != null) {
                this.analytics.ping(this.impressionUrls);
            }
        }
        if (this.bus != null) {
            this.bus.onNext("percentViewed:100", null, this.placement.getId());
        }
        this.reportVideoLength(5000L);
        this.reportAction("videoLength", String.format(Locale.ENGLISH, "%d", 5000));
        this.reportAction("videoViewed", String.format(Locale.ENGLISH, "%d", 100));
        Advertisement.Checkpoint checkpointStart = this.checkpointList.pollFirst();
        if (checkpointStart != null) {
            this.analytics.ping(checkpointStart.getUrls());
        }
        this.durationRecorder.update();
    }

    private void reportVideoLength(long value) {
        this.report.setVideoLength(value);
        this.repository.save(this.report, this.repoCallback);
    }

    private void reportAction(@NonNull String action, @Nullable String value) {
        this.report.recordAction(action, value, System.currentTimeMillis());
        this.repository.save(this.report, this.repoCallback);
    }

    private void loadData(OptionsState optionsState) {
        this.cookies.put("incentivizedTextSetByPub", this.repository.load("incentivizedTextSetByPub", Cookie.class).get());
        this.cookies.put("consentIsImportantToVungle", this.repository.load("consentIsImportantToVungle", Cookie.class).get());
        this.cookies.put("configSettings", this.repository.load("configSettings", Cookie.class).get());
        if (optionsState != null) {
            Report restoredReport;
            String reportId = optionsState.getString(EXTRA_REPORT);
            Report report = restoredReport = TextUtils.isEmpty((CharSequence)reportId) ? null : this.repository.load(reportId, Report.class).get();
            if (restoredReport != null) {
                this.report = restoredReport;
            }
        }
    }

    private boolean needShowGDPR(@Nullable Cookie gdprConsent) {
        return gdprConsent != null && gdprConsent.getBoolean("is_country_data_protected") != false && "unknown".equals(gdprConsent.getString("consent_status"));
    }

    private void showGDPR(@NonNull Cookie gdprConsent) {
        final Cookie finalGdpr = gdprConsent;
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                String consented = "opted_out_by_timeout";
                if (i == -2) {
                    consented = "opted_out";
                } else if (i == -1) {
                    consented = "opted_in";
                }
                finalGdpr.putValue("consent_status", consented);
                finalGdpr.putValue("timestamp", System.currentTimeMillis() / 1000L);
                finalGdpr.putValue("consent_source", "vungle_modal");
                NativeAdPresenter.this.repository.save(finalGdpr, null);
                NativeAdPresenter.this.start();
            }
        };
        gdprConsent.putValue("consent_status", "opted_out_by_timeout");
        finalGdpr.putValue("timestamp", System.currentTimeMillis() / 1000L);
        finalGdpr.putValue("consent_source", "vungle_modal");
        this.repository.save(finalGdpr, this.repoCallback);
        this.showDialog(gdprConsent.getString("consent_title"), gdprConsent.getString("consent_message"), gdprConsent.getString("button_accept"), gdprConsent.getString("button_deny"), listener);
    }

    private void showDialog(String titleText, String bodyText, String continueText, String closeText, DialogInterface.OnClickListener listener) {
        this.adView.showDialog(titleText, bodyText, continueText, closeText, listener);
    }

    private void makeBusError(@VungleException.ExceptionCode int code) {
        if (this.bus != null) {
            this.bus.onError(new VungleException(code), this.placement.getId());
        }
    }

    private void closeView() {
        this.adView.close();
        this.scheduler.cancelAll();
    }
}

