/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility;

import android.util.Log;
import androidx.annotation.NonNull;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;

public class CookieUtil {
    private static final String TAG = CookieUtil.class.getSimpleName();

    public static void update(@NonNull Repository repository, String cookieName, String key, Object value) {
        Cookie cookie = repository.load(cookieName, Cookie.class).get();
        if (cookie == null) {
            cookie = new Cookie(cookieName);
        }
        cookie.putValue(key, value);
        try {
            repository.save(cookie);
        }
        catch (DatabaseHelper.DBException e2) {
            Log.e((String)TAG, (String)"DB Exception saving cookie", (Throwable)e2);
        }
    }

    public static Boolean getBoolean(@NonNull Repository repository, String cookieName, String key) {
        Cookie cookie = repository.load(cookieName, Cookie.class).get();
        if (cookie != null) {
            return cookie.getBooleanOrNull(key);
        }
        return null;
    }
}

