/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vungle.warren.ui.PresenterAdOpenCallback;
import com.vungle.warren.utility.ActivityManager;
import java.net.URISyntaxException;

public class ExternalRouter {
    public static final String TAG = ExternalRouter.class.getSimpleName();

    public static boolean launch(@Nullable String deeplinkUrl, @Nullable String url, @NonNull Context context, @Nullable ActivityManager.LeftApplicationCallback leftApplicationCallback, boolean contextIsNotActivity, PresenterAdOpenCallback adOpenCallback) {
        if (TextUtils.isEmpty((CharSequence)deeplinkUrl) && TextUtils.isEmpty((CharSequence)url) || context == null) {
            return false;
        }
        try {
            Intent deeplinkIntent = ExternalRouter.getIntentFromUrl(deeplinkUrl, contextIsNotActivity);
            Intent fallbackIntent = ExternalRouter.getIntentFromUrl(url, contextIsNotActivity);
            ActivityManager.startWhenForeground(context, deeplinkIntent, fallbackIntent, leftApplicationCallback, adOpenCallback);
            return true;
        }
        catch (Exception e2) {
            Log.e((String)TAG, (String)("Error while opening url" + e2.getLocalizedMessage()));
            Log.d((String)TAG, (String)("Cannot open url " + url));
            return false;
        }
    }

    private static Intent getIntentFromUrl(String url, boolean contextIsNotActivity) {
        Intent intent = null;
        try {
            Intent intent2 = intent = TextUtils.isEmpty((CharSequence)url) ? null : Intent.parseUri((String)url, (int)0);
            if (intent != null && contextIsNotActivity) {
                intent.setFlags(0x10000000);
            }
        }
        catch (URISyntaxException e2) {
            Log.e((String)TAG, (String)("url format is not correct " + e2.getLocalizedMessage()));
        }
        return intent;
    }
}

