/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility;

import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.vungle.warren.utility.SafeObjectInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

public class FileUtility {
    private static ObjectInputStreamProvider objectInputStreamProvider = new ObjectInputStreamProvider(){

        @Override
        public SafeObjectInputStream provideObjectInputStream(InputStream inputStream) throws IOException {
            return new SafeObjectInputStream(inputStream, allowedClasses);
        }
    };
    private static final String TAG = FileUtility.class.getSimpleName();
    @VisibleForTesting
    protected static final List<Class<?>> allowedClasses = Arrays.asList(LinkedHashSet.class, HashSet.class, HashMap.class, ArrayList.class, File.class);

    public static void printDirectoryTree(File folder) {
    }

    private static void printDirectoryTree(File folder, int indent, StringBuilder sb) {
        if (folder == null) {
            return;
        }
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("folder is not a Directory");
        }
        sb.append(FileUtility.getIndentString(indent)).append("+--").append(folder.getName()).append("/\n");
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : folder.listFiles()) {
            if (file.isDirectory()) {
                FileUtility.printDirectoryTree(file, indent + 1, sb);
                continue;
            }
            FileUtility.printFile(file, indent + 1, sb);
        }
    }

    private static void printFile(File file, int indent, StringBuilder sb) {
        sb.append(FileUtility.getIndentString(indent)).append("+--").append(file.getName()).append('\n');
    }

    private static String getIndentString(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append("|  ");
        }
        return sb.toString();
    }

    public static void delete(File f2) throws IOException {
        if (f2 == null || !f2.exists()) {
            return;
        }
        if (f2.isDirectory()) {
            File[] files = f2.listFiles();
            if (files == null) {
                return;
            }
            for (File c2 : files) {
                FileUtility.delete(c2);
            }
        }
        if (!f2.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + f2);
        }
    }

    public static void deleteAndLogIfFailed(File file) {
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                Files.delete(file.toPath());
            } else if (!file.delete()) {
                Log.e((String)TAG, (String)("Cannot delete " + file.getName()));
            }
        }
        catch (IOException e2) {
            Log.e((String)TAG, (String)("Cannot delete " + file.getName()), (Throwable)e2);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NonNull
    public static HashMap<String, String> readMap(@NonNull String path) {
        File file = new File(path);
        Object ser = FileUtility.readSerializable(file);
        if (ser instanceof HashMap) {
            return (HashMap)ser;
        }
        return new HashMap<String, String>();
    }

    public static void writeMap(@NonNull String path, @NonNull HashMap<String, String> map) {
        File file = new File(path);
        if (map.isEmpty()) {
            return;
        }
        FileUtility.writeSerializable(file, map);
    }

    @NonNull
    @VisibleForTesting
    static ArrayList<String> readAllLines(@NonNull String path) {
        Object ser;
        File file = new File(path);
        if (file.exists() && (ser = FileUtility.readSerializable(file)) instanceof ArrayList) {
            return (ArrayList)ser;
        }
        return new ArrayList<String>();
    }

    public static void writeAllLines(@NonNull String path, @NonNull ArrayList<String> lines) {
        File file = new File(path);
        if (file.exists()) {
            FileUtility.deleteAndLogIfFailed(file);
        }
        if (lines.isEmpty()) {
            return;
        }
        FileUtility.writeSerializable(file, lines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSerializable(@NonNull File file, @Nullable Serializable serializable) {
        if (file.exists()) {
            FileUtility.deleteAndLogIfFailed(file);
        }
        if (serializable == null) {
            return;
        }
        FileOutputStream fout = null;
        ObjectOutputStream oout = null;
        try {
            fout = new FileOutputStream(file);
            oout = new ObjectOutputStream(fout);
            oout.writeObject(serializable);
            oout.reset();
        }
        catch (IOException e2) {
            try {
                Log.e((String)TAG, (String)"IOIOException", (Throwable)e2);
            }
            catch (Throwable throwable) {
                FileUtility.closeQuietly(oout);
                FileUtility.closeQuietly(fout);
                throw throwable;
            }
            FileUtility.closeQuietly(oout);
            FileUtility.closeQuietly(fout);
        }
        FileUtility.closeQuietly(oout);
        FileUtility.closeQuietly(fout);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static <T> T readSerializable(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static long size(@Nullable File file) {
        if (file == null || !file.exists()) {
            return 0L;
        }
        long length = 0L;
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null && children.length > 0) {
                for (File child : children) {
                    length += FileUtility.size(child);
                }
            }
            return length;
        }
        return file.length();
    }

    @VisibleForTesting
    static void setObjectInputStreamProvider(ObjectInputStreamProvider objectInputStreamProvider) {
        FileUtility.objectInputStreamProvider = objectInputStreamProvider;
    }

    @VisibleForTesting
    static ObjectInputStreamProvider getObjectInputStreamProvider() {
        return objectInputStreamProvider;
    }

    public static boolean isVideoFile(String filePath) {
        if (filePath != null) {
            return filePath.endsWith(".mp4");
        }
        return false;
    }

    static interface ObjectInputStreamProvider {
        public ObjectInputStream provideObjectInputStream(InputStream var1) throws IOException, ClassNotFoundException;
    }
}

