/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;

public class ImpressionTracker {
    private static final String TAG = ImpressionTracker.class.getSimpleName();
    private static final int MIN_VISIBILITY_PERCENTAGE = 1;
    private static final int VISIBILITY_THROTTLE_MILLIS = 100;
    private final Rect clipRect = new Rect();
    @NonNull
    @VisibleForTesting
    final ViewTreeObserver.OnPreDrawListener onPreDrawListener;
    @NonNull
    @VisibleForTesting
    WeakReference<ViewTreeObserver> weakViewTreeObserver;
    @NonNull
    private final Map<View, TrackingInfo> trackedViews;
    @NonNull
    private final VisibilityRunnable visibilityRunnable;
    @NonNull
    private final Handler visibilityHandler;
    private boolean isVisibilityScheduled;

    public ImpressionTracker(@NonNull Context context) {
        this(context, new WeakHashMap<View, TrackingInfo>(10), new Handler());
    }

    @VisibleForTesting
    ImpressionTracker(@NonNull Context context, @NonNull Map<View, TrackingInfo> trackedViews, @NonNull Handler visibilityHandler) {
        this.trackedViews = trackedViews;
        this.visibilityHandler = visibilityHandler;
        this.visibilityRunnable = new VisibilityRunnable();
        this.onPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                ImpressionTracker.this.scheduleVisibilityCheck();
                return true;
            }
        };
        this.weakViewTreeObserver = new WeakReference<Object>(null);
        this.setViewTreeObserver(context, null);
    }

    private void setViewTreeObserver(@Nullable Context context, @Nullable View view) {
        ViewTreeObserver originalViewTreeObserver = (ViewTreeObserver)this.weakViewTreeObserver.get();
        if (originalViewTreeObserver != null && originalViewTreeObserver.isAlive()) {
            return;
        }
        View rootView = this.getTopView(context, view);
        if (rootView == null) {
            Log.d((String)TAG, (String)"Unable to set ViewTreeObserver due to no available root view.");
            return;
        }
        ViewTreeObserver viewTreeObserver = rootView.getViewTreeObserver();
        if (!viewTreeObserver.isAlive()) {
            Log.d((String)TAG, (String)"The root view tree observer was not alive");
            return;
        }
        this.weakViewTreeObserver = new WeakReference<ViewTreeObserver>(viewTreeObserver);
        viewTreeObserver.addOnPreDrawListener(this.onPreDrawListener);
    }

    public void addView(@NonNull View view, @Nullable ImpressionListener listener) {
        this.setViewTreeObserver(view.getContext(), view);
        TrackingInfo trackingInfo = this.trackedViews.get(view);
        if (trackingInfo == null) {
            trackingInfo = new TrackingInfo();
            this.trackedViews.put(view, trackingInfo);
            this.scheduleVisibilityCheck();
        }
        trackingInfo.minViewablePercent = 1;
        trackingInfo.impressionListener = listener;
    }

    @VisibleForTesting
    void removeView(@NonNull View view) {
        this.trackedViews.remove(view);
    }

    public void clear() {
        this.trackedViews.clear();
        this.visibilityHandler.removeMessages(0);
        this.isVisibilityScheduled = false;
    }

    public void destroy() {
        this.clear();
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.weakViewTreeObserver.get();
        if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
            viewTreeObserver.removeOnPreDrawListener(this.onPreDrawListener);
        }
        this.weakViewTreeObserver.clear();
    }

    @Nullable
    private View getTopView(@Nullable Context context, @Nullable View view) {
        View rootView;
        View topView = null;
        if (context instanceof Activity) {
            topView = ((Activity)context).getWindow().getDecorView().findViewById(0x1020002);
        }
        if (topView == null && view != null && (rootView = view.getRootView()) != null) {
            topView = rootView.findViewById(0x1020002);
        }
        return topView;
    }

    private void scheduleVisibilityCheck() {
        if (this.isVisibilityScheduled) {
            return;
        }
        this.isVisibilityScheduled = true;
        this.visibilityHandler.postDelayed((Runnable)this.visibilityRunnable, 100L);
    }

    private boolean isVisible(@Nullable View view, int minPercentageViewed) {
        if (view == null || view.getVisibility() != 0 || view.getParent() == null) {
            return false;
        }
        if (!view.getGlobalVisibleRect(this.clipRect)) {
            return false;
        }
        long visibleViewArea = (long)this.clipRect.height() * (long)this.clipRect.width();
        long totalViewArea = (long)view.getHeight() * (long)view.getWidth();
        if (totalViewArea <= 0L) {
            return false;
        }
        return 100L * visibleViewArea >= (long)minPercentageViewed * totalViewArea;
    }

    @VisibleForTesting
    class VisibilityRunnable
    implements Runnable {
        @NonNull
        private final ArrayList<View> mVisibleViews = new ArrayList();

        VisibilityRunnable() {
        }

        @Override
        public void run() {
            ImpressionTracker.this.isVisibilityScheduled = false;
            for (Map.Entry entry : ImpressionTracker.this.trackedViews.entrySet()) {
                int minPercentageViewed;
                View view = (View)entry.getKey();
                if (!ImpressionTracker.this.isVisible(view, minPercentageViewed = ((TrackingInfo)entry.getValue()).minViewablePercent)) continue;
                this.mVisibleViews.add(view);
            }
            for (View view : this.mVisibleViews) {
                TrackingInfo info = (TrackingInfo)ImpressionTracker.this.trackedViews.get(view);
                if (info != null && info.impressionListener != null) {
                    info.impressionListener.onImpression(view);
                }
                ImpressionTracker.this.removeView(view);
            }
            this.mVisibleViews.clear();
        }
    }

    @VisibleForTesting
    static class TrackingInfo {
        int minViewablePercent;
        ImpressionListener impressionListener;

        TrackingInfo() {
        }
    }

    public static interface ImpressionListener {
        public void onImpression(View var1);
    }
}

