/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.PermissionChecker;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;

public class NetworkProvider {
    private static final String TAG = NetworkProvider.class.getSimpleName();
    private static NetworkProvider INSTANCE;
    private final Context ctx;
    @Nullable
    private final ConnectivityManager cm;
    private final AtomicInteger currentNetwork = new AtomicInteger();
    private ConnectivityManager.NetworkCallback networkCallback;
    private final Set<NetworkListener> listeners = new CopyOnWriteArraySet<NetworkListener>();
    public static final int TYPE_NONE = -1;
    private boolean enabled;
    private final Handler handler = new Handler(Looper.getMainLooper());
    static final long NETWORK_CHECK_DELAY = 30000L;
    private Runnable typeRunnable = new Runnable(){

        @Override
        public void run() {
            if (!NetworkProvider.this.listeners.isEmpty()) {
                NetworkProvider.this.onNetworkChanged();
                NetworkProvider.this.handler.postDelayed(NetworkProvider.this.typeRunnable, 30000L);
            }
        }
    };

    private NetworkProvider(Context context) {
        this.ctx = context.getApplicationContext();
        this.cm = (ConnectivityManager)this.ctx.getSystemService("connectivity");
        this.currentNetwork.set(this.getCurrentNetworkType());
    }

    public static synchronized NetworkProvider getInstance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new NetworkProvider(context);
        }
        return INSTANCE;
    }

    @SuppressLint(value={"newApi"})
    private synchronized void setEnableNetworkListener(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (this.cm != null) {
            try {
                if (enabled) {
                    NetworkRequest.Builder builder = new NetworkRequest.Builder();
                    builder.addCapability(12);
                    this.cm.registerNetworkCallback(builder.build(), this.getNetworkCallback());
                } else {
                    this.cm.unregisterNetworkCallback(this.getNetworkCallback());
                }
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)ex.getMessage());
            }
        }
    }

    @SuppressLint(value={"newApi"})
    private ConnectivityManager.NetworkCallback getNetworkCallback() {
        return this.networkCallback != null ? this.networkCallback : (this.networkCallback = new ConnectivityManager.NetworkCallback(){

            @RequiresApi(api=21)
            public void onAvailable(Network network) {
                super.onAvailable(network);
                NetworkProvider.this.onNetworkChanged();
            }

            @RequiresApi(api=21)
            public void onLost(Network network) {
                super.onLost(network);
                NetworkProvider.this.onNetworkChanged();
            }
        });
    }

    private void postToListeners(final int currentNetwork) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                for (NetworkListener listener : NetworkProvider.this.listeners) {
                    listener.onChanged(currentNetwork);
                }
            }
        });
    }

    public void onNetworkChanged() {
        this.getCurrentNetworkType();
    }

    public int getCurrentNetworkType() {
        int old;
        if (this.cm == null || PermissionChecker.checkCallingOrSelfPermission((Context)this.ctx, (String)"android.permission.ACCESS_NETWORK_STATE") != 0) {
            this.currentNetwork.set(-1);
            return -1;
        }
        NetworkInfo activeNetwork = this.cm.getActiveNetworkInfo();
        int newNetwork = activeNetwork != null && activeNetwork.isConnectedOrConnecting() ? activeNetwork.getType() : -1;
        if (newNetwork != (old = this.currentNetwork.getAndSet(newNetwork))) {
            Log.d((String)TAG, (String)("on network changed: " + old + "->" + newNetwork));
            this.postToListeners(newNetwork);
        }
        this.setEnableNetworkListener(!this.listeners.isEmpty());
        return newNetwork;
    }

    public void addListener(NetworkListener networkListener) {
        this.listeners.add(networkListener);
        this.setEnableNetworkListener(true);
    }

    public void removeListener(NetworkListener networkListener) {
        this.listeners.remove(networkListener);
        this.setEnableNetworkListener(!this.listeners.isEmpty());
    }

    public static interface NetworkListener {
        public void onChanged(int var1);
    }
}

