/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;

public class ThreadUtil {
    private static final Handler UI_HANDLER = new Handler(Looper.getMainLooper());

    public static boolean isMainThread() {
        Looper mainLooper = Looper.getMainLooper();
        if (mainLooper == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return mainLooper.isCurrentThread();
        }
        Looper myLooper = Looper.myLooper();
        return myLooper != null && mainLooper.getThread().equals(myLooper.getThread());
    }

    public static void runOnUiThread(@NonNull Runnable runnable) {
        if (ThreadUtil.isMainThread()) {
            runnable.run();
        } else {
            UI_HANDLER.post(runnable);
        }
    }
}

