/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility.platform;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.os.Environment;
import android.os.PowerManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Consumer;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.appset.AppSet;
import com.google.android.gms.appset.AppSetIdClient;
import com.google.android.gms.appset.AppSetIdInfo;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.vungle.warren.model.AdvertisingInfo;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;
import com.vungle.warren.utility.TimeoutProvider;
import com.vungle.warren.utility.VungleThreadPoolExecutor;
import com.vungle.warren.utility.platform.Platform;
import com.vungle.warren.utility.platform.WebViewUtil;
import java.util.concurrent.TimeUnit;

public class AndroidPlatform
implements Platform {
    private final PowerManager powerManager;
    private final Context context;
    private final Repository repository;
    private final VungleThreadPoolExecutor uaExecutor;
    private final String TAG = AndroidPlatform.class.getSimpleName();
    private final TimeoutProvider timeoutProvider;
    private String appSetId;
    private AdvertisingInfo advertisingInfo = null;
    private boolean defaultIdFallbackDisabled;

    public AndroidPlatform(Context context, Repository repository, VungleThreadPoolExecutor uaExecutor, TimeoutProvider timeoutProvider) {
        this.context = context;
        this.powerManager = (PowerManager)context.getSystemService("power");
        this.repository = repository;
        this.uaExecutor = uaExecutor;
        this.timeoutProvider = timeoutProvider;
        this.updateAppSetID();
    }

    @Override
    public boolean isAtLeastMinimumSDK() {
        return Build.VERSION.SDK_INT >= 21;
    }

    @Override
    public boolean getIsBatterySaverEnabled() {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.powerManager.isPowerSaveMode();
        }
        return false;
    }

    @Override
    public boolean getIsSideloaded() {
        if (Build.VERSION.SDK_INT >= 26) {
            if (0 == this.context.checkCallingOrSelfPermission("android.permission.REQUEST_INSTALL_PACKAGES")) {
                return this.context.getApplicationContext().getPackageManager().canRequestPackageInstalls();
            }
        } else {
            try {
                return Settings.Secure.getInt((ContentResolver)this.context.getContentResolver(), (String)"install_non_market_apps") == 1;
            }
            catch (Settings.SettingNotFoundException e2) {
                return false;
            }
        }
        return false;
    }

    @Override
    public double getVolumeLevel() {
        AudioManager audioManager = (AudioManager)this.context.getSystemService("audio");
        double max = audioManager.getStreamMaxVolume(3);
        double current = audioManager.getStreamVolume(3);
        return current / max;
    }

    @Override
    public boolean getIsSoundEnabled() {
        AudioManager audioManager = (AudioManager)this.context.getSystemService("audio");
        int current = audioManager.getStreamVolume(3);
        return current > 0;
    }

    @Override
    public boolean getIsSDCardPresent() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    @Override
    public void getUserAgentLazy(final Consumer<String> consumer) {
        this.uaExecutor.execute(new Runnable(){

            @Override
            public void run() {
                new WebViewUtil(AndroidPlatform.this.context, AndroidPlatform.this.repository).getUserAgent((Consumer<String>)consumer);
            }
        });
    }

    @Override
    @SuppressLint(value={"HardwareIds", "NewApi"})
    @NonNull
    public AdvertisingInfo getAdvertisingInfo() {
        block10: {
            if (this.advertisingInfo != null && !TextUtils.isEmpty((CharSequence)this.advertisingInfo.advertisingId)) {
                return this.advertisingInfo;
            }
            this.advertisingInfo = new AdvertisingInfo();
            try {
                if ("Amazon".equals(Build.MANUFACTURER)) {
                    try {
                        ContentResolver cr = this.context.getContentResolver();
                        this.advertisingInfo.limitAdTracking = Settings.Secure.getInt((ContentResolver)cr, (String)"limit_ad_tracking") == 1;
                        this.advertisingInfo.advertisingId = Settings.Secure.getString((ContentResolver)cr, (String)"advertising_id");
                    }
                    catch (Settings.SettingNotFoundException ex) {
                        Log.w((String)this.TAG, (String)"Error getting Amazon advertising info", (Throwable)ex);
                    }
                    break block10;
                }
                try {
                    AdvertisingIdClient.Info idInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.context);
                    if (idInfo != null) {
                        this.advertisingInfo.advertisingId = idInfo.getId();
                        this.advertisingInfo.limitAdTracking = idInfo.isLimitAdTrackingEnabled();
                    }
                }
                catch (NoClassDefFoundError ex) {
                    Log.e((String)this.TAG, (String)("Play services Not available: " + ex.getLocalizedMessage()));
                    ContentResolver cr = this.context.getContentResolver();
                    this.advertisingInfo.advertisingId = Settings.Secure.getString((ContentResolver)cr, (String)"advertising_id");
                }
                catch (GooglePlayServicesNotAvailableException exception) {
                    Log.e((String)this.TAG, (String)("Play services Not available: " + exception.getLocalizedMessage()));
                }
            }
            catch (Exception ex) {
                Log.e((String)this.TAG, (String)"Cannot load Advertising ID");
            }
        }
        return this.advertisingInfo;
    }

    @Override
    public String getAppSetId() {
        if (TextUtils.isEmpty((CharSequence)this.appSetId)) {
            Cookie appSetIdCookie = this.repository.load("appSetIdCookie", Cookie.class).get(this.timeoutProvider.getTimeout(), TimeUnit.MILLISECONDS);
            this.appSetId = appSetIdCookie != null ? appSetIdCookie.getString("appSetId") : null;
        }
        return this.appSetId;
    }

    @Override
    public String getAndroidId() {
        if (this.defaultIdFallbackDisabled) {
            return "";
        }
        String androidId = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
        return androidId;
    }

    @Override
    public void setAndroidIdFallbackDisabled(boolean disabled) {
        this.defaultIdFallbackDisabled = disabled;
    }

    @Override
    @Nullable
    public String getUserAgent() {
        String tempUserAgent;
        Cookie cookie = this.repository.load("userAgent", Cookie.class).get();
        if (cookie == null) {
            tempUserAgent = System.getProperty("http.agent");
        } else {
            tempUserAgent = cookie.getString("userAgent");
            if (TextUtils.isEmpty((CharSequence)tempUserAgent)) {
                tempUserAgent = System.getProperty("http.agent");
            }
        }
        return tempUserAgent;
    }

    private void updateAppSetID() {
        try {
            AppSetIdClient client = AppSet.getClient((Context)this.context);
            Task task = client.getAppSetIdInfo();
            task.addOnSuccessListener((OnSuccessListener)new OnSuccessListener<AppSetIdInfo>(){

                public void onSuccess(@NonNull AppSetIdInfo info) {
                    if (info != null) {
                        AndroidPlatform.this.appSetId = info.getId();
                        if (!TextUtils.isEmpty((CharSequence)AndroidPlatform.this.appSetId)) {
                            Cookie appSetIdCookie = new Cookie("appSetIdCookie");
                            appSetIdCookie.putValue("appSetId", AndroidPlatform.this.appSetId);
                            try {
                                AndroidPlatform.this.repository.save(appSetIdCookie);
                            }
                            catch (DatabaseHelper.DBException e2) {
                                Log.e((String)AndroidPlatform.this.TAG, (String)("error saving AppSetId in Cookie: " + e2.getLocalizedMessage()));
                            }
                        }
                    }
                }
            });
        }
        catch (NoClassDefFoundError ex) {
            Log.e((String)this.TAG, (String)("Required libs to get AppSetID Not available: " + ex.getLocalizedMessage()));
        }
    }
}

