/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren.utility.platform;

import android.content.Context;
import android.os.Build;
import android.util.AndroidRuntimeException;
import android.webkit.WebSettings;
import androidx.core.util.Consumer;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.model.Cookie;
import com.vungle.warren.persistence.DatabaseHelper;
import com.vungle.warren.persistence.Repository;

public class WebViewUtil {
    private final Context context;
    private final String TAG = WebViewUtil.class.getSimpleName();
    private final Repository repository;

    public WebViewUtil(Context context, Repository repository) {
        this.context = context;
        this.repository = repository;
    }

    public void getUserAgent(Consumer<String> consumer) {
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                String userAgent = WebSettings.getDefaultUserAgent((Context)this.context);
                consumer.accept((Object)userAgent);
                this.addUserAgentInCookie(userAgent);
            }
            catch (Exception e2) {
                if (e2 instanceof DatabaseHelper.DBException) {
                    VungleLogger.error(this.TAG, "Ran into database issue");
                }
                if (e2 instanceof AndroidRuntimeException) {
                    VungleLogger.error(this.TAG, "WebView could be missing here");
                }
                consumer.accept(null);
            }
            return;
        }
        consumer.accept(null);
    }

    private void addUserAgentInCookie(String userAgent) throws DatabaseHelper.DBException {
        Cookie cookie = new Cookie("userAgent");
        cookie.putValue("userAgent", userAgent);
        this.repository.save(cookie);
    }
}

