/*
 * Decompiled with CFR 0.152.
 */
package org.apache.httpcore.impl;

import java.net.Socket;
import org.apache.httpcore.HttpRequest;
import org.apache.httpcore.HttpRequestFactory;
import org.apache.httpcore.MethodNotSupportedException;
import org.apache.httpcore.RequestLine;
import org.apache.httpcore.annotation.Contract;
import org.apache.httpcore.annotation.ThreadingBehavior;
import org.apache.httpcore.message.BasicHttpEntityEnclosingRequest;
import org.apache.httpcore.message.BasicHttpRequest;
import org.apache.httpcore.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultHttpRequestFactory
implements HttpRequestFactory {
    public static final DefaultHttpRequestFactory INSTANCE = new DefaultHttpRequestFactory();
    private static final String[] URL_METHODS = new String[]{"GET", "HEAD", "OPTIONS", "TRACE", "CONNECT"};
    private static final String[] BODY_METHODS = new String[]{"POST", "PUT", "DELETE", "PATCH"};

    private static boolean isOneOf(String[] methods, String method) {
        for (String method2 : methods) {
            if (!method2.equalsIgnoreCase(method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public HttpRequest newHttpRequest(Socket socket, RequestLine requestline) throws MethodNotSupportedException {
        Args.notNull(requestline, "Request line");
        String method = requestline.getMethod();
        if (DefaultHttpRequestFactory.isOneOf(URL_METHODS, method)) {
            return new BasicHttpRequest(socket, requestline);
        }
        if (DefaultHttpRequestFactory.isOneOf(BODY_METHODS, method)) {
            return new BasicHttpEntityEnclosingRequest(socket, requestline);
        }
        throw new MethodNotSupportedException(method + " method not supported");
    }

    @Override
    public HttpRequest newHttpRequest(Socket socket, String method, String uri) throws MethodNotSupportedException {
        if (DefaultHttpRequestFactory.isOneOf(URL_METHODS, method)) {
            return new BasicHttpRequest(socket, method, uri);
        }
        if (DefaultHttpRequestFactory.isOneOf(BODY_METHODS, method)) {
            return new BasicHttpEntityEnclosingRequest(socket, method, uri);
        }
        throw new MethodNotSupportedException(method + " method not supported");
    }
}

