/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base;

import android.text.TextUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtils {
    public static final int TODAY = 1;
    public static final int WEEK = 2;
    public static final int OTHER = 3;
    private static final long DAY = 86400000L;
    private static final long HOUR = 3600000L;
    private static final long MINUTE = 60000L;
    public static final char mSeparator = ' ';
    public static final String FORMAT_LONG = "%d";
    public static final String FORMAT_DOUBLE_1F = "%.1f";
    private static ThreadLocal<SimpleDateFormat> dateFormatThreadLocal = new ThreadLocal();
    @Deprecated
    private static SimpleDateFormat sDateFormat = new SimpleDateFormat("MM-dd HH:mm:ss");
    private static int month = Calendar.getInstance().get(2) + 1;

    public static int getDay(long fileTime) {
        Calendar cal = Calendar.getInstance();
        TimeZone timeZone = cal.getTimeZone();
        int offset = timeZone.getOffset(System.currentTimeMillis());
        long day_target = (fileTime + (long)offset) / 86400000L;
        long day_now = (System.currentTimeMillis() + (long)offset) / 86400000L;
        if (day_now - day_target == 0L) {
            return 1;
        }
        if (day_now - day_target > 0L && day_now - day_target < 7L) {
            return 2;
        }
        return 3;
    }

    public static long getDistanceDays(String date1, String date2) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        long days = 0L;
        try {
            Date one = dateFormat.parse(date1);
            Date two = dateFormat.parse(date2);
            long time1 = one.getTime();
            long time2 = two.getTime();
            long diff = time1 < time2 ? time2 - time1 : time1 - time2;
            days = diff / 86400000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return days;
    }

    public static long[] getDistanceTimes(String date1, String date2) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long day = 0L;
        long hour = 0L;
        long min = 0L;
        long sec = 0L;
        try {
            Date one = dateFormat.parse(date1);
            Date two = dateFormat.parse(date2);
            long time1 = one.getTime();
            long time2 = two.getTime();
            long diff = time1 < time2 ? time2 - time1 : time1 - time2;
            day = diff / 86400000L;
            hour = diff / 3600000L - day * 24L;
            min = diff / 60000L - day * 24L * 60L - hour * 60L;
            sec = diff / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        long[] times = new long[]{day, hour, min, sec};
        return times;
    }

    public static String getDistanceTime(String str1, String str2) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long day = 0L;
        long hour = 0L;
        long min = 0L;
        long sec = 0L;
        try {
            Date one = df.parse(str1);
            Date two = df.parse(str2);
            long time1 = one.getTime();
            long time2 = two.getTime();
            long diff = time1 < time2 ? time2 - time1 : time1 - time2;
            day = diff / 86400000L;
            hour = diff / 3600000L - day * 24L;
            min = diff / 60000L - day * 24L * 60L - hour * 60L;
            sec = diff / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206" + sec + "\u79d2";
    }

    public static String getToday() {
        Calendar ca = Calendar.getInstance();
        Date date = ca.getTime();
        return DateUtils.getYMDDate(date);
    }

    public static String getYMDDate(Date date) {
        String date_StrTime = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        date_StrTime = sdf.format(date);
        return date_StrTime;
    }

    public static String getMDYDate(Date date) {
        String date_StrTime = null;
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd,yyyy");
        date_StrTime = sdf.format(date);
        return date_StrTime;
    }

    public static String getCurrentTime(SimpleDateFormat sdf) {
        Calendar ca = Calendar.getInstance();
        Date date = ca.getTime();
        String date_StrTime = null;
        date_StrTime = sdf.format(date);
        return date_StrTime;
    }

    public static int getCurrentDayOfYear() {
        Calendar nowCalendar = Calendar.getInstance();
        nowCalendar.setFirstDayOfWeek(2);
        return nowCalendar.get(6);
    }

    public static String getYMDHMSDate(Date date) {
        String date_StrTime = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        date_StrTime = sdf.format(date);
        return date_StrTime;
    }

    public static String getTodayHMS() {
        Calendar ca = Calendar.getInstance();
        Date date = ca.getTime();
        return DateUtils.getYMDHMSDate(date);
    }

    public static boolean getDistanceTimeBy72(String str1) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date one = df.parse(str1);
            Date two = new Date();
            long time1 = one.getTime();
            long time2 = two.getTime();
            return time2 - time1 > 259200000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String dateToString(Date date) {
        String str = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("MM-dd,yyyy");
            str = sdf.format(date);
        }
        catch (Exception e) {
            e.getMessage();
        }
        return str;
    }

    public static Date stringToDate(String str) {
        return DateUtils.stringToDate(str, "yyyy-MM-dd");
    }

    public static Date stringToDate(String str, String pattern) {
        Date date = null;
        try {
            SimpleDateFormat simpleDateFormat = dateFormatThreadLocal.get();
            if (simpleDateFormat == null) {
                simpleDateFormat = new SimpleDateFormat(pattern);
                dateFormatThreadLocal.set(simpleDateFormat);
            }
            date = simpleDateFormat.parse(str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static boolean isSunday() {
        try {
            Date date = new Date(System.currentTimeMillis());
            Calendar cal = Calendar.getInstance();
            if (date != null) {
                cal.setTime(new Date(date.getTime()));
            }
            return cal.get(7) == 1;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean sameDate(Date d1, Date d2) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        return fmt.format(d1).equals(fmt.format(d2));
    }

    public static int differentDaysByMillisecond(Date date1, Date date2) {
        int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return days + 1;
    }

    public static String beforeAfterDate(int days) {
        long nowTime = System.currentTimeMillis();
        long changeTimes = (long)days * 24L * 60L * 60L * 1000L;
        return DateUtils.getStrTime(String.valueOf(nowTime + changeTimes), "yyyy-MM-dd");
    }

    public static String getStrTime(String timeStamp, String format) {
        String timeString = null;
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        long l = Long.valueOf(timeStamp);
        timeString = sdf.format(new Date(l));
        return timeString;
    }

    public static String getTodayByLong(long time) {
        Date date = new Date(time);
        return DateUtils.getYMDHMSDate(date);
    }

    public static boolean compareDateByDay(String date1) {
        if (TextUtils.isEmpty((CharSequence)date1)) {
            return true;
        }
        Date dt1 = DateUtils.stringToDate(date1);
        Date dt2 = DateUtils.stringToDate(DateUtils.getToday());
        return dt2.getTime() - dt1.getTime() == 86400000L;
    }

    public static boolean equalDateByDay(String date1) {
        if (TextUtils.isEmpty((CharSequence)date1)) {
            return true;
        }
        Date dt1 = DateUtils.stringToDate(date1);
        Date dt2 = DateUtils.stringToDate(DateUtils.getToday());
        return dt2.getTime() - dt1.getTime() == 0L;
    }

    public static boolean compareTimeByDay(String date1) {
        if (TextUtils.isEmpty((CharSequence)date1)) {
            return true;
        }
        Date dt1 = DateUtils.stringToDate(date1);
        Date dt2 = DateUtils.stringToDate(DateUtils.getToday());
        return dt2.getTime() - dt1.getTime() > 0L;
    }

    public static String getCurrentTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        return df.format(date);
    }

    public static String getSystemTime() {
        String current = String.valueOf(System.currentTimeMillis());
        return current;
    }

    public static String getDateByString() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static long dateSubtraction(String start, String end) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date1 = df.parse(start);
            Date date2 = df.parse(end);
            return date2.getTime() - date1.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long dateTogether(Date start, Date end) {
        return end.getTime() - start.getTime();
    }

    public static String transferLongToDate(String millSec) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss.SSS");
        Date date = new Date(Long.parseLong(millSec));
        return sdf.format(date);
    }

    public static String transferLongToDate(long millSec) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss.SSS");
        Date date = new Date(millSec);
        return sdf.format(date);
    }

    public static String getOkDate(String date) {
        try {
            if (TextUtils.isEmpty((CharSequence)date)) {
                return null;
            }
            Date date1 = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.ENGLISH).parse(date);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(date1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        return cal.get(7) - 1;
    }

    public static boolean isEffectiveDate(Date nowTime, String dateSection) {
        try {
            String[] times = dateSection.split(",");
            String format = "yyyy-MM-dd";
            Date startTime = new SimpleDateFormat(format).parse(times[0]);
            Date endTime = new SimpleDateFormat(format).parse(times[1]);
            if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
                return true;
            }
            Calendar date = Calendar.getInstance();
            date.setTime(nowTime);
            Calendar begin = Calendar.getInstance();
            begin.setTime(startTime);
            Calendar end = Calendar.getInstance();
            end.setTime(endTime);
            if (DateUtils.isSameDay(date, begin) || DateUtils.isSameDay(date, end)) {
                return true;
            }
            return date.after(begin) && date.before(end);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 != null && cal2 != null) {
            return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
        }
        throw new IllegalArgumentException("The date must not be null");
    }

    public static boolean isSameDay(long time1, long time2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTimeInMillis(time1);
        cal2.setTimeInMillis(time2);
        if (cal1 != null && cal2 != null) {
            return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
        }
        throw new IllegalArgumentException("The date must not be null");
    }

    public static long getTimeByDate(String time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = format.parse(time);
            return date.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String getCurrentHour() {
        GregorianCalendar calendar = new GregorianCalendar();
        int hour = calendar.get(11);
        if (hour < 10) {
            return DateUtils.getCurrentTime() + " 0" + hour;
        }
        return DateUtils.getDateByString() + " " + hour;
    }

    public static String getCurrentHourBefore() {
        GregorianCalendar calendar = new GregorianCalendar();
        int hour = calendar.get(11);
        if (hour > 0) {
            hour = calendar.get(11) - 1;
            if (hour < 10) {
                return DateUtils.getDateByString() + " 0" + hour;
            }
            return DateUtils.getDateByString() + " " + hour;
        }
        return DateUtils.getBeforeDay() + " " + 23;
    }

    public static String getBeforeDay() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -1);
        date = calendar.getTime();
        return sdf.format(date);
    }

    public static String getServen() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.add(5, -7);
        Date monday = c.getTime();
        String preMonday = sdf.format(monday);
        return preMonday;
    }

    public static String getOneMonth() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.add(2, -1);
        Date monday = c.getTime();
        String preMonday = sdf.format(monday);
        return preMonday;
    }

    public static String getThreeMonth() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.add(2, -3);
        Date monday = c.getTime();
        String preMonday = sdf.format(monday);
        return preMonday;
    }

    public static String getOneYear() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.add(1, -1);
        Date start = c.getTime();
        String startDay = sdf.format(start);
        return startDay;
    }

    public static List getMonthList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 1; i <= month; ++i) {
            list.add(i);
        }
        return list;
    }

    public static List getQuartList() {
        int quart = month / 3 + 1;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 1; i <= quart; ++i) {
            list.add(i);
        }
        return list;
    }

    public static long date2TimeStamp(String dateStr, String format) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.parse(dateStr).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static Date convertToDate(String strDate) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy:MM:dd");
        return df.parse(strDate);
    }
}

