/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.binding;

import android.graphics.Typeface;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.databinding.BindingAdapter;
import com.xshare.base.util.ConvertUtils;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a\u001b\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0000\u001a\u0004\u0018\u00010\u0003H\u0007\u00a2\u0006\u0002\u0010\u0004\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a/\u0010\b\u001a\u00020\u0001*\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0007\u00a2\u0006\u0002\u0010\r\u001a*\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0007\u001a \u0010\u0012\u001a\u00020\u0001*\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0011H\u0007\u00a8\u0006\u0015"}, d2={"bindIsBold", "", "Landroid/widget/TextView;", "", "(Landroid/widget/TextView;Ljava/lang/Boolean;)V", "bindMemoryText", "size", "", "bindShowText", "content", "", "defaultContent", "showStatus", "(Landroid/widget/TextView;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;)V", "bindSpanText", "keyword", "spanColor", "", "bindText", "", "bindMaxLength", "app_release"})
public final class BindingTextViewKt {
    @BindingAdapter(value={"bindText", "bindMaxLength"}, requireAll=false)
    public static final void bindText(@NotNull TextView $this$bindText, @Nullable Object content, int bindMaxLength) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$bindText, (String)"<this>");
        if (content == null) {
            $this$bindText.setVisibility(8);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)content.toString())) {
            n = 8;
        } else {
            $this$bindText.setText(bindMaxLength > 0 && content.toString().length() > bindMaxLength ? (CharSequence)(content.toString().subSequence(0, bindMaxLength) + "...") : (CharSequence)content.toString());
            n = 0;
        }
        $this$bindText.setVisibility(n);
    }

    public static /* synthetic */ void bindText$default(TextView textView, Object object, int n, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        BindingTextViewKt.bindText(textView, object, n);
    }

    @BindingAdapter(value={"bindIsBold"})
    public static final void bindIsBold(@NotNull TextView $this$bindIsBold, @Nullable Boolean bindIsBold) {
        Intrinsics.checkNotNullParameter((Object)$this$bindIsBold, (String)"<this>");
        $this$bindIsBold.setTypeface(Intrinsics.areEqual((Object)bindIsBold, (Object)true) ? Typeface.defaultFromStyle((int)1) : Typeface.defaultFromStyle((int)0));
    }

    @BindingAdapter(value={"bindingShowText", "bindingDefaultText", "bindingShowStatus"}, requireAll=false)
    public static final void bindShowText(@NotNull TextView $this$bindShowText, @Nullable String content, @Nullable String defaultContent, @Nullable Boolean showStatus) {
        Intrinsics.checkNotNullParameter((Object)$this$bindShowText, (String)"<this>");
        if (content == null && defaultContent == null) {
            return;
        }
        if (showStatus == null) {
            $this$bindShowText.setText(TextUtils.isEmpty((CharSequence)String.valueOf(content)) || TextUtils.equals((CharSequence)"null", (CharSequence)String.valueOf(content)) ? (CharSequence)String.valueOf(defaultContent) : (CharSequence)String.valueOf(content));
        } else {
            CharSequence charSequence;
            if (showStatus.booleanValue()) {
                if (content == null || TextUtils.equals(null, (CharSequence)content.toString())) {
                    return;
                }
                charSequence = content.toString();
            } else {
                if (defaultContent == null || TextUtils.equals((CharSequence)"null", (CharSequence)defaultContent.toString())) {
                    return;
                }
                charSequence = defaultContent.toString();
            }
            $this$bindShowText.setText(charSequence);
        }
    }

    @BindingAdapter(value={"bindSpanContent", "bindSpanKeyword", "bindSpanColor"}, requireAll=false)
    public static final void bindSpanText(@NotNull TextView $this$bindSpanText, @Nullable String content, @Nullable String keyword, @ColorInt int spanColor) {
        Intrinsics.checkNotNullParameter((Object)$this$bindSpanText, (String)"<this>");
        CharSequence charSequence = content;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        charSequence = keyword;
        if (!(charSequence == null || charSequence.length() == 0)) {
            int a = StringsKt.indexOf$default((CharSequence)content, (String)keyword, (int)0, (boolean)false, (int)6, null);
            List keyList = new ArrayList();
            while (a != -1) {
                int[] nArray = new int[]{a, a + keyword.length()};
                keyList.add(nArray);
                a = StringsKt.indexOf$default((CharSequence)content, (String)keyword, (int)(a + keyword.length()), (boolean)false, (int)4, null);
            }
            SpannableString span = new SpannableString((CharSequence)content);
            for (int[] ints : keyList) {
                span.setSpan((Object)new ForegroundColorSpan(spanColor), ints[0], ints[1], 34);
            }
            $this$bindSpanText.setText((CharSequence)span);
        } else {
            $this$bindSpanText.setText((CharSequence)content);
        }
    }

    @BindingAdapter(value={"bindMemoryText"})
    public static final void bindMemoryText(@NotNull TextView $this$bindMemoryText, long size) {
        Intrinsics.checkNotNullParameter((Object)$this$bindMemoryText, (String)"<this>");
        $this$bindMemoryText.setText((CharSequence)ConvertUtils.byte2FitMemorySize(size, 1));
    }
}

