/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.decoration;

import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class GridSpaceItemDecoration
extends RecyclerView.ItemDecoration {
    public static final int LINEARLAYOUT = 0;
    public static final int GRIDLAYOUT = 1;
    public static final int STAGGEREDGRIDLAYOUT = 2;
    private int headItemCount;
    private int space;
    private boolean includeEdge;
    private int spanCount;
    private int layoutManager;

    public GridSpaceItemDecoration(int space, boolean includeEdge, int layoutManager2) {
        this(space, 0, includeEdge, layoutManager2);
    }

    public GridSpaceItemDecoration(int space, int headItemCount, boolean includeEdge, int layoutManager2) {
        this.space = space;
        this.headItemCount = headItemCount;
        this.includeEdge = includeEdge;
        this.layoutManager = layoutManager2;
    }

    public GridSpaceItemDecoration(int space, int headItemCount, int layoutManager2) {
        this(space, headItemCount, true, layoutManager2);
    }

    public GridSpaceItemDecoration(int space, int layoutManager2) {
        this(space, 0, true, layoutManager2);
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        switch (this.layoutManager) {
            case 0: {
                this.setLinearLayoutSpaceItemDecoration(outRect, view, parent);
                break;
            }
            case 1: {
                GridLayoutManager gridLayoutManager = (GridLayoutManager)parent.getLayoutManager();
                this.spanCount = gridLayoutManager.getSpanCount();
                this.setNGridLayoutSpaceItemDecoration(outRect, view, parent);
                break;
            }
            case 2: {
                StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)parent.getLayoutManager();
                this.spanCount = staggeredGridLayoutManager.getSpanCount();
                this.setNGridLayoutSpaceItemDecoration(outRect, view, parent);
                break;
            }
        }
    }

    private void setLinearLayoutSpaceItemDecoration(Rect outRect, View view, RecyclerView parent) {
        outRect.left = this.space;
        outRect.right = this.space;
        outRect.bottom = this.space;
        outRect.top = parent.getChildLayoutPosition(view) == 0 ? this.space : 0;
    }

    private void setNGridLayoutSpaceItemDecoration(Rect outRect, View view, RecyclerView parent) {
        int position = parent.getChildAdapterPosition(view) - this.headItemCount;
        if (this.headItemCount != 0 && position == -this.headItemCount) {
            return;
        }
        int column = position % this.spanCount;
        if (this.includeEdge) {
            outRect.left = this.space - column * this.space / this.spanCount;
            outRect.right = (column + 1) * this.space / this.spanCount;
            if (position < this.spanCount) {
                outRect.top = this.space;
            }
            outRect.bottom = this.space;
        } else {
            outRect.left = column * this.space / this.spanCount;
            outRect.right = this.space - (column + 1) * this.space / this.spanCount;
            if (position >= this.spanCount) {
                outRect.top = this.space;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LayoutManager {
        public int type() default 0;
    }
}

