/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.decoration;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public class LinearItemDecoration
extends RecyclerView.ItemDecoration {
    private int mDivHeight = 1;
    private int divColor = 0;
    private int divMarginLeft;
    private int divMarginRight;
    private Paint mPaint = new Paint();
    private int spanLeft;
    private int spanTop;
    private int spanRight;
    private int spanBottom;

    public LinearItemDecoration() {
        this.mPaint.setAntiAlias(true);
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        if (parent.getLayoutManager() instanceof LinearLayoutManager) {
            int orientation = ((LinearLayoutManager)parent.getLayoutManager()).getOrientation();
            switch (orientation) {
                case 1: {
                    this.verticalItemDecoration(outRect, view, parent);
                    break;
                }
                case 0: {
                    this.horizontalItemDecoration(outRect, view, parent);
                    break;
                }
            }
        }
    }

    public void onDraw(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        super.onDraw(c, parent, state);
        if (this.divColor == 0) {
            return;
        }
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            int position = parent.getChildAdapterPosition(child);
            if (position == 0) continue;
            int top = child.getTop() - this.mDivHeight;
            int left = parent.getPaddingLeft() + this.divMarginLeft;
            int right = child.getWidth() - parent.getPaddingRight() - this.divMarginRight;
            int bottom = child.getTop();
            c.drawRect((float)left, (float)top, (float)right, (float)bottom, this.mPaint);
        }
    }

    public LinearItemDecoration setDivColor(@ColorInt int color) {
        this.divColor = color;
        this.mPaint.setColor(this.divColor);
        return this;
    }

    public LinearItemDecoration setDivHeight(int divHeight) {
        this.mDivHeight = divHeight;
        this.mPaint.setStrokeWidth((float)this.mDivHeight);
        return this;
    }

    public LinearItemDecoration setDivMarginLeft(int divMarginLeft) {
        this.divMarginLeft = divMarginLeft;
        return this;
    }

    public LinearItemDecoration setDivMarginRight(int divMarginRight) {
        this.divMarginRight = divMarginRight;
        return this;
    }

    public LinearItemDecoration setSpanLeft(int spanLeft) {
        this.spanLeft = spanLeft;
        return this;
    }

    public LinearItemDecoration setSpanRight(int spanRight) {
        this.spanRight = spanRight;
        return this;
    }

    public LinearItemDecoration setSpanTop(int spanTop) {
        this.spanTop = spanTop;
        return this;
    }

    public LinearItemDecoration setSpanBottom(int spanBottom) {
        this.spanBottom = spanBottom;
        return this;
    }

    private void verticalItemDecoration(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent) {
        outRect.top = this.getPosition(view, parent) == 0 ? 0 : this.spanTop;
        outRect.left = this.spanLeft;
        outRect.right = this.spanRight;
        outRect.bottom = this.spanBottom;
    }

    private void horizontalItemDecoration(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent) {
        outRect.left = this.getPosition(view, parent) == 0 ? 0 : this.spanLeft;
        outRect.top = this.spanTop;
        outRect.bottom = this.spanBottom;
        outRect.right = this.getPosition(view, parent) == this.getItemCount(parent) - 1 ? 0 : this.spanRight;
    }

    private int getPosition(@NonNull View view, @NonNull RecyclerView parent) {
        return parent.getChildLayoutPosition(view);
    }

    private int getItemCount(RecyclerView recyclerView) {
        return recyclerView.getAdapter() == null ? 0 : recyclerView.getAdapter().getItemCount();
    }
}

