/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.decoration;

import android.graphics.Rect;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import java.util.Objects;

public class SpaceItemDecoration
extends RecyclerView.ItemDecoration {
    private int mSpace;
    private int mSpanCount;
    private int mRadixX;
    private int mItemCountInLastLine;
    private int mOldItemCount = -1;
    private boolean mNeedOutSizeSpace;

    public SpaceItemDecoration(int space) {
        this(space, 1);
    }

    public SpaceItemDecoration(int space, int spanCount) {
        this(space, spanCount, true);
    }

    public SpaceItemDecoration(int space, int spanCount, boolean needOutSizeSpace) {
        this.mSpace = space;
        this.mSpanCount = spanCount;
        this.mRadixX = space / spanCount;
        this.mNeedOutSizeSpace = needOutSizeSpace;
    }

    public void getItemOffsets(@NonNull Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int index;
        int spanSize;
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
        int sumCount = state.getItemCount();
        int position = params.getViewLayoutPosition();
        if (params instanceof GridLayoutManager.LayoutParams) {
            GridLayoutManager.LayoutParams gridParams = (GridLayoutManager.LayoutParams)params;
            spanSize = gridParams.getSpanSize();
            index = gridParams.getSpanIndex();
            if ((position == 0 || this.mOldItemCount != sumCount) && this.mSpanCount > 1) {
                int countInLine = 0;
                for (int tempPosition = sumCount - this.mSpanCount; tempPosition < sumCount; ++tempPosition) {
                    int spanIndex = ((GridLayoutManager)Objects.requireNonNull(parent.getLayoutManager())).getSpanSizeLookup().getSpanIndex(tempPosition, this.mSpanCount);
                    countInLine = spanIndex == 0 ? 1 : countInLine + 1;
                }
                this.mItemCountInLastLine = countInLine;
                if (this.mOldItemCount != sumCount) {
                    this.mOldItemCount = sumCount;
                    if (position != 0) {
                        parent.post(() -> ((RecyclerView)parent).invalidateItemDecorations());
                    }
                }
            }
        } else if (params instanceof StaggeredGridLayoutManager.LayoutParams) {
            spanSize = ((StaggeredGridLayoutManager.LayoutParams)params).isFullSpan() ? this.mSpanCount : 1;
            index = ((StaggeredGridLayoutManager.LayoutParams)params).getSpanIndex();
        } else {
            spanSize = 1;
            index = 0;
        }
        if (spanSize < 1 || index < 0 || spanSize > this.mSpanCount) {
            return;
        }
        outRect.left = !this.mNeedOutSizeSpace && index % this.mSpanCount == 0 ? 0 : this.mSpace - this.mRadixX * index;
        outRect.right = !this.mNeedOutSizeSpace && (index + 1) % this.mSpanCount == 0 ? 0 : this.mRadixX + this.mRadixX * (index + spanSize - 1);
        if (this.mSpanCount == 1 && position == sumCount - 1 || position >= sumCount - this.mItemCountInLastLine && position < sumCount) {
            outRect.bottom = this.mSpace;
        }
        outRect.top = this.mSpace;
    }
}

