/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.jsondeserializer;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class IntegerAdapter
extends TypeAdapter<Integer> {
    public void write(JsonWriter out, Integer value) throws IOException {
        try {
            if (value == null) {
                value = -1;
            }
            out.value((Number)value);
        }
        catch (Exception e) {
            out.value(-1L);
        }
    }

    public Integer read(JsonReader in) {
        try {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return -1;
            }
            if (in.peek() == JsonToken.BOOLEAN) {
                boolean b = in.nextBoolean();
                return b ? 1 : -1;
            }
            if (in.peek() == JsonToken.STRING) {
                return 0;
            }
            Integer value = in.nextInt();
            return value;
        }
        catch (Exception e) {
            return -1;
        }
    }
}

