/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.net.util;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class GsonUtils {
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final Gson sLocalGson = GsonUtils.createLocalGson();

    private static GsonBuilder createLocalGsonBuilder() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setLenient();
        gsonBuilder.serializeNulls();
        gsonBuilder.setDateFormat(DATE_FORMAT);
        return gsonBuilder;
    }

    private static Gson createLocalGson() {
        return GsonUtils.createLocalGsonBuilder().create();
    }

    public static Gson getLocalGson() {
        return sLocalGson;
    }

    public static <T> T fromLocalJson(String json, Class<T> clazz) {
        try {
            return (T)sLocalGson.fromJson(json, clazz);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T fromLocalJson(String json, Type typeOfT) {
        try {
            return (T)sLocalGson.fromJson(json, typeOfT);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T fromJson(JsonElement json, Type typeOfT) {
        try {
            return (T)sLocalGson.fromJson(json, typeOfT);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String toJson(Object src) {
        return sLocalGson.toJson(src);
    }

    public static <T> List<T> fromJson2List(String json, Class<T> clazz) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return (List)sLocalGson.fromJson(json, TypeToken.getParameterized(ArrayList.class, (Type[])new Type[]{clazz}).getType());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

