/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.thridlib.glide;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.renderscript.RSRuntimeException;
import androidx.annotation.NonNull;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.xshare.base.thridlib.glide.FastBlur;
import com.xshare.base.thridlib.glide.RSBlur;
import java.security.MessageDigest;

public class BlurTransformation
extends BitmapTransformation {
    private Context mContext;
    private BitmapPool mBitmapPool;
    private int mRadius;
    private int mSampling;

    public BlurTransformation(Context context, int radius, int sampling) {
        this(context, Glide.get((Context)context).getBitmapPool(), radius, sampling);
    }

    public BlurTransformation(Context context, BitmapPool pool, int radius, int sampling) {
        this.mContext = context.getApplicationContext();
        this.mBitmapPool = pool;
        this.mRadius = radius;
        this.mSampling = sampling;
    }

    protected Bitmap transform(@NonNull BitmapPool pool, @NonNull Bitmap toTransform, int outWidth, int outHeight) {
        int height;
        int scaledHeight;
        Bitmap source = toTransform;
        int width = source.getWidth();
        int scaledWidth = width / this.mSampling;
        Bitmap bitmap = this.mBitmapPool.get(scaledWidth, scaledHeight = (height = source.getHeight()) / this.mSampling, Bitmap.Config.ARGB_8888);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.scale(1.0f / (float)this.mSampling, 1.0f / (float)this.mSampling);
        Paint paint = new Paint();
        paint.setFlags(2);
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
        if (Build.VERSION.SDK_INT >= 18) {
            try {
                bitmap = RSBlur.blur(this.mContext, bitmap, this.mRadius);
            }
            catch (RSRuntimeException e) {
                bitmap = FastBlur.blur(bitmap, this.mRadius, true);
            }
        } else {
            bitmap = FastBlur.blur(bitmap, this.mRadius, true);
        }
        return bitmap;
    }

    public void updateDiskCacheKey(MessageDigest messageDigest) {
    }
}

