/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.thridlib.glide;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import androidx.core.content.ContextCompat;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.bumptech.glide.load.resource.bitmap.CircleCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.xshare.base.thridlib.glide.BlurTransformation;
import com.xshare.base.utilExt.DisplayUtilsKt;
import com.xshare.trans.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a \u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a(\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f\u001a \u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a(\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0010"}, d2={"loadBlurImage", "", "imageView", "Landroid/widget/ImageView;", "url", "", "loadCircleImage", "defaultDrawable", "Landroid/graphics/drawable/Drawable;", "loadImage", "loadImageByTransform", "transformation", "Lcom/bumptech/glide/load/resource/bitmap/BitmapTransformation;", "loadRoundCornersImage", "corner", "", "app_release"})
public final class GlideUtilsKt {
    public static final void loadImage(@NotNull ImageView imageView, @Nullable String url, @NotNull Drawable defaultDrawable) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Intrinsics.checkNotNullParameter((Object)defaultDrawable, (String)"defaultDrawable");
        if (imageView.getContext() == null) {
            return;
        }
        BaseRequestOptions baseRequestOptions = ((RequestOptions)((RequestOptions)new RequestOptions().placeholder(defaultDrawable)).fallback(defaultDrawable)).error(defaultDrawable);
        Intrinsics.checkNotNullExpressionValue((Object)baseRequestOptions, (String)"RequestOptions() //\u56fe\u7247\u52a0\u8f7d\u51fa\u2026  .error(defaultDrawable)");
        RequestOptions options = (RequestOptions)baseRequestOptions;
        Glide.with((View)((View)imageView)).load(url).apply((BaseRequestOptions)options).into(imageView);
    }

    public static final void loadImageByTransform(@NotNull ImageView imageView, @Nullable String url, @NotNull Drawable defaultDrawable, @NotNull BitmapTransformation transformation) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Intrinsics.checkNotNullParameter((Object)defaultDrawable, (String)"defaultDrawable");
        Intrinsics.checkNotNullParameter((Object)transformation, (String)"transformation");
        if (imageView.getContext() == null) {
            return;
        }
        BaseRequestOptions baseRequestOptions = ((RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().placeholder(defaultDrawable)).fallback(defaultDrawable)).error(defaultDrawable)).transform((Transformation)transformation);
        Intrinsics.checkNotNullExpressionValue((Object)baseRequestOptions, (String)"RequestOptions() //\u56fe\u7247\u52a0\u8f7d\u51fa\u2026transform(transformation)");
        RequestOptions options = (RequestOptions)baseRequestOptions;
        Glide.with((View)((View)imageView)).load(url).apply((BaseRequestOptions)options).into(imageView);
    }

    public static final void loadImage(@NotNull ImageView imageView, @Nullable String url) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Drawable drawable2 = ContextCompat.getDrawable((Context)imageView.getContext(), (int)R.drawable.base_ic_default);
        if (drawable2 != null) {
            Drawable it = drawable2;
            boolean bl = false;
            GlideUtilsKt.loadImage(imageView, url, it);
        }
    }

    public static final void loadCircleImage(@NotNull ImageView imageView, @NotNull String url, @NotNull Drawable defaultDrawable) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)defaultDrawable, (String)"defaultDrawable");
        GlideUtilsKt.loadImageByTransform(imageView, url, defaultDrawable, (BitmapTransformation)new CircleCrop());
    }

    public static final void loadCircleImage(@NotNull ImageView imageView, @Nullable String url) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Drawable drawable2 = ContextCompat.getDrawable((Context)imageView.getContext(), (int)R.drawable.base_icon_default_circle);
        if (drawable2 != null) {
            Drawable it = drawable2;
            boolean bl = false;
            GlideUtilsKt.loadImageByTransform(imageView, url, it, (BitmapTransformation)new CircleCrop());
        }
    }

    public static final void loadRoundCornersImage(float corner, @NotNull ImageView imageView, @Nullable String url, @NotNull Drawable defaultDrawable) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Intrinsics.checkNotNullParameter((Object)defaultDrawable, (String)"defaultDrawable");
        GlideUtilsKt.loadImageByTransform(imageView, url, defaultDrawable, (BitmapTransformation)new RoundedCorners(DisplayUtilsKt.dip((View)imageView, corner)));
    }

    public static final void loadRoundCornersImage(float corner, @NotNull ImageView imageView, @Nullable String url) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        if (corner <= 0.0f) {
            GlideUtilsKt.loadImage(imageView, url);
            return;
        }
        Drawable drawable2 = ContextCompat.getDrawable((Context)imageView.getContext(), (int)R.drawable.base_ic_default);
        if (drawable2 != null) {
            Drawable it = drawable2;
            boolean bl = false;
            GlideUtilsKt.loadImageByTransform(imageView, url, it, (BitmapTransformation)new RoundedCorners(DisplayUtilsKt.dip((View)imageView, corner)));
        }
    }

    public static final void loadBlurImage(@NotNull ImageView imageView, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Drawable drawable2 = ContextCompat.getDrawable((Context)imageView.getContext(), (int)R.drawable.base_ic_default);
        if (drawable2 != null) {
            Drawable it = drawable2;
            boolean bl = false;
            GlideUtilsKt.loadImageByTransform(imageView, url, it, new BlurTransformation(imageView.getContext(), 25, 4));
        }
    }
}

