/*
 * Decompiled with CFR 0.152.
 */
package com.xshare.base.thridlib.lifecycle;

import android.util.LruCache;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.OnLifecycleEvent;
import com.xshare.base.thridlib.queue.DataQueue;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006\u000e\u000f\u0010\u0011\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/xshare/base/thridlib/lifecycle/LifecycleHelper;", "", "()V", "lifeLruCache", "Landroid/util/LruCache;", "Landroidx/lifecycle/Lifecycle;", "Lcom/xshare/base/thridlib/lifecycle/LifecycleHelper$DefaultLifecycleObserver;", "queryObserver", "lifecycle", "with", "fragment", "Landroidx/fragment/app/Fragment;", "fragmentActivity", "Landroidx/fragment/app/FragmentActivity;", "DefaultLifecycleObserver", "DestroyListener", "PauseListener", "ResumeListener", "StartListener", "StopListener", "app_release"})
public final class LifecycleHelper {
    @NotNull
    public static final LifecycleHelper INSTANCE = new LifecycleHelper();
    @NotNull
    private static final LruCache<Lifecycle, DefaultLifecycleObserver> lifeLruCache = new LruCache(100);

    private LifecycleHelper() {
    }

    @NotNull
    public final DefaultLifecycleObserver with(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Lifecycle lifecycle = fragment.getLifecycle();
        Intrinsics.checkNotNullExpressionValue((Object)lifecycle, (String)"fragment.lifecycle");
        return this.queryObserver(lifecycle);
    }

    @JvmStatic
    @NotNull
    public static final DefaultLifecycleObserver with(@NotNull FragmentActivity fragmentActivity) {
        Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"fragmentActivity");
        Lifecycle lifecycle = fragmentActivity.getLifecycle();
        Intrinsics.checkNotNullExpressionValue((Object)lifecycle, (String)"fragmentActivity.lifecycle");
        return INSTANCE.queryObserver(lifecycle);
    }

    @NotNull
    public final DefaultLifecycleObserver queryObserver(@NotNull Lifecycle lifecycle) {
        Intrinsics.checkNotNullParameter((Object)lifecycle, (String)"lifecycle");
        DefaultLifecycleObserver observer = (DefaultLifecycleObserver)lifeLruCache.get((Object)lifecycle);
        if (observer == null) {
            observer = new DefaultLifecycleObserver(lifecycle);
            lifeLruCache.put((Object)lifecycle, (Object)observer);
        }
        return observer;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u000bJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\rJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u000fJ\b\u0010\u001a\u001a\u00020\u001bH\u0007J\b\u0010\u001c\u001a\u00020\u001bH\u0007J\b\u0010\u001d\u001a\u00020\u001bH\u0007J\b\u0010\u001e\u001a\u00020\u001bH\u0007J\b\u0010\u001f\u001a\u00020\u001bH\u0007J\b\u0010 \u001a\u00020\u001bH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/xshare/base/thridlib/lifecycle/LifecycleHelper$DefaultLifecycleObserver;", "Landroidx/lifecycle/LifecycleObserver;", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "(Landroidx/lifecycle/Lifecycle;)V", "destroyListenerQueue", "Lcom/xshare/base/thridlib/queue/DataQueue;", "Lcom/xshare/base/thridlib/lifecycle/LifecycleHelper$DestroyListener;", "pauseListenerQueue", "Lcom/xshare/base/thridlib/lifecycle/LifecycleHelper$PauseListener;", "resumeListenerQueue", "Lcom/xshare/base/thridlib/lifecycle/LifecycleHelper$ResumeListener;", "startListenerQueue", "Lcom/xshare/base/thridlib/lifecycle/LifecycleHelper$StartListener;", "stopListenerQueue", "Lcom/xshare/base/thridlib/lifecycle/LifecycleHelper$StopListener;", "addDestroyListener", "destroyListener", "addPauseListener", "pauseListener", "addResumeListener", "resumeListener", "addStartListener", "startListener", "addStopListener", "stopListener", "onDestroy", "", "onPause", "onResume", "onStart", "onStop", "release", "app_release"})
    public static final class DefaultLifecycleObserver
    implements LifecycleObserver {
        @NotNull
        private final Lifecycle lifecycle;
        @NotNull
        private final DataQueue<StartListener> startListenerQueue;
        @NotNull
        private final DataQueue<ResumeListener> resumeListenerQueue;
        @NotNull
        private final DataQueue<PauseListener> pauseListenerQueue;
        @NotNull
        private final DataQueue<StopListener> stopListenerQueue;
        @NotNull
        private final DataQueue<DestroyListener> destroyListenerQueue;

        public DefaultLifecycleObserver(@NotNull Lifecycle lifecycle) {
            Intrinsics.checkNotNullParameter((Object)lifecycle, (String)"lifecycle");
            this.startListenerQueue = new DataQueue();
            this.resumeListenerQueue = new DataQueue();
            this.pauseListenerQueue = new DataQueue();
            this.stopListenerQueue = new DataQueue();
            this.destroyListenerQueue = new DataQueue();
            this.lifecycle = lifecycle;
            this.lifecycle.addObserver((LifecycleObserver)this);
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_START)
        public final void onStart() {
            this.startListenerQueue.forEach(new DataQueue.Each<StartListener>(){

                public void each(@NotNull StartListener data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    data.IStart();
                }
            });
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
        public final void onResume() {
            this.resumeListenerQueue.forEach(new DataQueue.Each<ResumeListener>(){

                public void each(@NotNull ResumeListener data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    data.IResume();
                }
            });
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_PAUSE)
        public final void onPause() {
            this.pauseListenerQueue.forEach(new DataQueue.Each<PauseListener>(){

                public void each(@NotNull PauseListener data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    data.IPause();
                }
            });
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
        public final void onStop() {
            this.stopListenerQueue.forEach(new DataQueue.Each<StopListener>(){

                public void each(@NotNull StopListener data) {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    data.IStop();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
        public final void onDestroy() {
            try {
                this.destroyListenerQueue.forEach(new DataQueue.Each<DestroyListener>(){

                    public void each(@NotNull DestroyListener data) {
                        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                        data.IDestroy();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.release();
            }
        }

        private final void release() {
            lifeLruCache.remove((Object)this.lifecycle);
            this.lifecycle.removeObserver((LifecycleObserver)this);
            this.startListenerQueue.release();
            this.resumeListenerQueue.release();
            this.pauseListenerQueue.release();
            this.stopListenerQueue.release();
            this.destroyListenerQueue.release();
        }

        @NotNull
        public final DefaultLifecycleObserver addDestroyListener(@NotNull DestroyListener destroyListener) {
            Intrinsics.checkNotNullParameter((Object)destroyListener, (String)"destroyListener");
            this.destroyListenerQueue.add(destroyListener);
            return this;
        }

        @NotNull
        public final DefaultLifecycleObserver addResumeListener(@NotNull ResumeListener resumeListener) {
            Intrinsics.checkNotNullParameter((Object)resumeListener, (String)"resumeListener");
            this.resumeListenerQueue.add(resumeListener);
            return this;
        }

        @NotNull
        public final DefaultLifecycleObserver addPauseListener(@NotNull PauseListener pauseListener) {
            Intrinsics.checkNotNullParameter((Object)pauseListener, (String)"pauseListener");
            this.pauseListenerQueue.add(pauseListener);
            return this;
        }

        @NotNull
        public final DefaultLifecycleObserver addStartListener(@NotNull StartListener startListener) {
            Intrinsics.checkNotNullParameter((Object)startListener, (String)"startListener");
            this.startListenerQueue.add(startListener);
            return this;
        }

        @NotNull
        public final DefaultLifecycleObserver addStopListener(@NotNull StopListener stopListener) {
            Intrinsics.checkNotNullParameter((Object)stopListener, (String)"stopListener");
            this.stopListenerQueue.add(stopListener);
            return this;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/xshare/base/thridlib/lifecycle/LifecycleHelper$DestroyListener;", "", "IDestroy", "", "app_release"})
    public static interface DestroyListener {
        public void IDestroy();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/xshare/base/thridlib/lifecycle/LifecycleHelper$StopListener;", "", "IStop", "", "app_release"})
    public static interface StopListener {
        public void IStop();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/xshare/base/thridlib/lifecycle/LifecycleHelper$PauseListener;", "", "IPause", "", "app_release"})
    public static interface PauseListener {
        public void IPause();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/xshare/base/thridlib/lifecycle/LifecycleHelper$ResumeListener;", "", "IResume", "", "app_release"})
    public static interface ResumeListener {
        public void IResume();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/xshare/base/thridlib/lifecycle/LifecycleHelper$StartListener;", "", "IStart", "", "app_release"})
    public static interface StartListener {
        public void IStart();
    }
}

